/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils;

import java.math.BigInteger;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.utils.a;
import org.apache.xml.security.utils.d;
import org.apache.xml.security.utils.o;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class c {
    static Log log = LogFactory.getLog((String)(acH == null ? (acH = c.class$("org.apache.xml.security.utils.c")) : acH).getName());
    public static final int MODE_CREATE = 0;
    public static final int MODE_PROCESS = 1;
    public static final int MODE_UNKNOWN = 2;
    public static final int MODE_SIGN = 0;
    public static final int MODE_VERIFY = 1;
    public static final int MODE_ENCRYPT = 0;
    public static final int MODE_DECRYPT = 1;
    protected int _state = 2;
    protected Element _constructionElement = null;
    protected String _baseURI = null;
    protected Document _doc = null;
    static HashMap acF = new HashMap();
    static HashMap acG = new HashMap();
    static Class acH;

    public abstract String getBaseNamespace();

    public abstract String getBaseLocalName();

    public c() {
    }

    public c(Document document) {
        if (document == null) {
            throw new RuntimeException("Document is null");
        }
        this._doc = document;
        this._state = 0;
        this._constructionElement = this.createElementForFamilyLocal(this._doc, this.getBaseNamespace(), this.getBaseLocalName());
    }

    protected Element createElementForFamilyLocal(Document document, String string, String string2) {
        Element element = null;
        if (string == null) {
            element = document.createElementNS(null, string2);
        } else {
            String string3 = this.getBaseNamespace();
            String string4 = c.getDefaultPrefix(string3);
            if (string4 == null || string4.length() == 0) {
                element = document.createElementNS(string, string2);
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", string);
            } else {
                String string5 = null;
                String string6 = c.getDefaultPrefixBindings(string3);
                StringBuffer stringBuffer = new StringBuffer(string4);
                stringBuffer.append(':');
                stringBuffer.append(string2);
                string5 = stringBuffer.toString();
                element = document.createElementNS(string, string5);
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", string6, string);
            }
        }
        return element;
    }

    public static Element createElementForFamily(Document document, String string, String string2) {
        Element element = null;
        String string3 = c.getDefaultPrefix(string);
        if (string == null) {
            element = document.createElementNS(null, string2);
        } else if (string3 == null || string3.length() == 0) {
            element = document.createElementNS(string, string2);
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", string);
        } else {
            element = document.createElementNS(string, string3 + ":" + string2);
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", c.getDefaultPrefixBindings(string), string);
        }
        return element;
    }

    public void setElement(Element element, String string) {
        if (element == null) {
            throw new org.apache.xml.security.d.c("ElementProxy.nullElement");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("setElement(" + element.getTagName() + ", \"" + string + "\""));
        }
        this._doc = element.getOwnerDocument();
        this._state = 1;
        this._constructionElement = element;
        this._baseURI = string;
    }

    public c(Element element, String string) {
        if (element == null) {
            throw new org.apache.xml.security.d.c("ElementProxy.nullElement");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("setElement(\"" + element.getTagName() + "\", \"" + string + "\")"));
        }
        this._doc = element.getOwnerDocument();
        this._state = 1;
        this._constructionElement = element;
        this._baseURI = string;
        this.guaranteeThatElementInCorrectSpace();
    }

    public final Element getElement() {
        return this._constructionElement;
    }

    public final NodeList getElementPlusReturns() {
        d d2 = new d();
        d2.appendChild(this._doc.createTextNode("\n"));
        d2.appendChild(this.getElement());
        d2.appendChild(this._doc.createTextNode("\n"));
        return d2;
    }

    public Document getDocument() {
        return this._doc;
    }

    public String getBaseURI() {
        return this._baseURI;
    }

    public void guaranteeThatElementInCorrectSpace() {
        String string = this.getBaseLocalName();
        String string2 = this.getBaseNamespace();
        String string3 = this._constructionElement.getLocalName();
        String string4 = this._constructionElement.getNamespaceURI();
        if (string2 != string4 || !string.equals(string3)) {
            Object[] objectArray = new Object[]{string4 + ":" + string3, string2 + ":" + string};
            throw new org.apache.xml.security.d.c("xml.WrongElement", objectArray);
        }
    }

    public void addBigIntegerElement(BigInteger bigInteger, String string) {
        if (bigInteger != null) {
            Element element = o.createElementInSignatureSpace(this._doc, string);
            a.fillElementWithBigInteger(element, bigInteger);
            this._constructionElement.appendChild(element);
            o.addReturnToElement(this._constructionElement);
        }
    }

    public void addBase64Element(byte[] byArray, String string) {
        if (byArray != null) {
            Element element = a.encodeToElement(this._doc, string, byArray);
            this._constructionElement.appendChild(element);
            this._constructionElement.appendChild(this._doc.createTextNode("\n"));
        }
    }

    public void addTextElement(String string, String string2) {
        Element element = o.createElementInSignatureSpace(this._doc, string2);
        Text text = this._doc.createTextNode(string);
        element.appendChild(text);
        this._constructionElement.appendChild(element);
        o.addReturnToElement(this._constructionElement);
    }

    public void addBase64Text(byte[] byArray) {
        if (byArray != null) {
            Text text = this._doc.createTextNode("\n" + a.encode(byArray) + "\n");
            this._constructionElement.appendChild(text);
        }
    }

    public void addText(String string) {
        if (string != null) {
            Text text = this._doc.createTextNode(string);
            this._constructionElement.appendChild(text);
        }
    }

    public BigInteger getBigIntegerFromChildElement(String string, String string2) {
        return a.decodeBigIntegerFromText(o.selectNodeText(this._constructionElement.getFirstChild(), string2, string, 0));
    }

    public byte[] getBytesFromChildElement(String string, String string2) {
        Element element = o.selectNode(this._constructionElement.getFirstChild(), string2, string, 0);
        return a.decode(element);
    }

    public String getTextFromChildElement(String string, String string2) {
        Text text = (Text)o.selectNode(this._constructionElement.getFirstChild(), string2, string, 0).getFirstChild();
        return text.getData();
    }

    public byte[] getBytesFromTextChild() {
        Text text = (Text)this._constructionElement.getFirstChild();
        return a.decode(text.getData());
    }

    public String getTextFromTextChild() {
        return o.getFullTextChildrenFromElement(this._constructionElement);
    }

    public int length(String string, String string2) {
        int n2 = 0;
        for (Node node = this._constructionElement.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!string2.equals(node.getLocalName()) || string != node.getNamespaceURI()) continue;
            ++n2;
        }
        return n2;
    }

    public void setXPathNamespaceContext(String string, String string2) {
        if (string == null || string.length() == 0) {
            throw new org.apache.xml.security.d.c("defaultNamespaceCannotBeSetHere");
        }
        if (string.equals("xmlns")) {
            throw new org.apache.xml.security.d.c("defaultNamespaceCannotBeSetHere");
        }
        String string3 = string.startsWith("xmlns:") ? string : "xmlns:" + string;
        Attr attr = this._constructionElement.getAttributeNodeNS("http://www.w3.org/2000/xmlns/", string3);
        if (attr != null) {
            if (!attr.getNodeValue().equals(string2)) {
                Object[] objectArray = new Object[]{string3, this._constructionElement.getAttributeNS(null, string3)};
                throw new org.apache.xml.security.d.c("namespacePrefixAlreadyUsedByOtherURI", objectArray);
            }
            return;
        }
        this._constructionElement.setAttributeNS("http://www.w3.org/2000/xmlns/", string3, string2);
    }

    public static void setDefaultPrefix(String string, String string2) {
        Object v2;
        if (acF.containsValue(string2) && !(v2 = acF.get(string)).equals(string2)) {
            Object[] objectArray = new Object[]{string2, string, v2};
            throw new org.apache.xml.security.d.c("prefix.AlreadyAssigned", objectArray);
        }
        if ("http://www.w3.org/2000/09/xmldsig#".equals(string)) {
            o.adb = string2;
            o.adc = "xmlns:" + string2;
        }
        acF.put(string, string2.intern());
        acG.put(string, ("xmlns:" + string2).intern());
    }

    public static String getDefaultPrefix(String string) {
        String string2 = (String)acF.get(string);
        return string2;
    }

    public static String getDefaultPrefixBindings(String string) {
        String string2 = (String)acG.get(string);
        return string2;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

