/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils;

import java.io.IOException;
import java.io.StringReader;

public class RFC2253Parser {
    static boolean acY = true;
    static int counter = 0;

    public static String rfc2253toXMLdsig(String string) {
        acY = true;
        String string2 = RFC2253Parser.normalize(string);
        return RFC2253Parser.rfctoXML(string2);
    }

    public static String xmldsigtoRFC2253(String string) {
        acY = false;
        String string2 = RFC2253Parser.normalize(string);
        return RFC2253Parser.xmltoRFC(string2);
    }

    public static String normalize(String string) {
        if (string == null || string.equals("")) {
            return "";
        }
        try {
            int n2;
            String string2 = RFC2253Parser.semicolonToComma(string);
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while ((n2 = string2.indexOf(",", n5)) >= 0) {
                if (n2 > 0 && string2.charAt(n2 - 1) != '\\' && (n4 += RFC2253Parser.countQuotes(string2, n5, n2)) % 2 != 1) {
                    stringBuffer.append(RFC2253Parser.aG(string2.substring(n3, n2).trim()) + ",");
                    n3 = n2 + 1;
                    n4 = 0;
                }
                n5 = n2 + 1;
            }
            stringBuffer.append(RFC2253Parser.aG(RFC2253Parser.trim(string2.substring(n3))));
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            return string;
        }
    }

    static String aG(String string) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while ((n2 = string.indexOf("+", n5)) >= 0) {
            if (n2 > 0 && string.charAt(n2 - 1) != '\\' && (n4 += RFC2253Parser.countQuotes(string, n5, n2)) % 2 != 1) {
                stringBuffer.append(RFC2253Parser.aH(RFC2253Parser.trim(string.substring(n3, n2))) + "+");
                n3 = n2 + 1;
                n4 = 0;
            }
            n5 = n2 + 1;
        }
        stringBuffer.append(RFC2253Parser.aH(RFC2253Parser.trim(string.substring(n3))));
        return stringBuffer.toString();
    }

    static String aH(String string) {
        int n2 = string.indexOf("=");
        if (n2 == -1 || n2 > 0 && string.charAt(n2 - 1) == '\\') {
            return string;
        }
        String string2 = RFC2253Parser.normalizeAT(string.substring(0, n2));
        String string3 = RFC2253Parser.aI(string.substring(n2 + 1));
        return string2 + "=" + string3;
    }

    static String normalizeAT(String string) {
        String string2 = string.toUpperCase().trim();
        if (string2.startsWith("OID")) {
            string2 = string2.substring(3);
        }
        return string2;
    }

    static String aI(String string) {
        String string2 = RFC2253Parser.trim(string);
        if (string2.startsWith("\"")) {
            StringBuffer stringBuffer = new StringBuffer();
            StringReader stringReader = new StringReader(string2.substring(1, string2.length() - 1));
            int n2 = 0;
            while ((n2 = stringReader.read()) > -1) {
                char c2 = (char)n2;
                if (c2 == ',' || c2 == '=' || c2 == '+' || c2 == '<' || c2 == '>' || c2 == '#' || c2 == ';') {
                    stringBuffer.append('\\');
                }
                stringBuffer.append(c2);
            }
            string2 = RFC2253Parser.trim(stringBuffer.toString());
        }
        if (acY) {
            if (string2.startsWith("#")) {
                string2 = '\\' + string2;
            }
        } else if (string2.startsWith("\\#")) {
            string2 = string2.substring(1);
        }
        return string2;
    }

    static String rfctoXML(String string) {
        try {
            String string2 = RFC2253Parser.changeLess32toXML(string);
            return RFC2253Parser.changeWStoXML(string2);
        }
        catch (Exception exception) {
            return string;
        }
    }

    static String xmltoRFC(String string) {
        try {
            String string2 = RFC2253Parser.changeLess32toRFC(string);
            return RFC2253Parser.changeWStoRFC(string2);
        }
        catch (Exception exception) {
            return string;
        }
    }

    static String changeLess32toRFC(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringReader stringReader = new StringReader(string);
        int n2 = 0;
        while ((n2 = stringReader.read()) > -1) {
            char c2 = (char)n2;
            if (c2 == '\\') {
                stringBuffer.append(c2);
                char c3 = (char)stringReader.read();
                char c4 = (char)stringReader.read();
                if ((c3 >= '0' && c3 <= '9' || c3 >= 'A' && c3 <= 'F' || c3 >= 'a' && c3 <= 'f') && (c4 >= '0' && c4 <= '9' || c4 >= 'A' && c4 <= 'F' || c4 >= 'a' && c4 <= 'f')) {
                    char c5 = (char)Byte.parseByte("" + c3 + c4, 16);
                    stringBuffer.append(c5);
                    continue;
                }
                stringBuffer.append(c3);
                stringBuffer.append(c4);
                continue;
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    static String changeLess32toXML(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringReader stringReader = new StringReader(string);
        int n2 = 0;
        while ((n2 = stringReader.read()) > -1) {
            if (n2 < 32) {
                stringBuffer.append('\\');
                stringBuffer.append(Integer.toHexString(n2));
                continue;
            }
            stringBuffer.append((char)n2);
        }
        return stringBuffer.toString();
    }

    static String changeWStoXML(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringReader stringReader = new StringReader(string);
        int n2 = 0;
        while ((n2 = stringReader.read()) > -1) {
            char c2 = (char)n2;
            if (c2 == '\\') {
                char c3 = (char)stringReader.read();
                if (c3 == ' ') {
                    stringBuffer.append('\\');
                    String string2 = "20";
                    stringBuffer.append(string2);
                    continue;
                }
                stringBuffer.append('\\');
                stringBuffer.append(c3);
                continue;
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    static String changeWStoRFC(String string) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        int n4 = 0;
        while ((n2 = string.indexOf("\\20", n4)) >= 0) {
            stringBuffer.append(RFC2253Parser.trim(string.substring(n3, n2)) + "\\ ");
            n3 = n2 + 3;
            n4 = n2 + 3;
        }
        stringBuffer.append(string.substring(n3));
        return stringBuffer.toString();
    }

    static String semicolonToComma(String string) {
        return RFC2253Parser.removeWSandReplace(string, ";", ",");
    }

    static String removeWSandReplace(String string, String string2, String string3) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while ((n2 = string.indexOf(string2, n5)) >= 0) {
            if (n2 > 0 && string.charAt(n2 - 1) != '\\' && (n4 += RFC2253Parser.countQuotes(string, n5, n2)) % 2 != 1) {
                stringBuffer.append(RFC2253Parser.trim(string.substring(n3, n2)) + string3);
                n3 = n2 + 1;
                n4 = 0;
            }
            n5 = n2 + 1;
        }
        stringBuffer.append(RFC2253Parser.trim(string.substring(n3)));
        return stringBuffer.toString();
    }

    private static int countQuotes(String string, int n2, int n3) {
        int n4 = 0;
        for (int i2 = n2; i2 < n3; ++i2) {
            if (string.charAt(i2) != '\"') continue;
            ++n4;
        }
        return n4;
    }

    static String trim(String string) {
        String string2 = string.trim();
        int n2 = string.indexOf(string2) + string2.length();
        if (string.length() > n2 && string2.endsWith("\\") && !string2.endsWith("\\\\") && string.charAt(n2) == ' ') {
            string2 = string2 + " ";
        }
        return string2;
    }

    public static void main(String[] stringArray) {
        RFC2253Parser.aJ("CN=\"Steve, Kille\",  O=Isode Limited, C=GB");
        RFC2253Parser.aJ("CN=Steve Kille    ,   O=Isode Limited,C=GB");
        RFC2253Parser.aJ("\\ OU=Sales+CN=J. Smith,O=Widget Inc.,C=US\\ \\ ");
        RFC2253Parser.aJ("CN=L. Eagle,O=Sue\\, Grabbit and Runn,C=GB");
        RFC2253Parser.aJ("CN=Before\\0DAfter,O=Test,C=GB");
        RFC2253Parser.aJ("CN=\"L. Eagle,O=Sue, = + < > # ;Grabbit and Runn\",C=GB");
        RFC2253Parser.aJ("1.3.6.1.4.1.1466.0=#04024869,O=Test,C=GB");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('L');
        stringBuffer.append('u');
        stringBuffer.append('\uc48d');
        stringBuffer.append('i');
        stringBuffer.append('\uc487');
        String string = "SN=" + stringBuffer.toString();
        RFC2253Parser.aJ(string);
        RFC2253Parser.aK("CN=\"Steve, Kille\",  O=Isode Limited, C=GB");
        RFC2253Parser.aK("CN=Steve Kille    ,   O=Isode Limited,C=GB");
        RFC2253Parser.aK("\\20OU=Sales+CN=J. Smith,O=Widget Inc.,C=US\\20\\20 ");
        RFC2253Parser.aK("CN=L. Eagle,O=Sue\\, Grabbit and Runn,C=GB");
        RFC2253Parser.aK("CN=Before\\12After,O=Test,C=GB");
        RFC2253Parser.aK("CN=\"L. Eagle,O=Sue, = + < > # ;Grabbit and Runn\",C=GB");
        RFC2253Parser.aK("1.3.6.1.4.1.1466.0=\\#04024869,O=Test,C=GB");
        stringBuffer = new StringBuffer();
        stringBuffer.append('L');
        stringBuffer.append('u');
        stringBuffer.append('\uc48d');
        stringBuffer.append('i');
        stringBuffer.append('\uc487');
        string = "SN=" + stringBuffer.toString();
        RFC2253Parser.aK(string);
    }

    static void aJ(String string) {
        System.out.println("start " + counter++ + ": " + string);
        System.out.println("         " + RFC2253Parser.rfc2253toXMLdsig(string));
        System.out.println("");
    }

    static void aK(String string) {
        System.out.println("start " + counter++ + ": " + string);
        System.out.println("         " + RFC2253Parser.xmldsigtoRFC2253(string));
        System.out.println("");
    }
}

