/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.storage.implementations;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.keys.a.b.d;
import org.apache.xml.security.keys.storage.b;
import org.apache.xml.security.keys.storage.c;

public class CertsInFilesystemDirectoryResolver
extends c {
    static Log log = LogFactory.getLog((String)(abL == null ? (abL = CertsInFilesystemDirectoryResolver.class$("org.apache.xml.security.keys.storage.implementations.CertsInFilesystemDirectoryResolver")) : abL).getName());
    String abK = null;
    private List _certs = new ArrayList();
    Iterator abH = null;
    static Class abL;

    public CertsInFilesystemDirectoryResolver(String string) {
        this.abK = string;
        this.eG();
        this.abH = new a(this._certs);
    }

    private void eG() {
        File file = new File(this.abK);
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = file.list();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            if (!string.endsWith(".crt")) continue;
            arrayList.add(stringArray[i2]);
        }
        CertificateFactory certificateFactory = null;
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            throw new b("empty", certificateException);
        }
        if (certificateFactory == null) {
            throw new b("empty");
        }
        for (int i3 = 0; i3 < arrayList.size(); ++i3) {
            String string = file.getAbsolutePath() + File.separator + (String)arrayList.get(i3);
            File file2 = new File(string);
            boolean bl = false;
            String string2 = null;
            try {
                FileInputStream fileInputStream = new FileInputStream(file2);
                X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(fileInputStream);
                fileInputStream.close();
                x509Certificate.checkValidity();
                this._certs.add(x509Certificate);
                string2 = x509Certificate.getSubjectDN().getName();
                bl = true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                log.debug((Object)("Could not add certificate from file " + string), (Throwable)fileNotFoundException);
            }
            catch (IOException iOException) {
                log.debug((Object)("Could not add certificate from file " + string), (Throwable)iOException);
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                log.debug((Object)("Could not add certificate from file " + string), (Throwable)certificateNotYetValidException);
            }
            catch (CertificateExpiredException certificateExpiredException) {
                log.debug((Object)("Could not add certificate from file " + string), (Throwable)certificateExpiredException);
            }
            catch (CertificateException certificateException) {
                log.debug((Object)("Could not add certificate from file " + string), (Throwable)certificateException);
            }
            if (!bl || !log.isDebugEnabled()) continue;
            log.debug((Object)("Added certificate: " + string2));
        }
    }

    public Iterator getIterator() {
        return this.abH;
    }

    public static void main(String[] stringArray) {
        CertsInFilesystemDirectoryResolver certsInFilesystemDirectoryResolver = new CertsInFilesystemDirectoryResolver("data/ie/baltimore/merlin-examples/merlin-xmldsig-eighteen/certs");
        Iterator iterator = certsInFilesystemDirectoryResolver.getIterator();
        while (iterator.hasNext()) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            byte[] byArray = d.getSKIBytesFromCert(x509Certificate);
            System.out.println();
            System.out.println("Base64(SKI())=                 \"" + org.apache.xml.security.utils.a.encode(byArray) + "\"");
            System.out.println("cert.getSerialNumber()=        \"" + x509Certificate.getSerialNumber().toString() + "\"");
            System.out.println("cert.getSubjectDN().getName()= \"" + x509Certificate.getSubjectDN().getName() + "\"");
            System.out.println("cert.getIssuerDN().getName()=  \"" + x509Certificate.getIssuerDN().getName() + "\"");
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class a
    implements Iterator {
        List _certs = null;
        int _i;

        public a(List list) {
            this._certs = list;
            this._i = 0;
        }

        public boolean hasNext() {
            return this._i < this._certs.size();
        }

        public Object next() {
            return this._certs.get(this._i++);
        }

        public void remove() {
            throw new UnsupportedOperationException("Can't remove keys from KeyStore");
        }
    }
}

