/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.keyresolver;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import org.apache.xml.security.keys.keyresolver.b;
import org.apache.xml.security.keys.storage.a;
import org.w3c.dom.Element;

public abstract class KeyResolverSpi {
    protected Map _properties = null;
    protected boolean globalResolver = false;

    public boolean engineCanResolve(Element element, String string, a a2) {
        throw new UnsupportedOperationException();
    }

    public PublicKey engineResolvePublicKey(Element element, String string, a a2) {
        throw new UnsupportedOperationException();
    }

    public PublicKey engineLookupAndResolvePublicKey(Element element, String string, a a2) {
        KeyResolverSpi keyResolverSpi = this.cloneIfNeeded();
        if (!keyResolverSpi.engineCanResolve(element, string, a2)) {
            return null;
        }
        return keyResolverSpi.engineResolvePublicKey(element, string, a2);
    }

    private KeyResolverSpi cloneIfNeeded() {
        KeyResolverSpi keyResolverSpi = this;
        if (this.globalResolver) {
            try {
                keyResolverSpi = (KeyResolverSpi)this.getClass().newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new b("", instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new b("", illegalAccessException);
            }
        }
        return keyResolverSpi;
    }

    public X509Certificate engineResolveX509Certificate(Element element, String string, a a2) {
        throw new UnsupportedOperationException();
    }

    public X509Certificate engineLookupResolveX509Certificate(Element element, String string, a a2) {
        KeyResolverSpi keyResolverSpi = this.cloneIfNeeded();
        if (!keyResolverSpi.engineCanResolve(element, string, a2)) {
            return null;
        }
        return keyResolverSpi.engineResolveX509Certificate(element, string, a2);
    }

    public SecretKey engineResolveSecretKey(Element element, String string, a a2) {
        throw new UnsupportedOperationException();
    }

    public SecretKey engineLookupAndResolveSecretKey(Element element, String string, a a2) {
        KeyResolverSpi keyResolverSpi = this.cloneIfNeeded();
        if (!keyResolverSpi.engineCanResolve(element, string, a2)) {
            return null;
        }
        return keyResolverSpi.engineResolveSecretKey(element, string, a2);
    }

    public void engineSetProperty(String string, String string2) {
        if (this._properties == null) {
            this._properties = new HashMap();
        }
        this._properties.put(string, string2);
    }

    public String engineGetProperty(String string) {
        if (this._properties == null) {
            return null;
        }
        return (String)this._properties.get(string);
    }

    public boolean understandsProperty(String string) {
        if (this._properties == null) {
            return false;
        }
        return this._properties.get(string) != null;
    }

    public void setGlobalResolver(boolean bl) {
        this.globalResolver = bl;
    }
}

