/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.a.b;

import java.io.ByteArrayInputStream;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.xml.security.d.c;
import org.apache.xml.security.utils.i;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class b
extends i {
    public static final String JCA_CERT_ID = "X.509";

    public b(Element element, String string) {
        super(element, string);
    }

    public b(Document document, byte[] byArray) {
        super(document);
        this.addBase64Text(byArray);
    }

    public b(Document document, X509Certificate x509Certificate) {
        super(document);
        try {
            this.addBase64Text(x509Certificate.getEncoded());
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new c("empty", certificateEncodingException);
        }
    }

    public byte[] getCertificateBytes() {
        return this.getBytesFromTextChild();
    }

    public X509Certificate getX509Certificate() {
        try {
            byte[] byArray = this.getCertificateBytes();
            CertificateFactory certificateFactory = CertificateFactory.getInstance(JCA_CERT_ID);
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
            if (x509Certificate != null) {
                return x509Certificate;
            }
            return null;
        }
        catch (CertificateException certificateException) {
            throw new c("empty", certificateException);
        }
    }

    public PublicKey getPublicKey() {
        X509Certificate x509Certificate = this.getX509Certificate();
        if (x509Certificate != null) {
            return x509Certificate.getPublicKey();
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!this.getClass().getName().equals(object.getClass().getName())) {
            return false;
        }
        b b2 = (b)object;
        try {
            return MessageDigest.isEqual(b2.getCertificateBytes(), this.getCertificateBytes());
        }
        catch (c c2) {
            return false;
        }
    }

    public int hashCode() {
        return 72;
    }

    public String getBaseLocalName() {
        return "X509Certificate";
    }
}

