/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.c;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.c.c;
import org.apache.xml.security.c.d;
import org.apache.xml.security.c.e;
import org.apache.xml.security.c.f;
import org.apache.xml.security.c.h;
import org.apache.xml.security.c.i;
import org.apache.xml.security.c.j;
import org.apache.xml.security.c.k;
import org.apache.xml.security.c.l;
import org.apache.xml.security.c.m;
import org.apache.xml.security.c.o;
import org.apache.xml.security.c.p;
import org.apache.xml.utils.URI;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class n {
    private static Log logger = LogFactory.getLog((String)(aaN == null ? (aaN = n.class$("org.apache.xml.security.c.n")) : aaN).getName());
    public static final String TRIPLEDES = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
    public static final String AES_128 = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
    public static final String AES_256 = "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
    public static final String AES_192 = "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
    public static final String RSA_v1dot5 = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
    public static final String RSA_OAEP = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
    public static final String DIFFIE_HELLMAN = "http://www.w3.org/2001/04/xmlenc#dh";
    public static final String TRIPLEDES_KeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
    public static final String AES_128_KeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes128";
    public static final String AES_256_KeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes256";
    public static final String AES_192_KeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes192";
    public static final String SHA1 = "http://www.w3.org/2000/09/xmldsig#sha1";
    public static final String SHA256 = "http://www.w3.org/2001/04/xmlenc#sha256";
    public static final String SHA512 = "http://www.w3.org/2001/04/xmlenc#sha512";
    public static final String RIPEMD_160 = "http://www.w3.org/2001/04/xmlenc#ripemd160";
    public static final String XML_DSIG = "http://www.w3.org/2000/09/xmldsig#";
    public static final String N14C_XML = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    public static final String N14C_XML_WITH_COMMENTS = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments";
    public static final String EXCL_XML_N14C = "http://www.w3.org/2001/10/xml-exc-c14n#";
    public static final String EXCL_XML_N14C_WITH_COMMENTS = "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";
    public static final String BASE64_ENCODING = "http://www.w3.org/2000/09/xmldsig#base64";
    public static final int ENCRYPT_MODE = 1;
    public static final int DECRYPT_MODE = 2;
    public static final int UNWRAP_MODE = 4;
    public static final int WRAP_MODE = 3;
    private Cipher aaB;
    private int aaC = Integer.MIN_VALUE;
    private String aaD = null;
    private String aaE = null;
    private org.apache.xml.security.b.b aaF;
    private Document aaG;
    private a aaH;
    private b aaI;
    private Key aaJ;
    private Key aaK;
    private f aaL;
    private e aaM;
    static Class aaN;
    static Class aaO;
    static Class aaP;

    private n() {
        logger.debug((Object)"Constructing XMLCipher...");
        this.aaH = new a(this, null);
        this.aaI = new b(this);
    }

    private static boolean ay(String string) {
        boolean bl = string.equals(TRIPLEDES) || string.equals(AES_128) || string.equals(AES_256) || string.equals(AES_192) || string.equals(RSA_v1dot5) || string.equals(RSA_OAEP) || string.equals(TRIPLEDES_KeyWrap) || string.equals(AES_128_KeyWrap) || string.equals(AES_256_KeyWrap) || string.equals(AES_192_KeyWrap);
        return bl;
    }

    public static n getInstance(String string) {
        logger.debug((Object)"Getting XMLCipher...");
        if (null == string) {
            logger.error((Object)"Transformation unexpectedly null...");
        }
        if (!n.ay(string)) {
            logger.warn((Object)"Algorithm non-standard, expected one of http://www.w3.org/2001/04/xmlenc#tripledes-cbc\nhttp://www.w3.org/2001/04/xmlenc#aes128-cbc\nhttp://www.w3.org/2001/04/xmlenc#aes256-cbc\nhttp://www.w3.org/2001/04/xmlenc#aes192-cbc\nhttp://www.w3.org/2001/04/xmlenc#rsa-1_5\nhttp://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p\nhttp://www.w3.org/2001/04/xmlenc#kw-tripledes\nhttp://www.w3.org/2001/04/xmlenc#kw-aes128\nhttp://www.w3.org/2001/04/xmlenc#kw-aes256\nhttp://www.w3.org/2001/04/xmlenc#kw-aes192\n");
        }
        n n2 = new n();
        n2.aaD = string;
        n2.aaJ = null;
        n2.aaK = null;
        try {
            n2.aaF = org.apache.xml.security.b.b.getInstance(N14C_XML_WITH_COMMENTS);
        }
        catch (org.apache.xml.security.b.d d2) {
            throw new p("empty", d2);
        }
        String string2 = org.apache.xml.security.a.b.translateURItoJCEID(string);
        try {
            n2.aaB = Cipher.getInstance(string2);
            logger.debug((Object)("cihper.algoritm = " + n2.aaB.getAlgorithm()));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new p("empty", noSuchAlgorithmException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new p("empty", noSuchPaddingException);
        }
        return n2;
    }

    public static n getInstance(String string, String string2) {
        n n2 = n.getInstance(string);
        if (string2 != null) {
            try {
                n2.aaF = org.apache.xml.security.b.b.getInstance(string2);
            }
            catch (org.apache.xml.security.b.d d2) {
                throw new p("empty", d2);
            }
        }
        return n2;
    }

    public static n getProviderInstance(String string, String string2) {
        logger.debug((Object)"Getting XMLCipher...");
        if (null == string) {
            logger.error((Object)"Transformation unexpectedly null...");
        }
        if (null == string2) {
            logger.error((Object)"Provider unexpectedly null..");
        }
        if ("" == string2) {
            logger.error((Object)"Provider's value unexpectedly not specified...");
        }
        if (!n.ay(string)) {
            logger.warn((Object)"Algorithm non-standard, expected one of http://www.w3.org/2001/04/xmlenc#tripledes-cbc\nhttp://www.w3.org/2001/04/xmlenc#aes128-cbc\nhttp://www.w3.org/2001/04/xmlenc#aes256-cbc\nhttp://www.w3.org/2001/04/xmlenc#aes192-cbc\nhttp://www.w3.org/2001/04/xmlenc#rsa-1_5\nhttp://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p\nhttp://www.w3.org/2001/04/xmlenc#kw-tripledes\nhttp://www.w3.org/2001/04/xmlenc#kw-aes128\nhttp://www.w3.org/2001/04/xmlenc#kw-aes256\nhttp://www.w3.org/2001/04/xmlenc#kw-aes192\n");
        }
        n n2 = new n();
        n2.aaD = string;
        n2.aaE = string2;
        n2.aaJ = null;
        n2.aaK = null;
        try {
            n2.aaF = org.apache.xml.security.b.b.getInstance(N14C_XML_WITH_COMMENTS);
        }
        catch (org.apache.xml.security.b.d d2) {
            throw new p("empty", d2);
        }
        try {
            String string3 = org.apache.xml.security.a.b.translateURItoJCEID(string);
            n2.aaB = Cipher.getInstance(string3, string2);
            logger.debug((Object)("cipher._algorithm = " + n2.aaB.getAlgorithm()));
            logger.debug((Object)("provider.name = " + string2));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new p("empty", noSuchAlgorithmException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new p("empty", noSuchProviderException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new p("empty", noSuchPaddingException);
        }
        return n2;
    }

    public static n getProviderInstance(String string, String string2, String string3) {
        n n2 = n.getProviderInstance(string, string2);
        if (string3 != null) {
            try {
                n2.aaF = org.apache.xml.security.b.b.getInstance(string3);
            }
            catch (org.apache.xml.security.b.d d2) {
                throw new p("empty", d2);
            }
        }
        return n2;
    }

    public static n getInstance() {
        logger.debug((Object)"Getting XMLCipher for no transformation...");
        n n2 = new n();
        n2.aaD = null;
        n2.aaE = null;
        n2.aaJ = null;
        n2.aaK = null;
        n2.aaB = null;
        try {
            n2.aaF = org.apache.xml.security.b.b.getInstance(N14C_XML_WITH_COMMENTS);
        }
        catch (org.apache.xml.security.b.d d2) {
            throw new p("empty", d2);
        }
        return n2;
    }

    public static n getProviderInstance(String string) {
        logger.debug((Object)"Getting XMLCipher, provider but no transformation");
        if (null == string) {
            logger.error((Object)"Provider unexpectedly null..");
        }
        if ("" == string) {
            logger.error((Object)"Provider's value unexpectedly not specified...");
        }
        n n2 = new n();
        n2.aaD = null;
        n2.aaE = string;
        n2.aaJ = null;
        n2.aaK = null;
        n2.aaB = null;
        try {
            n2.aaF = org.apache.xml.security.b.b.getInstance(N14C_XML_WITH_COMMENTS);
        }
        catch (org.apache.xml.security.b.d d2) {
            throw new p("empty", d2);
        }
        return n2;
    }

    public void init(int n2, Key key) {
        logger.debug((Object)"Initializing XMLCipher...");
        this.aaL = null;
        this.aaM = null;
        switch (n2) {
            case 1: {
                logger.debug((Object)"opmode = ENCRYPT_MODE");
                this.aaM = this.createEncryptedData(1, "NO VALUE YET");
                break;
            }
            case 2: {
                logger.debug((Object)"opmode = DECRYPT_MODE");
                break;
            }
            case 3: {
                logger.debug((Object)"opmode = WRAP_MODE");
                this.aaL = this.createEncryptedKey(1, "NO VALUE YET");
                break;
            }
            case 4: {
                logger.debug((Object)"opmode = UNWRAP_MODE");
                break;
            }
            default: {
                logger.error((Object)"Mode unexpectedly invalid");
                throw new p("Invalid mode in init");
            }
        }
        this.aaC = n2;
        this.aaJ = key;
    }

    public e getEncryptedData() {
        logger.debug((Object)"Returning EncryptedData");
        return this.aaM;
    }

    public f getEncryptedKey() {
        logger.debug((Object)"Returning EncryptedKey");
        return this.aaL;
    }

    public void setKEK(Key key) {
        this.aaK = key;
    }

    public Element martial(e e2) {
        return this.aaH.a(e2);
    }

    public Element martial(f f2) {
        return this.aaH.a(f2);
    }

    public Element martial(Document document, e e2) {
        this.aaG = document;
        return this.aaH.a(e2);
    }

    public Element martial(Document document, f f2) {
        this.aaG = document;
        return this.aaH.a(f2);
    }

    private Document n(Element element) {
        logger.debug((Object)"Encrypting element...");
        if (null == element) {
            logger.error((Object)"Element unexpectedly null...");
        }
        if (this.aaC != 1) {
            logger.debug((Object)"XMLCipher unexpectedly not in ENCRYPT_MODE...");
        }
        if (this.aaD == null) {
            throw new p("XMLCipher instance without transformation specified");
        }
        this.encryptData(this.aaG, element, false);
        Element element2 = this.aaH.a(this.aaM);
        Node node = element.getParentNode();
        node.replaceChild(element2, element);
        return this.aaG;
    }

    private Document o(Element element) {
        logger.debug((Object)"Encrypting element content...");
        if (null == element) {
            logger.error((Object)"Element unexpectedly null...");
        }
        if (this.aaC != 1) {
            logger.debug((Object)"XMLCipher unexpectedly not in ENCRYPT_MODE...");
        }
        if (this.aaD == null) {
            throw new p("XMLCipher instance without transformation specified");
        }
        this.encryptData(this.aaG, element, true);
        Element element2 = this.aaH.a(this.aaM);
        this.l(element);
        element.appendChild(element2);
        return this.aaG;
    }

    public Document doFinal(Document document, Document document2) {
        logger.debug((Object)"Processing source document...");
        if (null == document) {
            logger.error((Object)"Context document unexpectedly null...");
        }
        if (null == document2) {
            logger.error((Object)"Source document unexpectedly null...");
        }
        this.aaG = document;
        Document document3 = null;
        switch (this.aaC) {
            case 2: {
                document3 = this.p(document2.getDocumentElement());
                break;
            }
            case 1: {
                document3 = this.n(document2.getDocumentElement());
                break;
            }
            case 4: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new p("empty", new IllegalStateException());
            }
        }
        return document3;
    }

    public Document doFinal(Document document, Element element) {
        logger.debug((Object)"Processing source element...");
        if (null == document) {
            logger.error((Object)"Context document unexpectedly null...");
        }
        if (null == element) {
            logger.error((Object)"Source element unexpectedly null...");
        }
        this.aaG = document;
        Document document2 = null;
        switch (this.aaC) {
            case 2: {
                document2 = this.p(element);
                break;
            }
            case 1: {
                document2 = this.n(element);
                break;
            }
            case 4: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new p("empty", new IllegalStateException());
            }
        }
        return document2;
    }

    public Document doFinal(Document document, Element element, boolean bl) {
        logger.debug((Object)"Processing source element...");
        if (null == document) {
            logger.error((Object)"Context document unexpectedly null...");
        }
        if (null == element) {
            logger.error((Object)"Source element unexpectedly null...");
        }
        this.aaG = document;
        Document document2 = null;
        switch (this.aaC) {
            case 2: {
                if (bl) {
                    document2 = this.q(element);
                    break;
                }
                document2 = this.p(element);
                break;
            }
            case 1: {
                if (bl) {
                    document2 = this.o(element);
                    break;
                }
                document2 = this.n(element);
                break;
            }
            case 4: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new p("empty", new IllegalStateException());
            }
        }
        return document2;
    }

    public e encryptData(Document document, Element element) {
        return this.encryptData(document, element, false);
    }

    public e encryptData(Document document, String string, InputStream inputStream) {
        logger.debug((Object)"Encrypting element...");
        if (null == document) {
            logger.error((Object)"Context document unexpectedly null...");
        }
        if (null == inputStream) {
            logger.error((Object)"Serialized data unexpectedly null...");
        }
        if (this.aaC != 1) {
            logger.debug((Object)"XMLCipher unexpectedly not in ENCRYPT_MODE...");
        }
        return this.a(document, null, string, inputStream);
    }

    public e encryptData(Document document, Element element, boolean bl) {
        logger.debug((Object)"Encrypting element...");
        if (null == document) {
            logger.error((Object)"Context document unexpectedly null...");
        }
        if (null == element) {
            logger.error((Object)"Element unexpectedly null...");
        }
        if (this.aaC != 1) {
            logger.debug((Object)"XMLCipher unexpectedly not in ENCRYPT_MODE...");
        }
        if (bl) {
            return this.a(document, element, "http://www.w3.org/2001/04/xmlenc#Content", null);
        }
        return this.a(document, element, "http://www.w3.org/2001/04/xmlenc#Element", null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private e a(Document document, Element element, String string, InputStream inputStream) {
        Object object;
        Object object2;
        byte[] byArray;
        Cipher cipher;
        Object object3;
        this.aaG = document;
        if (this.aaD == null) {
            throw new p("XMLCipher instance without transformation specified");
        }
        String string2 = null;
        if (inputStream == null) {
            if (string == "http://www.w3.org/2001/04/xmlenc#Content") {
                object3 = element.getChildNodes();
                if (null == object3) {
                    Object[] objectArray = new Object[]{"Element has no content."};
                    throw new p("empty", objectArray);
                }
                string2 = this.aaI.serialize((NodeList)object3);
            } else {
                string2 = this.aaI.serialize(element);
            }
            logger.debug((Object)("Serialized octets:\n" + string2));
        }
        object3 = null;
        if (this.aaB == null) {
            String string3 = org.apache.xml.security.a.b.translateURItoJCEID(this.aaD);
            logger.debug((Object)("alg = " + string3));
            try {
                if (this.aaE == null) {
                    cipher = Cipher.getInstance(string3);
                }
                cipher = Cipher.getInstance(string3, this.aaE);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new p("empty", noSuchAlgorithmException);
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new p("empty", noSuchProviderException);
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                throw new p("empty", noSuchPaddingException);
            }
        } else {
            cipher = this.aaB;
        }
        try {
            cipher.init(this.aaC, this.aaJ);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new p("empty", invalidKeyException);
        }
        try {
            if (inputStream != null) {
                int n2;
                byArray = new byte[8192];
                object2 = new ByteArrayOutputStream();
                while ((n2 = inputStream.read(byArray)) != -1) {
                    object = cipher.update(byArray, 0, n2);
                    ((OutputStream)object2).write((byte[])object);
                }
                ((OutputStream)object2).write(cipher.doFinal());
                object3 = ((ByteArrayOutputStream)object2).toByteArray();
            } else {
                object3 = cipher.doFinal(string2.getBytes("UTF-8"));
                logger.debug((Object)("Expected cipher.outputSize = " + Integer.toString(cipher.getOutputSize(string2.getBytes().length))));
            }
            logger.debug((Object)("Actual cipher.outputSize = " + Integer.toString(((Object)object3).length)));
        }
        catch (IllegalStateException illegalStateException) {
            throw new p("empty", illegalStateException);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new p("empty", illegalBlockSizeException);
        }
        catch (BadPaddingException badPaddingException) {
            throw new p("empty", badPaddingException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new p("empty", unsupportedEncodingException);
        }
        byte[] byArray2 = cipher.getIV();
        byArray = new byte[byArray2.length + ((Object)object3).length];
        System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
        System.arraycopy(object3, 0, byArray, byArray2.length, ((Object)object3).length);
        object2 = org.apache.xml.security.utils.a.encode(byArray);
        logger.debug((Object)("Encrypted octets:\n" + (String)object2));
        logger.debug((Object)("Encrypted octets length = " + ((String)object2).length()));
        try {
            object = this.aaM.getCipherData();
            d d2 = object.getCipherValue();
            d2.setValue((String)object2);
            this.aaM.setType(new URI(string).toString());
            h h2 = this.aaH.aC(new URI(this.aaD).toString());
            this.aaM.setEncryptionMethod(h2);
            return this.aaM;
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new p("empty", (Exception)((Object)malformedURIException));
        }
    }

    public e loadEncryptedData(Document document, Element element) {
        logger.debug((Object)"Loading encrypted element...");
        if (null == document) {
            logger.error((Object)"Context document unexpectedly null...");
        }
        if (null == element) {
            logger.error((Object)"Element unexpectedly null...");
        }
        if (this.aaC != 2) {
            logger.error((Object)"XMLCipher unexpectedly not in DECRYPT_MODE...");
        }
        this.aaG = document;
        this.aaM = this.aaH.u(element);
        return this.aaM;
    }

    public f loadEncryptedKey(Document document, Element element) {
        logger.debug((Object)"Loading encrypted key...");
        if (null == document) {
            logger.error((Object)"Context document unexpectedly null...");
        }
        if (null == element) {
            logger.error((Object)"Element unexpectedly null...");
        }
        if (this.aaC != 4 && this.aaC != 2) {
            logger.debug((Object)"XMLCipher unexpectedly not in UNWRAP_MODE or DECRYPT_MODE...");
        }
        this.aaG = document;
        this.aaL = this.aaH.v(element);
        return this.aaL;
    }

    public f loadEncryptedKey(Element element) {
        return this.loadEncryptedKey(element.getOwnerDocument(), element);
    }

    public f encryptKey(Document document, Key key) {
        Cipher cipher;
        String string;
        logger.debug((Object)"Encrypting key ...");
        if (null == key) {
            logger.error((Object)"Key unexpectedly null...");
        }
        if (this.aaC != 3) {
            logger.debug((Object)"XMLCipher unexpectedly not in WRAP_MODE...");
        }
        if (this.aaD == null) {
            throw new p("XMLCipher instance without transformation specified");
        }
        this.aaG = document;
        byte[] byArray = null;
        if (this.aaB == null) {
            string = org.apache.xml.security.a.b.translateURItoJCEID(this.aaD);
            logger.debug((Object)("alg = " + string));
            try {
                if (this.aaE == null) {
                    cipher = Cipher.getInstance(string);
                }
                cipher = Cipher.getInstance(string, this.aaE);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new p("empty", noSuchAlgorithmException);
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new p("empty", noSuchProviderException);
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                throw new p("empty", noSuchPaddingException);
            }
        } else {
            cipher = this.aaB;
        }
        try {
            cipher.init(3, this.aaJ);
            byArray = cipher.wrap(key);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new p("empty", invalidKeyException);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new p("empty", illegalBlockSizeException);
        }
        string = org.apache.xml.security.utils.a.encode(byArray);
        logger.debug((Object)("Encrypted key octets:\n" + string));
        logger.debug((Object)("Encrypted key octets length = " + string.length()));
        d d2 = this.aaL.getCipherData().getCipherValue();
        d2.setValue(string);
        try {
            h h2 = this.aaH.aC(new URI(this.aaD).toString());
            this.aaL.setEncryptionMethod(h2);
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new p("empty", (Exception)((Object)malformedURIException));
        }
        return this.aaL;
    }

    public Key decryptKey(f f2, String string) {
        Cipher cipher;
        Object object;
        Object object2;
        logger.debug((Object)"Decrypting key from previously loaded EncryptedKey...");
        if (this.aaC != 4) {
            logger.debug((Object)"XMLCipher unexpectedly not in UNWRAP_MODE...");
        }
        if (string == null) {
            throw new p("Cannot decrypt a key without knowing the algorithm");
        }
        if (this.aaJ == null) {
            logger.debug((Object)"Trying to find a KEK via key resolvers");
            object2 = f2.getKeyInfo();
            if (object2 != null) {
                try {
                    this.aaJ = ((org.apache.xml.security.keys.a)object2).getSecretKey();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.aaJ == null) {
                logger.error((Object)"XMLCipher::decryptKey called without a KEK and cannot resolve");
                throw new p("Unable to decrypt without a KEK");
            }
        }
        object2 = new o(f2);
        byte[] byArray = ((o)object2).getBytes();
        String string2 = org.apache.xml.security.a.b.getJCEKeyAlgorithmFromURI(string);
        if (this.aaB == null) {
            object = org.apache.xml.security.a.b.translateURItoJCEID(f2.getEncryptionMethod().getAlgorithm());
            logger.debug((Object)("JCE Algorithm = " + (String)object));
            try {
                if (this.aaE == null) {
                    cipher = Cipher.getInstance((String)object);
                }
                cipher = Cipher.getInstance((String)object, this.aaE);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new p("empty", noSuchAlgorithmException);
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new p("empty", noSuchProviderException);
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                throw new p("empty", noSuchPaddingException);
            }
        } else {
            cipher = this.aaB;
        }
        try {
            cipher.init(4, this.aaJ);
            object = cipher.unwrap(byArray, string2, 3);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new p("empty", invalidKeyException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new p("empty", noSuchAlgorithmException);
        }
        logger.debug((Object)("Decryption of key type " + string + " OK"));
        return object;
    }

    public Key decryptKey(f f2) {
        return this.decryptKey(f2, this.aaM.getEncryptionMethod().getAlgorithm());
    }

    private void l(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Node node2 = nodeList.item(i2);
            if (node2 == null) continue;
            node2.getParentNode().removeChild(node2);
        }
    }

    private Document p(Element element) {
        String string;
        logger.debug((Object)"Decrypting element...");
        if (this.aaC != 2) {
            logger.error((Object)"XMLCipher unexpectedly not in DECRYPT_MODE...");
        }
        try {
            string = new String(this.decryptToByteArray(element), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new p("empty", unsupportedEncodingException);
        }
        logger.debug((Object)("Decrypted octets:\n" + string));
        Node node = element.getParentNode();
        DocumentFragment documentFragment = this.aaI.a(string, node);
        if (node instanceof Document) {
            this.aaG.removeChild(this.aaG.getDocumentElement());
            this.aaG.appendChild(documentFragment);
        } else {
            node.replaceChild(documentFragment, element);
        }
        return this.aaG;
    }

    private Document q(Element element) {
        Element element2 = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedData").item(0);
        if (null == element2) {
            throw new p("No EncryptedData child element.");
        }
        return this.p(element2);
    }

    public byte[] decryptToByteArray(Element element) {
        byte[] byArray;
        Cipher cipher;
        Object object;
        logger.debug((Object)"Decrypting to ByteArray...");
        if (this.aaC != 2) {
            logger.error((Object)"XMLCipher unexpectedly not in DECRYPT_MODE...");
        }
        e e2 = this.aaH.u(element);
        if (this.aaJ == null) {
            object = e2.getKeyInfo();
            if (object != null) {
                try {
                    ((org.apache.xml.security.keys.a)object).registerInternalKeyResolver(new org.apache.xml.security.keys.keyresolver.a.a(e2.getEncryptionMethod().getAlgorithm(), this.aaK));
                    this.aaJ = ((org.apache.xml.security.keys.a)object).getSecretKey();
                }
                catch (org.apache.xml.security.keys.keyresolver.b b2) {
                    // empty catch block
                }
            }
            if (this.aaJ == null) {
                logger.error((Object)"XMLCipher::decryptElement called without a key and unable to resolve");
                throw new p("encryption.nokey");
            }
        }
        object = new o(e2);
        byte[] byArray2 = ((o)object).getBytes();
        String string = org.apache.xml.security.a.b.translateURItoJCEID(e2.getEncryptionMethod().getAlgorithm());
        try {
            cipher = this.aaE == null ? Cipher.getInstance(string) : Cipher.getInstance(string, this.aaE);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new p("empty", noSuchAlgorithmException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new p("empty", noSuchProviderException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new p("empty", noSuchPaddingException);
        }
        int n2 = cipher.getBlockSize();
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray2, 0, byArray3, 0, n2);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray3);
        try {
            cipher.init(this.aaC, this.aaJ, ivParameterSpec);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new p("empty", invalidKeyException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new p("empty", invalidAlgorithmParameterException);
        }
        try {
            byArray = cipher.doFinal(byArray2, n2, byArray2.length - n2);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new p("empty", illegalBlockSizeException);
        }
        catch (BadPaddingException badPaddingException) {
            throw new p("empty", badPaddingException);
        }
        return byArray;
    }

    public e createEncryptedData(int n2, String string) {
        e e2 = null;
        org.apache.xml.security.c.b b2 = null;
        switch (n2) {
            case 2: {
                c c2 = this.aaH.aA(string);
                b2 = this.aaH.ay(n2);
                b2.setCipherReference(c2);
                e2 = this.aaH.a(b2);
                break;
            }
            case 1: {
                d d2 = this.aaH.aB(string);
                b2 = this.aaH.ay(n2);
                b2.setCipherValue(d2);
                e2 = this.aaH.a(b2);
            }
        }
        return e2;
    }

    public f createEncryptedKey(int n2, String string) {
        f f2 = null;
        org.apache.xml.security.c.b b2 = null;
        switch (n2) {
            case 2: {
                c c2 = this.aaH.aA(string);
                b2 = this.aaH.ay(n2);
                b2.setCipherReference(c2);
                f2 = this.aaH.b(b2);
                break;
            }
            case 1: {
                d d2 = this.aaH.aB(string);
                b2 = this.aaH.ay(n2);
                b2.setCipherValue(d2);
                f2 = this.aaH.b(b2);
            }
        }
        return f2;
    }

    public org.apache.xml.security.c.a createAgreementMethod(String string) {
        return this.aaH.az(string);
    }

    public org.apache.xml.security.c.b createCipherData(int n2) {
        return this.aaH.ay(n2);
    }

    public c createCipherReference(String string) {
        return this.aaH.aA(string);
    }

    public d createCipherValue(String string) {
        return this.aaH.aB(string);
    }

    public h createEncryptionMethod(String string) {
        return this.aaH.aC(string);
    }

    public i createEncryptionProperties() {
        return this.aaH.eC();
    }

    public j createEncryptionProperty() {
        return this.aaH.eD();
    }

    public l createReferenceList(int n2) {
        return this.aaH.az(n2);
    }

    public m createTransforms() {
        return this.aaH.eE();
    }

    public m createTransforms(Document document) {
        return this.aaH.c(document);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static org.apache.xml.security.b.b a(n n2) {
        return n2.aaF;
    }

    static Document b(n n2) {
        return n2.aaG;
    }

    static Log eB() {
        return logger;
    }

    static class 1 {
    }

    private class org.apache.xml.security.c.n$a {
        private final n aaQ;

        private org.apache.xml.security.c.n$a(n n2) {
            this.aaQ = n2;
        }

        org.apache.xml.security.c.a az(String string) {
            return new a(this, string);
        }

        org.apache.xml.security.c.b ay(int n2) {
            return new b(this, n2);
        }

        org.apache.xml.security.c.c aA(String string) {
            return new c(this, string);
        }

        org.apache.xml.security.c.d aB(String string) {
            return new d(this, string);
        }

        org.apache.xml.security.c.e a(org.apache.xml.security.c.b b2) {
            return new e(this, b2);
        }

        org.apache.xml.security.c.f b(org.apache.xml.security.c.b b2) {
            return new f(this, b2);
        }

        org.apache.xml.security.c.h aC(String string) {
            return new h(this, string);
        }

        org.apache.xml.security.c.i eC() {
            return new i(this);
        }

        org.apache.xml.security.c.j eD() {
            return new j(this);
        }

        org.apache.xml.security.c.l az(int n2) {
            return new k(this, n2);
        }

        m eE() {
            return new l(this);
        }

        m c(Document document) {
            return new l(this, document);
        }

        org.apache.xml.security.c.b r(Element element) {
            if (null == element) {
                throw new NullPointerException("element is null");
            }
            int n2 = 0;
            Element element2 = null;
            if (element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherValue").getLength() > 0) {
                n2 = 1;
                element2 = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherValue").item(0);
            } else if (element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherReference").getLength() > 0) {
                n2 = 2;
                element2 = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherReference").item(0);
            }
            org.apache.xml.security.c.b b2 = this.ay(n2);
            if (n2 == 1) {
                b2.setCipherValue(this.t(element2));
            } else if (n2 == 2) {
                b2.setCipherReference(this.s(element2));
            }
            return b2;
        }

        org.apache.xml.security.c.c s(Element element) {
            Attr attr = element.getAttributeNodeNS(null, "URI");
            c c2 = new c(this, attr);
            NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "Transforms");
            Element element2 = (Element)nodeList.item(0);
            if (element2 != null) {
                n.eB().debug((Object)"Creating a DSIG based Transforms element");
                try {
                    c2.setTransforms(new l(this, element2));
                }
                catch (org.apache.xml.security.e.i i2) {
                    throw new p("empty", i2);
                }
                catch (org.apache.xml.security.f.a a2) {
                    throw new p("empty", a2);
                }
                catch (org.apache.xml.security.d.c c3) {
                    throw new p("empty", c3);
                }
            }
            return c2;
        }

        org.apache.xml.security.c.d t(Element element) {
            String string = org.apache.xml.security.utils.o.getFullTextChildrenFromElement(element);
            org.apache.xml.security.c.d d2 = this.aB(string);
            return d2;
        }

        org.apache.xml.security.c.e u(Element element) {
            Element element2;
            Element element3;
            org.apache.xml.security.c.e e2 = null;
            NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherData");
            Element element4 = (Element)nodeList.item(nodeList.getLength() - 1);
            org.apache.xml.security.c.b b2 = this.r(element4);
            e2 = this.a(b2);
            try {
                e2.setId(element.getAttributeNS(null, "Id"));
                e2.setType(new URI(element.getAttributeNS(null, "Type")).toString());
                e2.setMimeType(element.getAttributeNS(null, "MimeType"));
                e2.setEncoding(new URI(element.getAttributeNS(null, "Encoding")).toString());
            }
            catch (URI.MalformedURIException malformedURIException) {
                // empty catch block
            }
            Element element5 = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptionMethod").item(0);
            if (null != element5) {
                e2.setEncryptionMethod(this.w(element5));
            }
            if (null != (element3 = (Element)element.getElementsByTagNameNS(n.XML_DSIG, "KeyInfo").item(0))) {
                try {
                    e2.setKeyInfo(new org.apache.xml.security.keys.a(element3, null));
                }
                catch (org.apache.xml.security.d.c c2) {
                    throw new p("Error loading Key Info", c2);
                }
            }
            if (null != (element2 = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptionProperties").item(0))) {
                e2.setEncryptionProperties(this.x(element2));
            }
            return e2;
        }

        org.apache.xml.security.c.f v(Element element) {
            Element element2;
            Element element3;
            Element element4;
            Element element5;
            org.apache.xml.security.c.f f2 = null;
            NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherData");
            Element element6 = (Element)nodeList.item(nodeList.getLength() - 1);
            org.apache.xml.security.c.b b2 = this.r(element6);
            f2 = this.b(b2);
            try {
                f2.setId(element.getAttributeNS(null, "Id"));
                f2.setType(new URI(element.getAttributeNS(null, "Type")).toString());
                f2.setMimeType(element.getAttributeNS(null, "MimeType"));
                f2.setEncoding(new URI(element.getAttributeNS(null, "Encoding")).toString());
                f2.setRecipient(element.getAttributeNS(null, "Recipient"));
            }
            catch (URI.MalformedURIException malformedURIException) {
                // empty catch block
            }
            Element element7 = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptionMethod").item(0);
            if (null != element7) {
                f2.setEncryptionMethod(this.w(element7));
            }
            if (null != (element5 = (Element)element.getElementsByTagNameNS(n.XML_DSIG, "KeyInfo").item(0))) {
                try {
                    f2.setKeyInfo(new org.apache.xml.security.keys.a(element5, null));
                }
                catch (org.apache.xml.security.d.c c2) {
                    throw new p("Error loading Key Info", c2);
                }
            }
            if (null != (element4 = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptionProperties").item(0))) {
                f2.setEncryptionProperties(this.x(element4));
            }
            if (null != (element3 = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "ReferenceList").item(0))) {
                f2.setReferenceList(this.z(element3));
            }
            if (null != (element2 = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CarriedKeyName").item(0))) {
                f2.setCarriedName(element2.getFirstChild().getNodeValue());
            }
            return f2;
        }

        org.apache.xml.security.c.h w(Element element) {
            Element element2;
            String string = element.getAttributeNS(null, "Algorithm");
            org.apache.xml.security.c.h h2 = this.aC(string);
            Element element3 = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "KeySize").item(0);
            if (null != element3) {
                h2.setKeySize(Integer.valueOf(element3.getFirstChild().getNodeValue()));
            }
            if (null != (element2 = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "OAEPparams").item(0))) {
                h2.setOAEPparams(element2.getNodeValue().getBytes());
            }
            return h2;
        }

        org.apache.xml.security.c.i x(Element element) {
            org.apache.xml.security.c.i i2 = this.eC();
            i2.setId(element.getAttributeNS(null, "Id"));
            NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptionProperty");
            for (int i3 = 0; i3 < nodeList.getLength(); ++i3) {
                Node node = nodeList.item(i3);
                if (null == node) continue;
                i2.addEncryptionProperty(this.y((Element)node));
            }
            return i2;
        }

        org.apache.xml.security.c.j y(Element element) {
            org.apache.xml.security.c.j j2 = this.eD();
            try {
                j2.setTarget(new URI(element.getAttributeNS(null, "Target")).toString());
            }
            catch (URI.MalformedURIException malformedURIException) {
                // empty catch block
            }
            j2.setId(element.getAttributeNS(null, "Id"));
            return j2;
        }

        org.apache.xml.security.c.l z(Element element) {
            int n2 = 0;
            if (null != element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "DataReference").item(0)) {
                n2 = 1;
            } else if (null != element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "KeyReference").item(0)) {
                n2 = 2;
            }
            k k2 = new k(this, n2);
            NodeList nodeList = null;
            switch (n2) {
                case 1: {
                    nodeList = element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "DataReference");
                    for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                        String string = ((Element)nodeList.item(i2)).getAttribute("URI");
                        k2.add(k2.newDataReference(string));
                    }
                    break;
                }
                case 2: {
                    nodeList = element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "KeyReference");
                    for (int i3 = 0; i3 < nodeList.getLength(); ++i3) {
                        String string = ((Element)nodeList.item(i3)).getAttribute("URI");
                        k2.add(k2.newKeyReference(string));
                    }
                    break;
                }
            }
            return k2;
        }

        Element a(org.apache.xml.security.c.e e2) {
            return ((e)e2).toElement();
        }

        Element a(org.apache.xml.security.c.f f2) {
            return ((f)f2).toElement();
        }

        org.apache.xml.security.c.n$a(n n2, 1 var2_2) {
            this(n2);
        }

        static n a(org.apache.xml.security.c.n$a a2) {
            return a2.aaQ;
        }

        private class k
        implements org.apache.xml.security.c.l {
            private Class abp;
            private List abq;
            private final org.apache.xml.security.c.n$a aaV;

            public k(org.apache.xml.security.c.n$a a2, int n2) {
                this.aaV = a2;
                if (n2 == 1) {
                    this.abp = aaO == null ? (aaO = n.class$("org.apache.xml.security.c.n$a$k$a")) : aaO;
                } else if (n2 == 2) {
                    this.abp = aaP == null ? (aaP = n.class$("org.apache.xml.security.c.n$a$k$b")) : aaP;
                } else {
                    throw new IllegalArgumentException();
                }
                this.abq = new LinkedList();
            }

            public void add(org.apache.xml.security.c.k k2) {
                if (!k2.getClass().equals(this.abp)) {
                    throw new IllegalArgumentException();
                }
                this.abq.add(k2);
            }

            public void remove(org.apache.xml.security.c.k k2) {
                if (!k2.getClass().equals(this.abp)) {
                    throw new IllegalArgumentException();
                }
                this.abq.remove(k2);
            }

            public int size() {
                return this.abq.size();
            }

            public boolean isEmpty() {
                return this.abq.isEmpty();
            }

            public Iterator getReferences() {
                return this.abq.iterator();
            }

            Element toElement() {
                Element element = org.apache.xml.security.utils.c.createElementForFamily(n.b(org.apache.xml.security.c.n$a.a(this.aaV)), "http://www.w3.org/2001/04/xmlenc#", "ReferenceList");
                Iterator iterator = this.abq.iterator();
                while (iterator.hasNext()) {
                    org.apache.xml.security.c.k k2 = (org.apache.xml.security.c.k)iterator.next();
                    element.appendChild(((c)k2).toElement());
                }
                return element;
            }

            public org.apache.xml.security.c.k newDataReference(String string) {
                return new a(this, string);
            }

            public org.apache.xml.security.c.k newKeyReference(String string) {
                return new b(this, string);
            }

            static org.apache.xml.security.c.n$a a(k k2) {
                return k2.aaV;
            }

            private class b
            extends c {
                private final k abr;

                b(k k2, String string) {
                    super(k2, string);
                    this.abr = k2;
                }

                public Element toElement() {
                    return super.aD("KeyReference");
                }
            }

            private class a
            extends c {
                private final k abr;

                a(k k2, String string) {
                    super(k2, string);
                    this.abr = k2;
                }

                public Element toElement() {
                    return super.aD("DataReference");
                }
            }

            private abstract class c
            implements org.apache.xml.security.c.k {
                private String uri;
                private List abs;
                private final k abr;

                c(k k2, String string) {
                    this.abr = k2;
                    this.uri = string;
                    this.abs = new LinkedList();
                }

                public String getURI() {
                    return this.uri;
                }

                public Iterator getElementRetrievalInformation() {
                    return this.abs.iterator();
                }

                public void setURI(String string) {
                    this.uri = string;
                }

                public void removeElementRetrievalInformation(Element element) {
                    this.abs.remove(element);
                }

                public void addElementRetrievalInformation(Element element) {
                    this.abs.add(element);
                }

                public abstract Element toElement();

                Element aD(String string) {
                    Element element = org.apache.xml.security.utils.c.createElementForFamily(n.b(org.apache.xml.security.c.n$a.a(k.a(this.abr))), "http://www.w3.org/2001/04/xmlenc#", string);
                    element.setAttribute("URI", this.uri);
                    return element;
                }
            }
        }

        private class l
        extends org.apache.xml.security.f.e
        implements m {
            private final org.apache.xml.security.c.n$a aaV;

            public l(org.apache.xml.security.c.n$a a2) {
                super(n.b(org.apache.xml.security.c.n$a.a(a2)));
                this.aaV = a2;
            }

            public l(org.apache.xml.security.c.n$a a2, Document document) {
                this.aaV = a2;
                if (document == null) {
                    throw new RuntimeException("Document is null");
                }
                this._doc = document;
                this._state = 0;
                this._constructionElement = this.createElementForFamilyLocal(this._doc, this.getBaseNamespace(), this.getBaseLocalName());
            }

            public l(org.apache.xml.security.c.n$a a2, Element element) {
                super(element, "");
                this.aaV = a2;
            }

            public Element toElement() {
                if (this._doc == null) {
                    this._doc = n.b(org.apache.xml.security.c.n$a.a(this.aaV));
                }
                return this.getElement();
            }

            public org.apache.xml.security.f.e getDSTransforms() {
                return this;
            }

            public String getBaseNamespace() {
                return "http://www.w3.org/2001/04/xmlenc#";
            }
        }

        private class j
        implements org.apache.xml.security.c.j {
            private String target;
            private String id;
            private HashMap abn;
            private List abo;
            private final org.apache.xml.security.c.n$a aaV;

            public j(org.apache.xml.security.c.n$a a2) {
                this.aaV = a2;
                this.target = null;
                this.id = null;
                this.abn = new HashMap();
                this.abo = null;
                this.abo = new LinkedList();
            }

            public String getTarget() {
                return this.target;
            }

            public void setTarget(String string) {
                URI uRI = null;
                try {
                    uRI = new URI(string);
                }
                catch (URI.MalformedURIException malformedURIException) {
                    // empty catch block
                }
                this.target = uRI.toString();
            }

            public String getId() {
                return this.id;
            }

            public void setId(String string) {
                this.id = string;
            }

            public String getAttribute(String string) {
                return (String)this.abn.get(string);
            }

            public void setAttribute(String string, String string2) {
                this.abn.put(string, string2);
            }

            public Iterator getEncryptionInformation() {
                return this.abo.iterator();
            }

            public void addEncryptionInformation(Element element) {
                this.abo.add(element);
            }

            public void removeEncryptionInformation(Element element) {
                this.abo.remove(element);
            }

            Element toElement() {
                Element element = org.apache.xml.security.utils.c.createElementForFamily(n.b(org.apache.xml.security.c.n$a.a(this.aaV)), "http://www.w3.org/2001/04/xmlenc#", "EncryptionProperty");
                if (null != this.target) {
                    element.setAttributeNS(null, "Target", this.target);
                }
                if (null != this.id) {
                    element.setAttributeNS(null, "Id", this.id);
                }
                return element;
            }
        }

        private class i
        implements org.apache.xml.security.c.i {
            private String id;
            private List abm;
            private final org.apache.xml.security.c.n$a aaV;

            public i(org.apache.xml.security.c.n$a a2) {
                this.aaV = a2;
                this.id = null;
                this.abm = null;
                this.abm = new LinkedList();
            }

            public String getId() {
                return this.id;
            }

            public void setId(String string) {
                this.id = string;
            }

            public Iterator getEncryptionProperties() {
                return this.abm.iterator();
            }

            public void addEncryptionProperty(org.apache.xml.security.c.j j2) {
                this.abm.add(j2);
            }

            public void removeEncryptionProperty(org.apache.xml.security.c.j j2) {
                this.abm.remove(j2);
            }

            Element toElement() {
                Element element = org.apache.xml.security.utils.c.createElementForFamily(n.b(org.apache.xml.security.c.n$a.a(this.aaV)), "http://www.w3.org/2001/04/xmlenc#", "EncryptionProperties");
                if (null != this.id) {
                    element.setAttributeNS(null, "Id", this.id);
                }
                Iterator iterator = this.getEncryptionProperties();
                while (iterator.hasNext()) {
                    element.appendChild(((j)iterator.next()).toElement());
                }
                return element;
            }
        }

        private class h
        implements org.apache.xml.security.c.h {
            private String algorithm;
            private int keySize;
            private byte[] abk;
            private List abl;
            private final org.apache.xml.security.c.n$a aaV;

            public h(org.apache.xml.security.c.n$a a2, String string) {
                this.aaV = a2;
                this.algorithm = null;
                this.keySize = Integer.MIN_VALUE;
                this.abk = null;
                this.abl = null;
                URI uRI = null;
                try {
                    uRI = new URI(string);
                }
                catch (URI.MalformedURIException malformedURIException) {
                    // empty catch block
                }
                this.algorithm = uRI.toString();
                this.abl = new LinkedList();
            }

            public String getAlgorithm() {
                return this.algorithm;
            }

            public int getKeySize() {
                return this.keySize;
            }

            public void setKeySize(int n2) {
                this.keySize = n2;
            }

            public byte[] getOAEPparams() {
                return this.abk;
            }

            public void setOAEPparams(byte[] byArray) {
                this.abk = byArray;
            }

            public Iterator getEncryptionMethodInformation() {
                return this.abl.iterator();
            }

            public void addEncryptionMethodInformation(Element element) {
                this.abl.add(element);
            }

            public void removeEncryptionMethodInformation(Element element) {
                this.abl.remove(element);
            }

            Element toElement() {
                Element element = org.apache.xml.security.utils.c.createElementForFamily(n.b(org.apache.xml.security.c.n$a.a(this.aaV)), "http://www.w3.org/2001/04/xmlenc#", "EncryptionMethod");
                element.setAttributeNS(null, "Algorithm", this.algorithm);
                if (this.keySize > 0) {
                    element.appendChild(org.apache.xml.security.utils.c.createElementForFamily(n.b(org.apache.xml.security.c.n$a.a(this.aaV)), "http://www.w3.org/2001/04/xmlenc#", "KeySize").appendChild(n.b(org.apache.xml.security.c.n$a.a(this.aaV)).createTextNode(String.valueOf(this.keySize))));
                }
                if (null != this.abk) {
                    element.appendChild(org.apache.xml.security.utils.c.createElementForFamily(n.b(org.apache.xml.security.c.n$a.a(this.aaV)), "http://www.w3.org/2001/04/xmlenc#", "OAEPparams").appendChild(n.b(org.apache.xml.security.c.n$a.a(this.aaV)).createTextNode(new String(this.abk))));
                }
                if (!this.abl.isEmpty()) {
                    Iterator iterator = this.abl.iterator();
                    element.appendChild((Element)iterator.next());
                }
                return element;
            }
        }

        private abstract class g {
            private String id;
            private String type;
            private String mimeType;
            private String encoding;
            private org.apache.xml.security.c.h abg;
            private org.apache.xml.security.keys.a abh;
            private org.apache.xml.security.c.b abi;
            private org.apache.xml.security.c.i abj;
            private final org.apache.xml.security.c.n$a aaV;

            protected g(org.apache.xml.security.c.n$a a2, org.apache.xml.security.c.b b2) {
                this.aaV = a2;
                this.id = null;
                this.type = null;
                this.mimeType = null;
                this.encoding = null;
                this.abg = null;
                this.abh = null;
                this.abi = null;
                this.abj = null;
                this.abi = b2;
            }

            public String getId() {
                return this.id;
            }

            public void setId(String string) {
                this.id = string;
            }

            public String getType() {
                return this.type;
            }

            public void setType(String string) {
                URI uRI = null;
                try {
                    uRI = new URI(string);
                }
                catch (URI.MalformedURIException malformedURIException) {
                    // empty catch block
                }
                this.type = uRI.toString();
            }

            public String getMimeType() {
                return this.mimeType;
            }

            public void setMimeType(String string) {
                this.mimeType = string;
            }

            public String getEncoding() {
                return this.encoding;
            }

            public void setEncoding(String string) {
                URI uRI = null;
                try {
                    uRI = new URI(string);
                }
                catch (URI.MalformedURIException malformedURIException) {
                    // empty catch block
                }
                this.encoding = uRI.toString();
            }

            public org.apache.xml.security.c.h getEncryptionMethod() {
                return this.abg;
            }

            public void setEncryptionMethod(org.apache.xml.security.c.h h2) {
                this.abg = h2;
            }

            public org.apache.xml.security.keys.a getKeyInfo() {
                return this.abh;
            }

            public void setKeyInfo(org.apache.xml.security.keys.a a2) {
                this.abh = a2;
            }

            public org.apache.xml.security.c.b getCipherData() {
                return this.abi;
            }

            public org.apache.xml.security.c.i getEncryptionProperties() {
                return this.abj;
            }

            public void setEncryptionProperties(org.apache.xml.security.c.i i2) {
                this.abj = i2;
            }
        }

        private class f
        extends g
        implements org.apache.xml.security.c.f {
            private String abd;
            private org.apache.xml.security.c.l abe;
            private String abf;
            private final org.apache.xml.security.c.n$a aaV;

            public f(org.apache.xml.security.c.n$a a2, org.apache.xml.security.c.b b2) {
                super(a2, b2);
                this.aaV = a2;
                this.abd = null;
                this.abe = null;
                this.abf = null;
            }

            public String getRecipient() {
                return this.abd;
            }

            public void setRecipient(String string) {
                this.abd = string;
            }

            public org.apache.xml.security.c.l getReferenceList() {
                return this.abe;
            }

            public void setReferenceList(org.apache.xml.security.c.l l2) {
                this.abe = l2;
            }

            public String getCarriedName() {
                return this.abf;
            }

            public void setCarriedName(String string) {
                this.abf = string;
            }

            Element toElement() {
                Element element = org.apache.xml.security.utils.c.createElementForFamily(n.b(org.apache.xml.security.c.n$a.a(this.aaV)), "http://www.w3.org/2001/04/xmlenc#", "EncryptedKey");
                if (null != super.getId()) {
                    element.setAttributeNS(null, "Id", super.getId());
                }
                if (null != super.getType()) {
                    element.setAttributeNS(null, "Type", super.getType());
                }
                if (null != super.getMimeType()) {
                    element.setAttributeNS(null, "MimeType", super.getMimeType());
                }
                if (null != super.getEncoding()) {
                    element.setAttributeNS(null, "Encoding", super.getEncoding());
                }
                if (null != this.getRecipient()) {
                    element.setAttributeNS(null, "Recipient", this.getRecipient());
                }
                if (null != super.getEncryptionMethod()) {
                    element.appendChild(((h)super.getEncryptionMethod()).toElement());
                }
                if (null != super.getKeyInfo()) {
                    element.appendChild(super.getKeyInfo().getElement());
                }
                element.appendChild(((b)super.getCipherData()).toElement());
                if (null != super.getEncryptionProperties()) {
                    element.appendChild(((i)super.getEncryptionProperties()).toElement());
                }
                if (this.abe != null && !this.abe.isEmpty()) {
                    element.appendChild(((k)this.getReferenceList()).toElement());
                }
                if (null != this.abf) {
                    Element element2 = org.apache.xml.security.utils.c.createElementForFamily(n.b(org.apache.xml.security.c.n$a.a(this.aaV)), "http://www.w3.org/2001/04/xmlenc#", "CarriedKeyName");
                    Text text = n.b(org.apache.xml.security.c.n$a.a(this.aaV)).createTextNode(this.abf);
                    element2.appendChild(text);
                    element.appendChild(element2);
                }
                return element;
            }
        }

        private class e
        extends g
        implements org.apache.xml.security.c.e {
            private final org.apache.xml.security.c.n$a aaV;

            public e(org.apache.xml.security.c.n$a a2, org.apache.xml.security.c.b b2) {
                super(a2, b2);
                this.aaV = a2;
            }

            Element toElement() {
                Element element = org.apache.xml.security.utils.c.createElementForFamily(n.b(org.apache.xml.security.c.n$a.a(this.aaV)), "http://www.w3.org/2001/04/xmlenc#", "EncryptedData");
                if (null != super.getId()) {
                    element.setAttributeNS(null, "Id", super.getId());
                }
                if (null != super.getType()) {
                    element.setAttributeNS(null, "Type", super.getType());
                }
                if (null != super.getMimeType()) {
                    element.setAttributeNS(null, "MimeType", super.getMimeType());
                }
                if (null != super.getEncoding()) {
                    element.setAttributeNS(null, "Encoding", super.getEncoding());
                }
                if (null != super.getEncryptionMethod()) {
                    element.appendChild(((h)super.getEncryptionMethod()).toElement());
                }
                if (null != super.getKeyInfo()) {
                    element.appendChild(super.getKeyInfo().getElement());
                }
                element.appendChild(((b)super.getCipherData()).toElement());
                if (null != super.getEncryptionProperties()) {
                    element.appendChild(((i)super.getEncryptionProperties()).toElement());
                }
                return element;
            }
        }

        private class d
        implements org.apache.xml.security.c.d {
            private String abc;
            private final org.apache.xml.security.c.n$a aaV;

            public d(org.apache.xml.security.c.n$a a2, String string) {
                this.aaV = a2;
                this.abc = null;
                this.abc = string;
            }

            public String getValue() {
                return this.abc;
            }

            public void setValue(String string) {
                this.abc = string;
            }

            Element toElement() {
                Element element = org.apache.xml.security.utils.c.createElementForFamily(n.b(org.apache.xml.security.c.n$a.a(this.aaV)), "http://www.w3.org/2001/04/xmlenc#", "CipherValue");
                element.appendChild(n.b(org.apache.xml.security.c.n$a.a(this.aaV)).createTextNode(this.abc));
                return element;
            }
        }

        private class c
        implements org.apache.xml.security.c.c {
            private String aaZ;
            private m aba;
            private Attr abb;
            private final org.apache.xml.security.c.n$a aaV;

            public c(org.apache.xml.security.c.n$a a2, String string) {
                this.aaV = a2;
                this.aaZ = null;
                this.aba = null;
                this.abb = null;
                this.aaZ = string;
                this.abb = null;
            }

            public c(org.apache.xml.security.c.n$a a2, Attr attr) {
                this.aaV = a2;
                this.aaZ = null;
                this.aba = null;
                this.abb = null;
                this.aaZ = attr.getNodeValue();
                this.abb = attr;
            }

            public String getURI() {
                return this.aaZ;
            }

            public Attr getURIAsAttr() {
                return this.abb;
            }

            public m getTransforms() {
                return this.aba;
            }

            public void setTransforms(m m2) {
                this.aba = m2;
            }

            Element toElement() {
                Element element = org.apache.xml.security.utils.c.createElementForFamily(n.b(org.apache.xml.security.c.n$a.a(this.aaV)), "http://www.w3.org/2001/04/xmlenc#", "CipherReference");
                element.setAttributeNS(null, "URI", this.aaZ);
                if (null != this.aba) {
                    element.appendChild(((l)this.aba).toElement());
                }
                return element;
            }
        }

        private class b
        implements org.apache.xml.security.c.b {
            private org.apache.xml.security.c.d aaW;
            private org.apache.xml.security.c.c aaX;
            private int aaY;
            private final org.apache.xml.security.c.n$a aaV;

            public b(org.apache.xml.security.c.n$a a2, int n2) {
                this.aaV = a2;
                this.aaW = null;
                this.aaX = null;
                this.aaY = Integer.MIN_VALUE;
                this.aaY = n2;
            }

            public org.apache.xml.security.c.d getCipherValue() {
                return this.aaW;
            }

            public void setCipherValue(org.apache.xml.security.c.d d2) {
                if (this.aaY == 2) {
                    throw new p("empty", new UnsupportedOperationException("Data type is reference type."));
                }
                this.aaW = d2;
            }

            public org.apache.xml.security.c.c getCipherReference() {
                return this.aaX;
            }

            public void setCipherReference(org.apache.xml.security.c.c c2) {
                if (this.aaY == 1) {
                    throw new p("empty", new UnsupportedOperationException("Data type is value type."));
                }
                this.aaX = c2;
            }

            public int getDataType() {
                return this.aaY;
            }

            Element toElement() {
                Element element = org.apache.xml.security.utils.c.createElementForFamily(n.b(org.apache.xml.security.c.n$a.a(this.aaV)), "http://www.w3.org/2001/04/xmlenc#", "CipherData");
                if (this.aaY == 1) {
                    element.appendChild(((d)this.aaW).toElement());
                } else if (this.aaY == 2) {
                    element.appendChild(((c)this.aaX).toElement());
                }
                return element;
            }
        }

        private class a
        implements org.apache.xml.security.c.a {
            private byte[] aaR;
            private List aaS;
            private org.apache.xml.security.keys.a aaT;
            private org.apache.xml.security.keys.a aaU;
            private String ZP;
            private final org.apache.xml.security.c.n$a aaV;

            public a(org.apache.xml.security.c.n$a a2, String string) {
                this.aaV = a2;
                this.aaR = null;
                this.aaS = null;
                this.aaT = null;
                this.aaU = null;
                this.ZP = null;
                this.aaS = new LinkedList();
                URI uRI = null;
                try {
                    uRI = new URI(string);
                }
                catch (URI.MalformedURIException malformedURIException) {
                    // empty catch block
                }
                this.ZP = uRI.toString();
            }

            public byte[] getKANonce() {
                return this.aaR;
            }

            public void setKANonce(byte[] byArray) {
                this.aaR = byArray;
            }

            public Iterator getAgreementMethodInformation() {
                return this.aaS.iterator();
            }

            public void addAgreementMethodInformation(Element element) {
                this.aaS.add(element);
            }

            public void revoveAgreementMethodInformation(Element element) {
                this.aaS.remove(element);
            }

            public org.apache.xml.security.keys.a getOriginatorKeyInfo() {
                return this.aaT;
            }

            public void setOriginatorKeyInfo(org.apache.xml.security.keys.a a2) {
                this.aaT = a2;
            }

            public org.apache.xml.security.keys.a getRecipientKeyInfo() {
                return this.aaU;
            }

            public void setRecipientKeyInfo(org.apache.xml.security.keys.a a2) {
                this.aaU = a2;
            }

            public String getAlgorithm() {
                return this.ZP;
            }

            public void setAlgorithm(String string) {
                URI uRI = null;
                try {
                    uRI = new URI(string);
                }
                catch (URI.MalformedURIException malformedURIException) {
                    // empty catch block
                }
                this.ZP = uRI.toString();
            }
        }
    }

    private class b {
        private final n aaQ;

        b(n n2) {
            this.aaQ = n2;
        }

        String serialize(Element element) {
            return this.canonSerialize(element);
        }

        String serialize(NodeList nodeList) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            n.a(this.aaQ).setWriter(byteArrayOutputStream);
            n.a(this.aaQ).notReset();
            for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                n.a(this.aaQ).canonicalizeSubtree(nodeList.item(i2));
            }
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toString("UTF-8");
        }

        String canonSerialize(Node node) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            n.a(this.aaQ).setWriter(byteArrayOutputStream);
            n.a(this.aaQ).notReset();
            n.a(this.aaQ).canonicalizeSubtree(node);
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toString("UTF-8");
        }

        DocumentFragment a(String string, Node node) {
            DocumentFragment documentFragment;
            Node node2;
            Node node3;
            Object object;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><fragment");
            for (Node node4 = node; node4 != null; node4 = node4.getParentNode()) {
                object = node4.getAttributes();
                int n2 = object != null ? object.getLength() : 0;
                for (int i2 = 0; i2 < n2; ++i2) {
                    node3 = object.item(i2);
                    if (!node3.getNodeName().startsWith("xmlns:") && !node3.getNodeName().equals("xmlns")) continue;
                    boolean bl = false;
                    for (node2 = node; node2 != node4; node2 = node2.getParentNode()) {
                        NamedNodeMap namedNodeMap = node2.getAttributes();
                        if (namedNodeMap == null || namedNodeMap.getNamedItem(node3.getNodeName()) == null) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    stringBuffer.append(" " + node3.getNodeName() + "=\"" + node3.getNodeValue() + "\"");
                }
            }
            stringBuffer.append(">" + string + "</" + "fragment" + ">");
            object = stringBuffer.toString();
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                documentBuilderFactory.setAttribute("http://xml.org/sax/features/namespaces", Boolean.TRUE);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                node3 = documentBuilder.parse(new InputSource(new StringReader((String)object)));
                node2 = (Element)n.b(this.aaQ).importNode(node3.getDocumentElement(), true);
                documentFragment = n.b(this.aaQ).createDocumentFragment();
                Node node5 = node2.getFirstChild();
                while (node5 != null) {
                    node2.removeChild(node5);
                    documentFragment.appendChild(node5);
                    node5 = node2.getFirstChild();
                }
            }
            catch (SAXException sAXException) {
                throw new p("empty", sAXException);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new p("empty", parserConfigurationException);
            }
            catch (IOException iOException) {
                throw new p("empty", iOException);
            }
            return documentFragment;
        }
    }
}

