/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.message;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.websocket.common.events.EventDriver;
import org.eclipse.jetty.websocket.common.message.MessageAppender;

public class SimpleBinaryMessage
implements MessageAppender {
    private static final int BUFFER_SIZE = 65535;
    private final EventDriver onEvent;
    protected final ByteArrayOutputStream out;
    private int size;
    protected boolean finished;

    public SimpleBinaryMessage(EventDriver eventDriver) {
        this.onEvent = eventDriver;
        this.out = new ByteArrayOutputStream(65535);
        this.finished = false;
    }

    @Override
    public void appendFrame(ByteBuffer byteBuffer, boolean bl) {
        if (this.finished) {
            throw new IOException("Cannot append to finished buffer");
        }
        if (byteBuffer == null) {
            return;
        }
        this.onEvent.getPolicy().assertValidBinaryMessageSize(this.size + byteBuffer.remaining());
        this.size += byteBuffer.remaining();
        BufferUtil.writeTo((ByteBuffer)byteBuffer, (OutputStream)this.out);
    }

    @Override
    public void messageComplete() {
        this.finished = true;
        byte[] byArray = this.out.toByteArray();
        this.onEvent.onBinaryMessage(byArray);
    }
}

