/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.message;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.common.message.MessageAppender;

public class MessageInputStream
extends InputStream
implements MessageAppender {
    private static final Logger LOG = Log.getLogger(MessageInputStream.class);
    private static final ByteBuffer EOF = ByteBuffer.allocate(0).asReadOnlyBuffer();
    private final BlockingDeque<ByteBuffer> buffers = new LinkedBlockingDeque<ByteBuffer>();
    private AtomicBoolean closed = new AtomicBoolean(false);
    private final long timeoutMs;
    private ByteBuffer activeBuffer = null;

    public MessageInputStream() {
        this(-1);
    }

    public MessageInputStream(int n) {
        this.timeoutMs = n;
    }

    @Override
    public void appendFrame(ByteBuffer byteBuffer, boolean bl) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Appending {} chunk: {}", new Object[]{bl ? "final" : "non-final", BufferUtil.toDetailString((ByteBuffer)byteBuffer)});
        }
        if (this.closed.get()) {
            return;
        }
        try {
            if (byteBuffer == null) {
                return;
            }
            int n = byteBuffer.remaining();
            if (n <= 0) {
                return;
            }
            ByteBuffer byteBuffer2 = byteBuffer.isDirect() ? ByteBuffer.allocateDirect(n) : ByteBuffer.allocate(n);
            byteBuffer2.put(byteBuffer).flip();
            this.buffers.put(byteBuffer2);
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException);
        }
        finally {
            if (bl) {
                this.buffers.offer(EOF);
            }
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.buffers.offer(EOF);
            super.close();
        }
    }

    @Override
    public void mark(int n) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void messageComplete() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Message completed", new Object[0]);
        }
        this.buffers.offer(EOF);
    }

    @Override
    public int read() {
        try {
            if (this.closed.get()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Stream closed", new Object[0]);
                }
                return -1;
            }
            while (this.activeBuffer == null || !this.activeBuffer.hasRemaining()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Waiting {} ms to read", this.timeoutMs);
                }
                if (this.timeoutMs < 0L) {
                    this.activeBuffer = this.buffers.take();
                } else {
                    this.activeBuffer = this.buffers.poll(this.timeoutMs, TimeUnit.MILLISECONDS);
                    if (this.activeBuffer == null) {
                        throw new IOException(String.format("Read timeout: %,dms expired", this.timeoutMs));
                    }
                }
                if (this.activeBuffer != EOF) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Reached EOF", new Object[0]);
                }
                this.closed.set(true);
                this.buffers.clear();
                return -1;
            }
            return this.activeBuffer.get() & 0xFF;
        }
        catch (InterruptedException interruptedException) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Interrupted while waiting to read", (Throwable)interruptedException);
            }
            this.closed.set(true);
            return -1;
        }
    }

    @Override
    public void reset() {
        throw new IOException("reset() not supported");
    }
}

