/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.io.http;

import java.nio.ByteBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.Utf8LineParser;
import org.eclipse.jetty.websocket.common.io.http.HttpResponseHeaderParseListener;

public class HttpResponseHeaderParser {
    private static final Pattern PAT_HEADER = Pattern.compile("([^:]+):\\s*(.*)");
    private static final Pattern PAT_STATUS_LINE = Pattern.compile("^HTTP/1.[01]\\s+(\\d+)\\s+(.*)", 2);
    private final HttpResponseHeaderParseListener listener;
    private final Utf8LineParser lineParser;
    private State state;

    public HttpResponseHeaderParser(HttpResponseHeaderParseListener httpResponseHeaderParseListener) {
        this.listener = httpResponseHeaderParseListener;
        this.lineParser = new Utf8LineParser();
        this.state = State.STATUS_LINE;
    }

    public boolean isDone() {
        return this.state == State.END;
    }

    public HttpResponseHeaderParseListener parse(ByteBuffer byteBuffer) {
        while (!this.isDone() && byteBuffer.remaining() > 0) {
            String string = this.lineParser.parse(byteBuffer);
            if (string == null || !this.parseHeader(string)) continue;
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(byteBuffer.remaining());
            BufferUtil.put((ByteBuffer)byteBuffer, (ByteBuffer)byteBuffer2);
            BufferUtil.flipToFlush((ByteBuffer)byteBuffer2, (int)0);
            this.listener.setRemainingBuffer(byteBuffer2);
            return this.listener;
        }
        return null;
    }

    private boolean parseHeader(String string) {
        switch (this.state) {
            case STATUS_LINE: {
                Matcher matcher = PAT_STATUS_LINE.matcher(string);
                if (!matcher.matches()) {
                    throw new ParseException("Unexpected HTTP response status line [" + string + "]");
                }
                try {
                    this.listener.setStatusCode(Integer.parseInt(matcher.group(1)));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParseException("Unexpected HTTP response status code", numberFormatException);
                }
                this.listener.setStatusReason(matcher.group(2));
                this.state = State.HEADER;
                break;
            }
            case HEADER: {
                if (StringUtil.isBlank((String)string)) {
                    this.state = State.END;
                    return this.parseHeader(string);
                }
                Matcher matcher = PAT_HEADER.matcher(string);
                if (!matcher.matches()) break;
                String string2 = matcher.group(1);
                String string3 = matcher.group(2);
                this.listener.addHeader(string2, string3);
                break;
            }
            case END: {
                this.state = State.STATUS_LINE;
                return true;
            }
        }
        return false;
    }

    private static enum State {
        STATUS_LINE,
        HEADER,
        END;

    }

    public static class ParseException
    extends RuntimeException {
        public ParseException(String string) {
            super(string);
        }

        public ParseException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

