/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.io;

import java.io.EOFException;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.ConnectionState;

public class IOState {
    private static final Logger LOG = Log.getLogger(IOState.class);
    private ConnectionState state;
    private final List<ConnectionStateListener> listeners = new CopyOnWriteArrayList<ConnectionStateListener>();
    private boolean inputAvailable = false;
    private boolean outputAvailable = false;
    private CloseHandshakeSource closeHandshakeSource;
    private CloseInfo closeInfo = null;
    private AtomicReference<CloseInfo> finalClose = new AtomicReference();
    private boolean cleanClose = false;

    public IOState() {
        this.state = ConnectionState.CONNECTING;
        this.closeHandshakeSource = CloseHandshakeSource.NONE;
    }

    public void addListener(ConnectionStateListener connectionStateListener) {
        this.listeners.add(connectionStateListener);
    }

    public void assertInputOpen() {
        if (!this.isInputAvailable()) {
            throw new IOException("Connection input is closed");
        }
    }

    public void assertOutputOpen() {
        if (!this.isOutputAvailable()) {
            throw new IOException("Connection output is closed");
        }
    }

    public CloseInfo getCloseInfo() {
        CloseInfo closeInfo = this.finalClose.get();
        if (closeInfo != null) {
            return closeInfo;
        }
        return this.closeInfo;
    }

    public ConnectionState getConnectionState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        ConnectionState connectionState = this.state;
        synchronized (connectionState) {
            return this.state == ConnectionState.CLOSED;
        }
    }

    public boolean isInputAvailable() {
        return this.inputAvailable;
    }

    public boolean isOpen() {
        return this.getConnectionState() != ConnectionState.CLOSED;
    }

    public boolean isOutputAvailable() {
        return this.outputAvailable;
    }

    private void notifyStateListeners(ConnectionState connectionState) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Notify State Listeners: {}", new Object[]{connectionState});
        }
        for (ConnectionStateListener connectionStateListener : this.listeners) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{}.onConnectionStateChange({})", new Object[]{connectionStateListener.getClass().getSimpleName(), connectionState.name()});
            }
            connectionStateListener.onConnectionStateChange(connectionState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAbnormalClose(CloseInfo closeInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onAbnormalClose({})", new Object[]{closeInfo});
        }
        ConnectionState connectionState = null;
        IOState iOState = this;
        synchronized (iOState) {
            if (this.state == ConnectionState.CLOSED) {
                return;
            }
            if (this.state == ConnectionState.OPEN) {
                this.cleanClose = false;
            }
            this.state = ConnectionState.CLOSED;
            this.finalClose.compareAndSet(null, closeInfo);
            this.inputAvailable = false;
            this.outputAvailable = false;
            this.closeHandshakeSource = CloseHandshakeSource.ABNORMAL;
            connectionState = this.state;
        }
        this.notifyStateListeners(connectionState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCloseLocal(CloseInfo closeInfo) {
        ConnectionState connectionState = null;
        ConnectionState connectionState2 = null;
        ConnectionState connectionState3 = this.state;
        if (LOG.isDebugEnabled()) {
            LOG.debug("onCloseLocal({}) : {}", new Object[]{closeInfo, connectionState3});
        }
        if (connectionState3 == ConnectionState.CLOSED) {
            LOG.debug("already closed", new Object[0]);
            return;
        }
        if (connectionState3 == ConnectionState.CONNECTED) {
            LOG.debug("FastClose in CONNECTED detected", new Object[0]);
            this.onOpened();
            if (LOG.isDebugEnabled()) {
                LOG.debug("FastClose continuing with Closure", new Object[0]);
            }
        }
        IOState iOState = this;
        synchronized (iOState) {
            this.closeInfo = closeInfo;
            this.outputAvailable = false;
            boolean bl = this.inputAvailable;
            boolean bl2 = this.outputAvailable;
            if (this.closeHandshakeSource == CloseHandshakeSource.NONE) {
                this.closeHandshakeSource = CloseHandshakeSource.LOCAL;
            }
            LOG.debug("onCloseLocal(), input={}, output={}", new Object[]{bl, bl2});
            if (!bl && !bl2) {
                LOG.debug("Close Handshake satisfied, disconnecting", new Object[0]);
                this.cleanClose = true;
                this.state = ConnectionState.CLOSED;
                this.finalClose.compareAndSet(null, closeInfo);
                connectionState = this.state;
            } else if (this.state == ConnectionState.OPEN) {
                connectionState = this.state = ConnectionState.CLOSING;
                if (closeInfo.isAbnormal()) {
                    connectionState2 = ConnectionState.CLOSED;
                    this.finalClose.compareAndSet(null, closeInfo);
                    this.cleanClose = false;
                    this.outputAvailable = false;
                    this.inputAvailable = false;
                    this.closeHandshakeSource = CloseHandshakeSource.ABNORMAL;
                }
            }
        }
        if (connectionState != null) {
            this.notifyStateListeners(connectionState);
            if (connectionState2 != null) {
                this.notifyStateListeners(connectionState2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCloseRemote(CloseInfo closeInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onCloseRemote({})", new Object[]{closeInfo});
        }
        ConnectionState connectionState = null;
        IOState iOState = this;
        synchronized (iOState) {
            if (this.state == ConnectionState.CLOSED) {
                return;
            }
            this.closeInfo = closeInfo;
            boolean bl = this.inputAvailable = false;
            boolean bl2 = this.outputAvailable;
            if (this.closeHandshakeSource == CloseHandshakeSource.NONE) {
                this.closeHandshakeSource = CloseHandshakeSource.REMOTE;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("onCloseRemote(), input={}, output={}", new Object[]{bl, bl2});
            }
            if (!bl && !bl2) {
                LOG.debug("Close Handshake satisfied, disconnecting", new Object[0]);
                this.cleanClose = true;
                this.state = ConnectionState.CLOSED;
                this.finalClose.compareAndSet(null, closeInfo);
                connectionState = this.state;
            } else if (this.state == ConnectionState.OPEN) {
                connectionState = this.state = ConnectionState.CLOSING;
            }
        }
        if (connectionState != null) {
            this.notifyStateListeners(connectionState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnected() {
        ConnectionState connectionState = null;
        IOState iOState = this;
        synchronized (iOState) {
            if (this.state != ConnectionState.CONNECTING) {
                LOG.debug("Unable to set to connected, not in CONNECTING state: {}", new Object[]{this.state});
                return;
            }
            this.state = ConnectionState.CONNECTED;
            this.inputAvailable = false;
            this.outputAvailable = true;
            connectionState = this.state;
        }
        this.notifyStateListeners(connectionState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailedUpgrade() {
        assert (this.state == ConnectionState.CONNECTING);
        ConnectionState connectionState = null;
        IOState iOState = this;
        synchronized (iOState) {
            this.state = ConnectionState.CLOSED;
            this.cleanClose = false;
            this.inputAvailable = false;
            this.outputAvailable = false;
            connectionState = this.state;
        }
        this.notifyStateListeners(connectionState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOpened() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(" onOpened()", new Object[0]);
        }
        ConnectionState connectionState = null;
        IOState iOState = this;
        synchronized (iOState) {
            if (this.state == ConnectionState.OPEN) {
                return;
            }
            if (this.state != ConnectionState.CONNECTED) {
                LOG.debug("Unable to open, not in CONNECTED state: {}", new Object[]{this.state});
                return;
            }
            this.state = ConnectionState.OPEN;
            this.inputAvailable = true;
            this.outputAvailable = true;
            connectionState = this.state;
        }
        this.notifyStateListeners(connectionState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReadFailure(Throwable throwable) {
        ConnectionState connectionState = null;
        IOState iOState = this;
        synchronized (iOState) {
            Object object;
            if (this.state == ConnectionState.CLOSED) {
                return;
            }
            String string = "WebSocket Read Failure";
            if (throwable instanceof EOFException) {
                string = "WebSocket Read EOF";
                object = throwable.getCause();
                if (object != null && StringUtil.isNotBlank((String)((Throwable)object).getMessage())) {
                    string = "EOF: " + ((Throwable)object).getMessage();
                }
            } else if (StringUtil.isNotBlank((String)throwable.getMessage())) {
                string = throwable.getMessage();
            }
            object = new CloseInfo(1006, string);
            this.finalClose.compareAndSet(null, (CloseInfo)object);
            this.cleanClose = false;
            this.state = ConnectionState.CLOSED;
            this.closeInfo = object;
            this.inputAvailable = false;
            this.outputAvailable = false;
            this.closeHandshakeSource = CloseHandshakeSource.ABNORMAL;
            connectionState = this.state;
        }
        this.notifyStateListeners(connectionState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWriteFailure(Throwable throwable) {
        ConnectionState connectionState = null;
        IOState iOState = this;
        synchronized (iOState) {
            Object object;
            if (this.state == ConnectionState.CLOSED) {
                return;
            }
            String string = "WebSocket Write Failure";
            if (throwable instanceof EOFException) {
                string = "WebSocket Write EOF";
                object = throwable.getCause();
                if (object != null && StringUtil.isNotBlank((String)((Throwable)object).getMessage())) {
                    string = "EOF: " + ((Throwable)object).getMessage();
                }
            } else if (StringUtil.isNotBlank((String)throwable.getMessage())) {
                string = throwable.getMessage();
            }
            object = new CloseInfo(1006, string);
            this.finalClose.compareAndSet(null, (CloseInfo)object);
            this.cleanClose = false;
            this.state = ConnectionState.CLOSED;
            this.inputAvailable = false;
            this.outputAvailable = false;
            this.closeHandshakeSource = CloseHandshakeSource.ABNORMAL;
            connectionState = this.state;
        }
        this.notifyStateListeners(connectionState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDisconnected() {
        ConnectionState connectionState = null;
        IOState iOState = this;
        synchronized (iOState) {
            if (this.state == ConnectionState.CLOSED) {
                return;
            }
            CloseInfo closeInfo = new CloseInfo(1006, "Disconnected");
            this.cleanClose = false;
            this.state = ConnectionState.CLOSED;
            this.closeInfo = closeInfo;
            this.inputAvailable = false;
            this.outputAvailable = false;
            this.closeHandshakeSource = CloseHandshakeSource.ABNORMAL;
            connectionState = this.state;
        }
        this.notifyStateListeners(connectionState);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append("@").append(Integer.toHexString(this.hashCode()));
        stringBuilder.append("[").append((Object)this.state);
        stringBuilder.append(',');
        if (!this.inputAvailable) {
            stringBuilder.append('!');
        }
        stringBuilder.append("in,");
        if (!this.outputAvailable) {
            stringBuilder.append('!');
        }
        stringBuilder.append("out");
        if (this.state == ConnectionState.CLOSED || this.state == ConnectionState.CLOSING) {
            CloseInfo closeInfo = this.finalClose.get();
            if (closeInfo != null) {
                stringBuilder.append(",finalClose=").append(closeInfo);
            } else {
                stringBuilder.append(",close=").append(this.closeInfo);
            }
            stringBuilder.append(",clean=").append(this.cleanClose);
            stringBuilder.append(",closeSource=").append((Object)this.closeHandshakeSource);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public boolean wasAbnormalClose() {
        return this.closeHandshakeSource == CloseHandshakeSource.ABNORMAL;
    }

    public boolean wasCleanClose() {
        return this.cleanClose;
    }

    public boolean wasLocalCloseInitiated() {
        return this.closeHandshakeSource == CloseHandshakeSource.LOCAL;
    }

    public boolean wasRemoteCloseInitiated() {
        return this.closeHandshakeSource == CloseHandshakeSource.REMOTE;
    }

    public static interface ConnectionStateListener {
        public void onConnectionStateChange(ConnectionState var1);
    }

    private static enum CloseHandshakeSource {
        NONE,
        LOCAL,
        REMOTE,
        ABNORMAL;

    }
}

