/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.io;

import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import org.eclipse.jetty.websocket.api.extensions.OutgoingFrames;

public class FramePipes {
    public static OutgoingFrames to(IncomingFrames incomingFrames) {
        return new Out2In(incomingFrames);
    }

    public static IncomingFrames to(OutgoingFrames outgoingFrames) {
        return new In2Out(outgoingFrames);
    }

    private static class Out2In
    implements OutgoingFrames {
        private IncomingFrames incoming;

        public Out2In(IncomingFrames incomingFrames) {
            this.incoming = incomingFrames;
        }

        public void outgoingFrame(Frame frame, WriteCallback writeCallback, BatchMode batchMode) {
            try {
                this.incoming.incomingFrame(frame);
                writeCallback.writeSuccess();
            }
            catch (Throwable throwable) {
                writeCallback.writeFailed(throwable);
            }
        }
    }

    private static class In2Out
    implements IncomingFrames {
        private OutgoingFrames outgoing;

        public In2Out(OutgoingFrames outgoingFrames) {
            this.outgoing = outgoingFrames;
        }

        public void incomingError(Throwable throwable) {
        }

        public void incomingFrame(Frame frame) {
            this.outgoing.outgoingFrame(frame, null, BatchMode.OFF);
        }
    }
}

