/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.io;

import java.io.EOFException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.ArrayQueue;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.Generator;
import org.eclipse.jetty.websocket.common.frames.BinaryFrame;

public class FrameFlusher {
    public static final BinaryFrame FLUSH_FRAME = new BinaryFrame();
    private static final Logger LOG = Log.getLogger(FrameFlusher.class);
    private final ByteBufferPool bufferPool;
    private final EndPoint endpoint;
    private final int bufferSize;
    private final Generator generator;
    private final int maxGather;
    private final Object lock = new Object();
    private final ArrayQueue<FrameEntry> queue = new ArrayQueue(16, 16, this.lock);
    private final Flusher flusher;
    private final AtomicBoolean closed = new AtomicBoolean();
    private volatile Throwable failure;

    public FrameFlusher(ByteBufferPool byteBufferPool, Generator generator, EndPoint endPoint, int n, int n2) {
        this.bufferPool = byteBufferPool;
        this.endpoint = endPoint;
        this.bufferSize = n;
        this.generator = Objects.requireNonNull(generator);
        this.maxGather = n2;
        this.flusher = new Flusher(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            LOG.debug("{} closing {}", new Object[]{this});
            EOFException eOFException = new EOFException("Connection has been closed locally");
            this.flusher.failed(eOFException);
            ArrayList<FrameEntry> arrayList = new ArrayList<FrameEntry>();
            Iterator iterator = this.lock;
            synchronized (iterator) {
                arrayList.addAll((Collection<FrameEntry>)this.queue);
                this.queue.clear();
            }
            for (FrameEntry frameEntry : arrayList) {
                this.notifyCallbackFailure(frameEntry.callback, eOFException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(Frame frame, WriteCallback writeCallback, BatchMode batchMode) {
        if (this.closed.get()) {
            this.notifyCallbackFailure(writeCallback, new EOFException("Connection has been closed locally"));
            return;
        }
        if (this.flusher.isFailed()) {
            this.notifyCallbackFailure(writeCallback, this.failure);
            return;
        }
        FrameEntry frameEntry = new FrameEntry(frame, writeCallback, batchMode);
        Object object = this.lock;
        synchronized (object) {
            switch (frame.getOpCode()) {
                case 9: {
                    this.queue.add(0, (Object)frameEntry);
                    break;
                }
                case 8: {
                    this.closed.set(true);
                    this.queue.add((Object)frameEntry);
                    break;
                }
                default: {
                    this.queue.add((Object)frameEntry);
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} queued {}", new Object[]{this, frameEntry});
        }
        this.flusher.iterate();
    }

    protected void notifyCallbackFailure(WriteCallback writeCallback, Throwable throwable) {
        block3: {
            try {
                if (writeCallback != null) {
                    writeCallback.writeFailed(throwable);
                }
            }
            catch (Throwable throwable2) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("Exception while notifying failure of callback " + writeCallback, throwable2);
            }
        }
    }

    protected void notifyCallbackSuccess(WriteCallback writeCallback) {
        block3: {
            try {
                if (writeCallback != null) {
                    writeCallback.writeSuccess();
                }
            }
            catch (Throwable throwable) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("Exception while notifying success of callback " + writeCallback, throwable);
            }
        }
    }

    protected void onFailure(Throwable throwable) {
        LOG.warn(throwable);
    }

    public String toString() {
        ByteBuffer byteBuffer = this.flusher.aggregate;
        return String.format("%s[queueSize=%d,aggregateSize=%d,failure=%s]", this.getClass().getSimpleName(), this.queue.size(), byteBuffer == null ? 0 : byteBuffer.position(), this.failure);
    }

    private class FrameEntry {
        private final Frame frame;
        private final WriteCallback callback;
        private final BatchMode batchMode;
        private ByteBuffer headerBuffer;

        private FrameEntry(Frame frame, WriteCallback writeCallback, BatchMode batchMode) {
            this.frame = Objects.requireNonNull(frame);
            this.callback = writeCallback;
            this.batchMode = batchMode;
        }

        private ByteBuffer generateHeaderBytes() {
            this.headerBuffer = FrameFlusher.this.generator.generateHeaderBytes(this.frame);
            return this.headerBuffer;
        }

        private void generateHeaderBytes(ByteBuffer byteBuffer) {
            FrameFlusher.this.generator.generateHeaderBytes(this.frame, byteBuffer);
        }

        private void release() {
            if (this.headerBuffer != null) {
                FrameFlusher.this.generator.getBufferPool().release(this.headerBuffer);
                this.headerBuffer = null;
            }
        }

        public String toString() {
            return String.format("%s[%s,%s,%s,%s]", this.getClass().getSimpleName(), this.frame, this.callback, this.batchMode, FrameFlusher.this.failure);
        }
    }

    private class Flusher
    extends IteratingCallback {
        private final List<FrameEntry> entries;
        private final List<ByteBuffer> buffers;
        private ByteBuffer aggregate;
        private BatchMode batchMode;

        public Flusher(int n) {
            this.entries = new ArrayList<FrameEntry>(n);
            this.buffers = new ArrayList<ByteBuffer>(n * 2 + 1);
        }

        private IteratingCallback.Action batch() {
            if (this.aggregate == null) {
                this.aggregate = FrameFlusher.this.bufferPool.acquire(FrameFlusher.this.bufferSize, true);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} acquired aggregate buffer {}", new Object[]{FrameFlusher.this, this.aggregate});
                }
            }
            for (int i = 0; i < this.entries.size(); ++i) {
                FrameEntry frameEntry = this.entries.get(i);
                frameEntry.generateHeaderBytes(this.aggregate);
                ByteBuffer byteBuffer = frameEntry.frame.getPayload();
                if (!BufferUtil.hasContent((ByteBuffer)byteBuffer)) continue;
                BufferUtil.append((ByteBuffer)this.aggregate, (ByteBuffer)byteBuffer);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} aggregated {} frames: {}", new Object[]{FrameFlusher.this, this.entries.size(), this.entries});
            }
            this.succeeded();
            return IteratingCallback.Action.SCHEDULED;
        }

        protected void onCompleteSuccess() {
        }

        public void onCompleteFailure(Throwable throwable) {
            for (FrameEntry frameEntry : this.entries) {
                FrameFlusher.this.notifyCallbackFailure(frameEntry.callback, throwable);
                frameEntry.release();
            }
            this.entries.clear();
            FrameFlusher.this.failure = throwable;
            FrameFlusher.this.onFailure(throwable);
        }

        private IteratingCallback.Action flush() {
            if (!BufferUtil.isEmpty((ByteBuffer)this.aggregate)) {
                this.buffers.add(this.aggregate);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} flushing aggregate {}", new Object[]{FrameFlusher.this, this.aggregate});
                }
            }
            for (int i = 0; i < this.entries.size(); ++i) {
                FrameEntry frameEntry = this.entries.get(i);
                if (frameEntry.frame == FLUSH_FRAME) continue;
                this.buffers.add(frameEntry.generateHeaderBytes());
                ByteBuffer byteBuffer = frameEntry.frame.getPayload();
                if (!BufferUtil.hasContent((ByteBuffer)byteBuffer)) continue;
                this.buffers.add(byteBuffer);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} flushing {} frames: {}", new Object[]{FrameFlusher.this, this.entries.size(), this.entries});
            }
            if (this.buffers.isEmpty()) {
                this.releaseAggregate();
                this.succeedEntries();
                return IteratingCallback.Action.IDLE;
            }
            FrameFlusher.this.endpoint.write((Callback)this, this.buffers.toArray(new ByteBuffer[this.buffers.size()]));
            this.buffers.clear();
            return IteratingCallback.Action.SCHEDULED;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IteratingCallback.Action process() {
            int n = this.aggregate == null ? FrameFlusher.this.bufferSize : BufferUtil.space((ByteBuffer)this.aggregate);
            BatchMode batchMode = BatchMode.AUTO;
            Object object = FrameFlusher.this.lock;
            synchronized (object) {
                while (this.entries.size() <= FrameFlusher.this.maxGather && !FrameFlusher.this.queue.isEmpty()) {
                    int n2;
                    int n3;
                    FrameEntry frameEntry = (FrameEntry)FrameFlusher.this.queue.remove(0);
                    batchMode = BatchMode.max((BatchMode)batchMode, (BatchMode)frameEntry.batchMode);
                    if (frameEntry.frame == FLUSH_FRAME) {
                        batchMode = BatchMode.OFF;
                    }
                    if ((n3 = 28 + (n2 = BufferUtil.length((ByteBuffer)frameEntry.frame.getPayload()))) > FrameFlusher.this.bufferSize >> 2) {
                        batchMode = BatchMode.OFF;
                    }
                    if ((n -= n3) <= 0) {
                        batchMode = BatchMode.OFF;
                    }
                    this.entries.add(frameEntry);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} processing {} entries: {}", new Object[]{FrameFlusher.this, this.entries.size(), this.entries});
            }
            if (this.entries.isEmpty()) {
                if (this.batchMode != BatchMode.AUTO) {
                    this.releaseAggregate();
                    return IteratingCallback.Action.IDLE;
                }
                LOG.debug("{} auto flushing", new Object[]{FrameFlusher.this});
                return this.flush();
            }
            this.batchMode = batchMode;
            return batchMode == BatchMode.OFF ? this.flush() : this.batch();
        }

        private void releaseAggregate() {
            if (this.aggregate != null && BufferUtil.isEmpty((ByteBuffer)this.aggregate)) {
                FrameFlusher.this.bufferPool.release(this.aggregate);
                this.aggregate = null;
            }
        }

        public void succeeded() {
            this.succeedEntries();
            super.succeeded();
        }

        private void succeedEntries() {
            for (int i = 0; i < this.entries.size(); ++i) {
                FrameEntry frameEntry = this.entries.get(i);
                FrameFlusher.this.notifyCallbackSuccess(frameEntry.callback);
                frameEntry.release();
            }
            this.entries.clear();
        }
    }
}

