/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.io;

import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.CloseException;
import org.eclipse.jetty.websocket.api.SuspendToken;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.ConnectionState;
import org.eclipse.jetty.websocket.common.Generator;
import org.eclipse.jetty.websocket.common.LogicalConnection;
import org.eclipse.jetty.websocket.common.Parser;
import org.eclipse.jetty.websocket.common.io.FrameFlusher;
import org.eclipse.jetty.websocket.common.io.IOState;

public abstract class AbstractWebSocketConnection
extends AbstractConnection
implements Connection.UpgradeTo,
Dumpable,
LogicalConnection,
IOState.ConnectionStateListener {
    private static final Logger LOG = Log.getLogger(AbstractWebSocketConnection.class);
    private static final Logger LOG_OPEN = Log.getLogger((String)(AbstractWebSocketConnection.class.getName() + "_OPEN"));
    private static final Logger LOG_CLOSE = Log.getLogger((String)(AbstractWebSocketConnection.class.getName() + "_CLOSE"));
    private static final int MIN_BUFFER_SIZE = 28;
    private final ByteBufferPool bufferPool;
    private final Scheduler scheduler;
    private final Generator generator;
    private final Parser parser;
    private final WebSocketPolicy policy;
    private final AtomicBoolean suspendToken;
    private final FrameFlusher flusher;
    private final String id;
    private List<ExtensionConfig> extensions;
    private boolean isFilling;
    private ByteBuffer prefillBuffer;
    private ReadMode readMode = ReadMode.PARSE;
    private IOState ioState;
    private Stats stats = new Stats();

    public AbstractWebSocketConnection(EndPoint endPoint, Executor executor, Scheduler scheduler, WebSocketPolicy webSocketPolicy, ByteBufferPool byteBufferPool) {
        super(endPoint, executor);
        this.id = String.format("%s:%d->%s:%d", endPoint.getLocalAddress().getAddress().getHostAddress(), endPoint.getLocalAddress().getPort(), endPoint.getRemoteAddress().getAddress().getHostAddress(), endPoint.getRemoteAddress().getPort());
        this.policy = webSocketPolicy;
        this.bufferPool = byteBufferPool;
        this.generator = new Generator(webSocketPolicy, byteBufferPool);
        this.parser = new Parser(webSocketPolicy, byteBufferPool);
        this.scheduler = scheduler;
        this.extensions = new ArrayList<ExtensionConfig>();
        this.suspendToken = new AtomicBoolean(false);
        this.ioState = new IOState();
        this.ioState.addListener(this);
        this.flusher = new Flusher(byteBufferPool, this.generator, endPoint);
        this.setInputBufferSize(webSocketPolicy.getInputBufferSize());
        this.setMaxIdleTimeout(webSocketPolicy.getIdleTimeout());
    }

    @Override
    public Executor getExecutor() {
        return super.getExecutor();
    }

    @Override
    public void close() {
        if (LOG_CLOSE.isDebugEnabled()) {
            LOG_CLOSE.debug(".close()", new Object[0]);
        }
        CloseInfo closeInfo = new CloseInfo();
        this.outgoingFrame(closeInfo.asFrame(), new OnCloseLocalCallback(closeInfo), BatchMode.OFF);
    }

    @Override
    public void close(int n, String string) {
        if (LOG_CLOSE.isDebugEnabled()) {
            LOG_CLOSE.debug("close({},{})", new Object[]{n, string});
        }
        CloseInfo closeInfo = new CloseInfo(n, string);
        this.outgoingFrame(closeInfo.asFrame(), new OnCloseLocalCallback(closeInfo), BatchMode.OFF);
    }

    @Override
    public void disconnect() {
        if (LOG_CLOSE.isDebugEnabled()) {
            LOG_CLOSE.debug("{} disconnect()", new Object[]{this.policy.getBehavior()});
        }
        this.disconnect(false);
    }

    private void disconnect(boolean bl) {
        if (LOG_CLOSE.isDebugEnabled()) {
            LOG_CLOSE.debug("{} disconnect({})", new Object[]{this.policy.getBehavior(), bl ? "outputOnly" : "both"});
        }
        this.flusher.close();
        EndPoint endPoint = this.getEndPoint();
        if (LOG_CLOSE.isDebugEnabled()) {
            LOG_CLOSE.debug("Shutting down output {}", new Object[]{endPoint});
        }
        endPoint.shutdownOutput();
        if (!bl) {
            if (LOG_CLOSE.isDebugEnabled()) {
                LOG_CLOSE.debug("Closing {}", new Object[]{endPoint});
            }
            endPoint.close();
        }
    }

    protected void execute(Runnable runnable) {
        block2: {
            try {
                this.getExecutor().execute(runnable);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug("Job not dispatched: {}", new Object[]{runnable});
            }
        }
    }

    public void fillInterested() {
        this.stats.countFillInterestedEvents.incrementAndGet();
        super.fillInterested();
    }

    @Override
    public ByteBufferPool getBufferPool() {
        return this.bufferPool;
    }

    public List<ExtensionConfig> getExtensions() {
        return this.extensions;
    }

    public Generator getGenerator() {
        return this.generator;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public long getIdleTimeout() {
        return this.getEndPoint().getIdleTimeout();
    }

    @Override
    public IOState getIOState() {
        return this.ioState;
    }

    @Override
    public long getMaxIdleTimeout() {
        return this.getEndPoint().getIdleTimeout();
    }

    public Parser getParser() {
        return this.parser;
    }

    @Override
    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.getEndPoint().getRemoteAddress();
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public Stats getStats() {
        return this.stats;
    }

    @Override
    public boolean isOpen() {
        return this.getIOState().isOpen() && this.getEndPoint().isOpen();
    }

    @Override
    public boolean isReading() {
        return this.isFilling;
    }

    public void onClose() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} onClose()", new Object[]{this.policy.getBehavior()});
        }
        super.onClose();
        this.ioState.onDisconnected();
        this.flusher.close();
    }

    @Override
    public void onConnectionStateChange(ConnectionState connectionState) {
        if (LOG_CLOSE.isDebugEnabled()) {
            LOG_CLOSE.debug("{} Connection State Change: {}", new Object[]{this.policy.getBehavior(), connectionState});
        }
        switch (connectionState) {
            case OPEN: {
                if (BufferUtil.hasContent((ByteBuffer)this.prefillBuffer)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Parsing Upgrade prefill buffer ({} remaining)", (long)this.prefillBuffer.remaining());
                    }
                    this.parser.parse(this.prefillBuffer);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("OPEN: normal fillInterested", new Object[0]);
                }
                this.fillInterested();
                break;
            }
            case CLOSED: {
                if (LOG_CLOSE.isDebugEnabled()) {
                    LOG_CLOSE.debug("CLOSED - wasAbnormalClose: {}", new Object[]{this.ioState.wasAbnormalClose()});
                }
                if (this.ioState.wasAbnormalClose()) {
                    CloseInfo closeInfo = new CloseInfo(1001, "Abnormal Close - " + this.ioState.getCloseInfo().getReason());
                    this.outgoingFrame(closeInfo.asFrame(), new OnDisconnectCallback(false), BatchMode.OFF);
                    break;
                }
                this.disconnect(false);
                break;
            }
            case CLOSING: {
                if (LOG_CLOSE.isDebugEnabled()) {
                    LOG_CLOSE.debug("CLOSING - wasRemoteCloseInitiated: {}", new Object[]{this.ioState.wasRemoteCloseInitiated()});
                }
                if (!this.ioState.wasRemoteCloseInitiated()) break;
                CloseInfo closeInfo = this.ioState.getCloseInfo();
                this.outgoingFrame(closeInfo.asFrame(), new OnCloseLocalCallback(new OnDisconnectCallback(true), closeInfo), BatchMode.OFF);
            }
        }
    }

    public void onFillable() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} onFillable()", new Object[]{this.policy.getBehavior()});
        }
        this.stats.countOnFillableEvents.incrementAndGet();
        ByteBuffer byteBuffer = this.bufferPool.acquire(this.getInputBufferSize(), true);
        try {
            this.isFilling = true;
            this.readMode = this.readMode == ReadMode.PARSE ? this.readParse(byteBuffer) : this.readDiscard(byteBuffer);
        }
        finally {
            this.bufferPool.release(byteBuffer);
        }
        if (this.readMode != ReadMode.EOF && !this.suspendToken.get()) {
            this.fillInterested();
        } else {
            this.isFilling = false;
        }
    }

    protected void onFillInterestedFailed(Throwable throwable) {
        LOG.ignore(throwable);
        this.stats.countFillInterestedEvents.incrementAndGet();
        super.onFillInterestedFailed(throwable);
    }

    protected void setInitialBuffer(ByteBuffer byteBuffer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("set Initial Buffer - {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)byteBuffer)});
        }
        this.prefillBuffer = byteBuffer;
    }

    private void notifyError(Throwable throwable) {
        this.getParser().getIncomingFramesHandler().incomingError(throwable);
    }

    public void onOpen() {
        if (LOG_OPEN.isDebugEnabled()) {
            LOG_OPEN.debug("[{}] {}.onOpened()", new Object[]{this.policy.getBehavior(), this.getClass().getSimpleName()});
        }
        super.onOpen();
        this.ioState.onOpened();
    }

    protected boolean onReadTimeout() {
        IOState iOState = this.getIOState();
        ConnectionState connectionState = iOState.getConnectionState();
        if (LOG_CLOSE.isDebugEnabled()) {
            LOG_CLOSE.debug("{} Read Timeout - {}", new Object[]{this.policy.getBehavior(), connectionState});
        }
        if (connectionState == ConnectionState.CLOSED) {
            if (LOG_CLOSE.isDebugEnabled()) {
                LOG_CLOSE.debug("onReadTimeout - Connection Already CLOSED", new Object[0]);
            }
            return true;
        }
        try {
            this.notifyError(new SocketTimeoutException("Timeout on Read"));
        }
        finally {
            this.close(1001, "Idle Timeout");
        }
        return false;
    }

    public void outgoingFrame(Frame frame, WriteCallback writeCallback, BatchMode batchMode) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("outgoingFrame({}, {})", new Object[]{frame, writeCallback});
        }
        this.flusher.enqueue(frame, writeCallback, batchMode);
    }

    private ReadMode readDiscard(ByteBuffer byteBuffer) {
        EndPoint endPoint = this.getEndPoint();
        try {
            while (true) {
                int n;
                if ((n = endPoint.fill(byteBuffer)) == 0) {
                    return ReadMode.DISCARD;
                }
                if (n < 0) {
                    if (LOG_CLOSE.isDebugEnabled()) {
                        LOG_CLOSE.debug("read - EOF Reached (remote: {})", new Object[]{this.getRemoteAddress()});
                    }
                    return ReadMode.EOF;
                }
                if (!LOG_CLOSE.isDebugEnabled()) continue;
                LOG_CLOSE.debug("Discarded {} bytes - {}", new Object[]{n, BufferUtil.toDetailString((ByteBuffer)byteBuffer)});
            }
        }
        catch (IOException iOException) {
            LOG.ignore((Throwable)iOException);
            return ReadMode.EOF;
        }
        catch (Throwable throwable) {
            LOG.ignore(throwable);
            return ReadMode.DISCARD;
        }
    }

    private ReadMode readParse(ByteBuffer byteBuffer) {
        EndPoint endPoint = this.getEndPoint();
        try {
            while (true) {
                int n;
                if ((n = endPoint.fill(byteBuffer)) < 0) {
                    LOG.debug("read - EOF Reached (remote: {})", new Object[]{this.getRemoteAddress()});
                    this.ioState.onReadFailure(new EOFException("Remote Read EOF"));
                    return ReadMode.EOF;
                }
                if (n == 0) {
                    return ReadMode.PARSE;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Filled {} bytes - {}", new Object[]{n, BufferUtil.toDetailString((ByteBuffer)byteBuffer)});
                }
                this.parser.parse(byteBuffer);
            }
        }
        catch (IOException iOException) {
            LOG.warn((Throwable)iOException);
            this.close(1002, iOException.getMessage());
            return ReadMode.DISCARD;
        }
        catch (CloseException closeException) {
            LOG.debug((Throwable)closeException);
            this.close(closeException.getStatusCode(), closeException.getMessage());
            return ReadMode.DISCARD;
        }
        catch (Throwable throwable) {
            LOG.warn(throwable);
            this.close(1006, throwable.getMessage());
            return ReadMode.DISCARD;
        }
    }

    public void resume() {
        if (this.suspendToken.getAndSet(false)) {
            this.fillInterested();
        }
    }

    public void setExtensions(List<ExtensionConfig> list) {
        this.extensions = list;
    }

    public void setInputBufferSize(int n) {
        if (n < 28) {
            throw new IllegalArgumentException("Cannot have buffer size less than 28");
        }
        super.setInputBufferSize(n);
    }

    @Override
    public void setMaxIdleTimeout(long l) {
        this.getEndPoint().setIdleTimeout(l);
    }

    @Override
    public SuspendToken suspend() {
        this.suspendToken.set(true);
        return this;
    }

    public String dump() {
        return ContainerLifeCycle.dump((Dumpable)this);
    }

    public void dump(Appendable appendable, String string) {
        appendable.append(this.toString()).append(System.lineSeparator());
    }

    public String toString() {
        return String.format("%s@%X{endp=%s,ios=%s,f=%s,g=%s,p=%s}", this.getClass().getSimpleName(), this.hashCode(), this.getEndPoint(), this.ioState, this.flusher, this.generator, this.parser);
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        EndPoint endPoint = this.getEndPoint();
        if (endPoint != null) {
            n2 = 31 * n2 + endPoint.getLocalAddress().hashCode();
            n2 = 31 * n2 + endPoint.getRemoteAddress().hashCode();
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AbstractWebSocketConnection abstractWebSocketConnection = (AbstractWebSocketConnection)object;
        EndPoint endPoint = this.getEndPoint();
        EndPoint endPoint2 = abstractWebSocketConnection.getEndPoint();
        return !(endPoint == null ? endPoint2 != null : !endPoint.equals(endPoint2));
    }

    public void onUpgradeTo(ByteBuffer byteBuffer) {
        this.setInitialBuffer(byteBuffer);
    }

    private static enum ReadMode {
        PARSE,
        DISCARD,
        EOF;

    }

    public static class Stats {
        private AtomicLong countFillInterestedEvents = new AtomicLong(0L);
        private AtomicLong countOnFillableEvents = new AtomicLong(0L);
        private AtomicLong countFillableErrors = new AtomicLong(0L);

        public long getFillableErrorCount() {
            return this.countFillableErrors.get();
        }

        public long getFillInterestedCount() {
            return this.countFillInterestedEvents.get();
        }

        public long getOnFillableCount() {
            return this.countOnFillableEvents.get();
        }
    }

    public class OnCloseLocalCallback
    implements WriteCallback {
        private final WriteCallback callback;
        private final CloseInfo close;

        public OnCloseLocalCallback(WriteCallback writeCallback, CloseInfo closeInfo) {
            this.callback = writeCallback;
            this.close = closeInfo;
        }

        public OnCloseLocalCallback(CloseInfo closeInfo) {
            this(null, closeInfo);
        }

        public void writeFailed(Throwable throwable) {
            try {
                if (this.callback != null) {
                    this.callback.writeFailed(throwable);
                }
            }
            finally {
                this.onLocalClose();
            }
        }

        public void writeSuccess() {
            try {
                if (this.callback != null) {
                    this.callback.writeSuccess();
                }
            }
            finally {
                this.onLocalClose();
            }
        }

        private void onLocalClose() {
            if (LOG_CLOSE.isDebugEnabled()) {
                LOG_CLOSE.debug("Local Close Confirmed {}", new Object[]{this.close});
            }
            if (this.close.isAbnormal()) {
                AbstractWebSocketConnection.this.ioState.onAbnormalClose(this.close);
            } else {
                AbstractWebSocketConnection.this.ioState.onCloseLocal(this.close);
            }
        }
    }

    public class OnDisconnectCallback
    implements WriteCallback {
        private final boolean outputOnly;

        public OnDisconnectCallback(boolean bl) {
            this.outputOnly = bl;
        }

        public void writeFailed(Throwable throwable) {
            AbstractWebSocketConnection.this.disconnect(this.outputOnly);
        }

        public void writeSuccess() {
            AbstractWebSocketConnection.this.disconnect(this.outputOnly);
        }
    }

    private class Flusher
    extends FrameFlusher {
        private Flusher(ByteBufferPool byteBufferPool, Generator generator, EndPoint endPoint) {
            super(byteBufferPool, generator, endPoint, AbstractWebSocketConnection.this.getPolicy().getMaxBinaryMessageBufferSize(), 8);
        }

        @Override
        protected void onFailure(Throwable throwable) {
            AbstractWebSocketConnection.this.notifyError(throwable);
            if (AbstractWebSocketConnection.this.ioState.wasAbnormalClose()) {
                LOG.ignore(throwable);
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Write flush failure", throwable);
            }
            AbstractWebSocketConnection.this.ioState.onWriteFailure(throwable);
        }
    }
}

