/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.extensions.fragment;

import java.nio.ByteBuffer;
import java.util.Queue;
import org.eclipse.jetty.util.ConcurrentArrayQueue;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.OpCode;
import org.eclipse.jetty.websocket.common.extensions.AbstractExtension;
import org.eclipse.jetty.websocket.common.frames.DataFrame;

public class FragmentExtension
extends AbstractExtension {
    private static final Logger LOG = Log.getLogger(FragmentExtension.class);
    private final Queue<FrameEntry> entries = new ConcurrentArrayQueue();
    private final IteratingCallback flusher = new Flusher();
    private int maxLength;

    @Override
    public String getName() {
        return "fragment";
    }

    public void incomingFrame(Frame frame) {
        this.nextIncomingFrame(frame);
    }

    public void outgoingFrame(Frame frame, WriteCallback writeCallback, BatchMode batchMode) {
        int n;
        ByteBuffer byteBuffer = frame.getPayload();
        int n2 = n = byteBuffer != null ? byteBuffer.remaining() : 0;
        if (OpCode.isControlFrame(frame.getOpCode()) || this.maxLength <= 0 || n <= this.maxLength) {
            this.nextOutgoingFrame(frame, writeCallback, batchMode);
            return;
        }
        FrameEntry frameEntry = new FrameEntry(frame, writeCallback, batchMode);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Queuing {}", new Object[]{frameEntry});
        }
        this.entries.offer(frameEntry);
        this.flusher.iterate();
    }

    @Override
    public void setConfig(ExtensionConfig extensionConfig) {
        super.setConfig(extensionConfig);
        this.maxLength = extensionConfig.getParameter("maxLength", -1);
    }

    private class Flusher
    extends IteratingCallback
    implements WriteCallback {
        private FrameEntry current;
        private boolean finished = true;

        private Flusher() {
        }

        protected IteratingCallback.Action process() {
            if (this.finished) {
                this.current = (FrameEntry)FragmentExtension.this.entries.poll();
                LOG.debug("Processing {}", new Object[]{this.current});
                if (this.current == null) {
                    return IteratingCallback.Action.IDLE;
                }
                this.fragment(this.current, true);
            } else {
                this.fragment(this.current, false);
            }
            return IteratingCallback.Action.SCHEDULED;
        }

        private void fragment(FrameEntry frameEntry, boolean bl) {
            Frame frame = frameEntry.frame;
            ByteBuffer byteBuffer = frame.getPayload();
            int n = byteBuffer.remaining();
            int n2 = Math.min(n, FragmentExtension.this.maxLength);
            this.finished = n2 == n;
            boolean bl2 = frame.getType().isContinuation() || !bl;
            DataFrame dataFrame = new DataFrame(frame, bl2);
            boolean bl3 = frame.isFin() && this.finished;
            dataFrame.setFin(bl3);
            int n3 = byteBuffer.limit();
            int n4 = byteBuffer.position() + n2;
            byteBuffer.limit(n4);
            ByteBuffer byteBuffer2 = byteBuffer.slice();
            byteBuffer.limit(n3);
            dataFrame.setPayload(byteBuffer2);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Fragmented {}->{}", new Object[]{frame, dataFrame});
            }
            byteBuffer.position(n4);
            FragmentExtension.this.nextOutgoingFrame(dataFrame, this, frameEntry.batchMode);
        }

        protected void onCompleteSuccess() {
        }

        protected void onCompleteFailure(Throwable throwable) {
        }

        public void writeSuccess() {
            this.notifyCallbackSuccess(this.current.callback);
            this.succeeded();
        }

        public void writeFailed(Throwable throwable) {
            this.notifyCallbackFailure(this.current.callback, throwable);
            this.succeeded();
        }

        private void notifyCallbackSuccess(WriteCallback writeCallback) {
            block3: {
                try {
                    if (writeCallback != null) {
                        writeCallback.writeSuccess();
                    }
                }
                catch (Throwable throwable) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug("Exception while notifying success of callback " + writeCallback, throwable);
                }
            }
        }

        private void notifyCallbackFailure(WriteCallback writeCallback, Throwable throwable) {
            block3: {
                try {
                    if (writeCallback != null) {
                        writeCallback.writeFailed(throwable);
                    }
                }
                catch (Throwable throwable2) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug("Exception while notifying failure of callback " + writeCallback, throwable2);
                }
            }
        }
    }

    private static class FrameEntry {
        private final Frame frame;
        private final WriteCallback callback;
        private final BatchMode batchMode;

        private FrameEntry(Frame frame, WriteCallback writeCallback, BatchMode batchMode) {
            this.frame = frame;
            this.callback = writeCallback;
            this.batchMode = batchMode;
        }

        public String toString() {
            return this.frame.toString();
        }
    }
}

