/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.extensions.compress;

import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.BadPayloadException;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.OpCode;
import org.eclipse.jetty.websocket.common.extensions.compress.ByteAccumulator;
import org.eclipse.jetty.websocket.common.extensions.compress.CompressExtension;

public class PerMessageDeflateExtension
extends CompressExtension {
    private static final Logger LOG = Log.getLogger(PerMessageDeflateExtension.class);
    private ExtensionConfig configRequested;
    private ExtensionConfig configNegotiated;
    private boolean incomingContextTakeover = true;
    private boolean outgoingContextTakeover = true;
    private boolean incomingCompressed;

    @Override
    public String getName() {
        return "permessage-deflate";
    }

    public void incomingFrame(Frame frame) {
        if (frame.getType().isData()) {
            this.incomingCompressed = frame.isRsv1();
        }
        if (OpCode.isControlFrame(frame.getOpCode()) || !this.incomingCompressed) {
            this.nextIncomingFrame(frame);
            return;
        }
        ByteAccumulator byteAccumulator = this.newByteAccumulator();
        try {
            ByteBuffer byteBuffer = frame.getPayload();
            this.decompress(byteAccumulator, byteBuffer);
            if (frame.isFin()) {
                this.decompress(byteAccumulator, TAIL_BYTES_BUF.slice());
            }
            this.forwardIncoming(frame, byteAccumulator);
        }
        catch (DataFormatException dataFormatException) {
            throw new BadPayloadException((Throwable)dataFormatException);
        }
        if (frame.isFin()) {
            this.incomingCompressed = false;
        }
    }

    @Override
    protected void nextIncomingFrame(Frame frame) {
        if (frame.isFin() && !this.incomingContextTakeover) {
            LOG.debug("Incoming Context Reset", new Object[0]);
            this.decompressCount.set(0);
            this.getInflater().reset();
        }
        super.nextIncomingFrame(frame);
    }

    @Override
    protected void nextOutgoingFrame(Frame frame, WriteCallback writeCallback, BatchMode batchMode) {
        if (frame.isFin() && !this.outgoingContextTakeover) {
            LOG.debug("Outgoing Context Reset", new Object[0]);
            this.getDeflater().reset();
        }
        super.nextOutgoingFrame(frame, writeCallback, batchMode);
    }

    @Override
    int getRsvUseMode() {
        return 1;
    }

    @Override
    int getTailDropMode() {
        return 2;
    }

    @Override
    public void setConfig(ExtensionConfig extensionConfig) {
        this.configRequested = new ExtensionConfig(extensionConfig);
        this.configNegotiated = new ExtensionConfig(extensionConfig.getName());
        block19: for (String string : extensionConfig.getParameterKeys()) {
            switch (string = string.trim()) {
                case "client_max_window_bits": 
                case "server_max_window_bits": {
                    continue block19;
                }
                case "client_no_context_takeover": {
                    this.configNegotiated.setParameter("client_no_context_takeover");
                    switch (this.getPolicy().getBehavior()) {
                        case CLIENT: {
                            this.incomingContextTakeover = false;
                            break;
                        }
                        case SERVER: {
                            this.outgoingContextTakeover = false;
                        }
                    }
                    continue block19;
                }
                case "server_no_context_takeover": {
                    this.configNegotiated.setParameter("server_no_context_takeover");
                    switch (this.getPolicy().getBehavior()) {
                        case CLIENT: {
                            this.outgoingContextTakeover = false;
                            break;
                        }
                        case SERVER: {
                            this.incomingContextTakeover = false;
                        }
                    }
                    continue block19;
                }
            }
            throw new IllegalArgumentException();
        }
        LOG.debug("config: outgoingContextTakover={}, incomingContextTakeover={} : {}", new Object[]{this.outgoingContextTakeover, this.incomingContextTakeover, this});
        super.setConfig(this.configNegotiated);
    }

    @Override
    public String toString() {
        return String.format("%s[requested=\"%s\", negotiated=\"%s\"]", ((Object)((Object)this)).getClass().getSimpleName(), this.configRequested.getParameterizedName(), this.configNegotiated.getParameterizedName());
    }
}

