/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.extensions.compress;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import java.util.zip.ZipException;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.ConcurrentArrayQueue;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.OpCode;
import org.eclipse.jetty.websocket.common.extensions.AbstractExtension;
import org.eclipse.jetty.websocket.common.extensions.compress.ByteAccumulator;
import org.eclipse.jetty.websocket.common.frames.DataFrame;

public abstract class CompressExtension
extends AbstractExtension {
    protected static final byte[] TAIL_BYTES = new byte[]{0, 0, -1, -1};
    protected static final ByteBuffer TAIL_BYTES_BUF = ByteBuffer.wrap(TAIL_BYTES);
    private static final Logger LOG = Log.getLogger(CompressExtension.class);
    protected static final int TAIL_DROP_NEVER = 0;
    protected static final int TAIL_DROP_ALWAYS = 1;
    protected static final int TAIL_DROP_FIN_ONLY = 2;
    protected static final int RSV_USE_ALWAYS = 0;
    protected static final int RSV_USE_ONLY_FIRST = 1;
    protected static final int INFLATE_BUFFER_SIZE = 8192;
    protected static final int INPUT_MAX_BUFFER_SIZE = 8192;
    private static final int DECOMPRESS_BUF_SIZE = 8192;
    private static final boolean NOWRAP = true;
    private final Queue<FrameEntry> entries = new ConcurrentArrayQueue();
    private final IteratingCallback flusher = new Flusher();
    private final Deflater deflater;
    private final Inflater inflater;
    protected AtomicInteger decompressCount = new AtomicInteger(0);
    private int tailDrop = 0;
    private int rsvUse = 0;

    protected CompressExtension() {
        this.deflater = new Deflater(-1, true);
        this.inflater = new Inflater(true);
        this.tailDrop = this.getTailDropMode();
        this.rsvUse = this.getRsvUseMode();
    }

    public Deflater getDeflater() {
        return this.deflater;
    }

    public Inflater getInflater() {
        return this.inflater;
    }

    @Override
    public boolean isRsv1User() {
        return true;
    }

    abstract int getTailDropMode();

    abstract int getRsvUseMode();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forwardIncoming(Frame frame, ByteAccumulator byteAccumulator) {
        DataFrame dataFrame = new DataFrame(frame);
        dataFrame.setRsv1(false);
        ByteBuffer byteBuffer = this.getBufferPool().acquire(byteAccumulator.getLength(), false);
        try {
            BufferUtil.flipToFill((ByteBuffer)byteBuffer);
            byteAccumulator.transferTo(byteBuffer);
            dataFrame.setPayload(byteBuffer);
            this.nextIncomingFrame(dataFrame);
        }
        finally {
            this.getBufferPool().release(byteBuffer);
        }
    }

    protected ByteAccumulator newByteAccumulator() {
        int n = Math.max(this.getPolicy().getMaxTextMessageSize(), this.getPolicy().getMaxBinaryMessageBufferSize());
        return new ByteAccumulator(n);
    }

    protected void decompress(ByteAccumulator byteAccumulator, ByteBuffer byteBuffer) {
        if (byteBuffer == null || !byteBuffer.hasRemaining()) {
            return;
        }
        byte[] byArray = new byte[8192];
        block0: while (byteBuffer.hasRemaining() && this.inflater.needsInput()) {
            if (!CompressExtension.supplyInput(this.inflater, byteBuffer)) {
                LOG.debug("Needed input, but no buffer could supply input", new Object[0]);
                return;
            }
            int n = 0;
            while ((n = this.inflater.inflate(byArray)) >= 0) {
                if (n == 0) {
                    LOG.debug("Decompress: read 0 {}", new Object[]{CompressExtension.toDetail(this.inflater)});
                    continue block0;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Decompressed {} bytes: {}", new Object[]{n, CompressExtension.toDetail(this.inflater)});
                }
                byteAccumulator.copyChunk(byArray, 0, n);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Decompress: exiting {}", new Object[]{CompressExtension.toDetail(this.inflater)});
        }
    }

    public void outgoingFrame(Frame frame, WriteCallback writeCallback, BatchMode batchMode) {
        if (this.flusher.isFailed()) {
            this.notifyCallbackFailure(writeCallback, new ZipException());
            return;
        }
        FrameEntry frameEntry = new FrameEntry(frame, writeCallback, batchMode);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Queuing {}", new Object[]{frameEntry});
        }
        this.entries.offer(frameEntry);
        this.flusher.iterate();
    }

    protected void notifyCallbackSuccess(WriteCallback writeCallback) {
        block3: {
            try {
                if (writeCallback != null) {
                    writeCallback.writeSuccess();
                }
            }
            catch (Throwable throwable) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("Exception while notifying success of callback " + writeCallback, throwable);
            }
        }
    }

    protected void notifyCallbackFailure(WriteCallback writeCallback, Throwable throwable) {
        block3: {
            try {
                if (writeCallback != null) {
                    writeCallback.writeFailed(throwable);
                }
            }
            catch (Throwable throwable2) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("Exception while notifying failure of callback " + writeCallback, throwable2);
            }
        }
    }

    private static boolean supplyInput(Inflater inflater, ByteBuffer byteBuffer) {
        byte[] byArray;
        int n;
        if (byteBuffer.remaining() <= 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No data left left to supply to Inflater", new Object[0]);
            }
            return false;
        }
        int n2 = 0;
        if (byteBuffer.hasArray()) {
            n = byteBuffer.remaining();
            byArray = byteBuffer.array();
            n2 = byteBuffer.position() + byteBuffer.arrayOffset();
            byteBuffer.position(byteBuffer.position() + n);
        } else {
            n = Math.min(8192, byteBuffer.remaining());
            byArray = new byte[n];
            n2 = 0;
            byteBuffer.get(byArray, 0, n);
        }
        inflater.setInput(byArray, n2, n);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Supplied {} input bytes: {}", new Object[]{byArray.length, CompressExtension.toDetail(inflater)});
        }
        return true;
    }

    private static boolean supplyInput(Deflater deflater, ByteBuffer byteBuffer) {
        byte[] byArray;
        int n;
        if (byteBuffer.remaining() <= 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No data left left to supply to Deflater", new Object[0]);
            }
            return false;
        }
        int n2 = 0;
        if (byteBuffer.hasArray()) {
            n = byteBuffer.remaining();
            byArray = byteBuffer.array();
            n2 = byteBuffer.position() + byteBuffer.arrayOffset();
            byteBuffer.position(byteBuffer.position() + n);
        } else {
            n = Math.min(8192, byteBuffer.remaining());
            byArray = new byte[n];
            n2 = 0;
            byteBuffer.get(byArray, 0, n);
        }
        deflater.setInput(byArray, n2, n);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Supplied {} input bytes: {}", new Object[]{byArray.length, CompressExtension.toDetail(deflater)});
        }
        return true;
    }

    private static String toDetail(Inflater inflater) {
        return String.format("Inflater[finished=%b,read=%d,written=%d,remaining=%d,in=%d,out=%d]", inflater.finished(), inflater.getBytesRead(), inflater.getBytesWritten(), inflater.getRemaining(), inflater.getTotalIn(), inflater.getTotalOut());
    }

    private static String toDetail(Deflater deflater) {
        return String.format("Deflater[finished=%b,read=%d,written=%d,in=%d,out=%d]", deflater.finished(), deflater.getBytesRead(), deflater.getBytesWritten(), deflater.getTotalIn(), deflater.getTotalOut());
    }

    public static boolean endsWithTail(ByteBuffer byteBuffer) {
        if (byteBuffer == null || byteBuffer.remaining() < TAIL_BYTES.length) {
            return false;
        }
        int n = byteBuffer.limit();
        for (int i = TAIL_BYTES.length; i > 0; --i) {
            if (byteBuffer.get(n - i) == TAIL_BYTES[TAIL_BYTES.length - i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    private class Flusher
    extends IteratingCallback
    implements WriteCallback {
        private FrameEntry current;
        private boolean finished = true;

        private Flusher() {
        }

        public void failed(Throwable throwable) {
            LOG.warn(throwable);
            super.failed(throwable);
        }

        protected IteratingCallback.Action process() {
            if (this.finished) {
                this.current = (FrameEntry)CompressExtension.this.entries.poll();
                LOG.debug("Processing {}", new Object[]{this.current});
                if (this.current == null) {
                    return IteratingCallback.Action.IDLE;
                }
                this.deflate(this.current);
            } else {
                this.compress(this.current, false);
            }
            return IteratingCallback.Action.SCHEDULED;
        }

        private void deflate(FrameEntry frameEntry) {
            Frame frame = frameEntry.frame;
            BatchMode batchMode = frameEntry.batchMode;
            if (OpCode.isControlFrame(frame.getOpCode())) {
                CompressExtension.this.nextOutgoingFrame(frame, this, batchMode);
                return;
            }
            this.compress(frameEntry, true);
        }

        private void compress(FrameEntry frameEntry, boolean bl) {
            Frame frame = frameEntry.frame;
            ByteBuffer byteBuffer = frame.getPayload();
            int n = byteBuffer.remaining();
            int n2 = Math.max(256, byteBuffer.remaining());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Compressing {}: {} bytes in {} bytes chunk", new Object[]{frameEntry, n, n2});
            }
            boolean bl2 = true;
            if (CompressExtension.this.deflater.needsInput() && !CompressExtension.supplyInput(CompressExtension.this.deflater, byteBuffer)) {
                bl2 = false;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[n2];
            boolean bl3 = frame.isFin();
            while (bl2) {
                int n3 = CompressExtension.this.deflater.deflate(byArray, 0, n2, 2);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Wrote {} bytes to output buffer", (long)n3);
                }
                byteArrayOutputStream.write(byArray, 0, n3);
                if (n3 >= n2) continue;
                bl2 = false;
            }
            ByteBuffer byteBuffer2 = ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
            if (byteBuffer2.remaining() > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("compressed bytes[] = {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)byteBuffer2)});
                }
                if (CompressExtension.this.tailDrop == 1) {
                    if (CompressExtension.endsWithTail(byteBuffer2)) {
                        byteBuffer2.limit(byteBuffer2.limit() - TAIL_BYTES.length);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("payload (TAIL_DROP_ALWAYS) = {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)byteBuffer2)});
                    }
                } else if (CompressExtension.this.tailDrop == 2) {
                    if (frame.isFin() && CompressExtension.endsWithTail(byteBuffer2)) {
                        byteBuffer2.limit(byteBuffer2.limit() - TAIL_BYTES.length);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("payload (TAIL_DROP_FIN_ONLY) = {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)byteBuffer2)});
                    }
                }
            } else if (bl3) {
                byteBuffer2 = ByteBuffer.wrap(new byte[]{0});
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Compressed {}: input:{} -> payload:{}", new Object[]{frameEntry, n2, byteBuffer2.remaining()});
            }
            boolean bl4 = frame.getType().isContinuation() || !bl;
            DataFrame dataFrame = new DataFrame(frame, bl4);
            if (CompressExtension.this.rsvUse == 1) {
                dataFrame.setRsv1(!bl4);
            } else {
                dataFrame.setRsv1(true);
            }
            dataFrame.setPayload(byteBuffer2);
            dataFrame.setFin(bl3);
            CompressExtension.this.nextOutgoingFrame(dataFrame, this, frameEntry.batchMode);
        }

        protected void onCompleteSuccess() {
        }

        protected void onCompleteFailure(Throwable throwable) {
            FrameEntry frameEntry;
            while ((frameEntry = (FrameEntry)CompressExtension.this.entries.poll()) != null) {
                CompressExtension.this.notifyCallbackFailure(frameEntry.callback, throwable);
            }
        }

        public void writeSuccess() {
            if (this.finished) {
                CompressExtension.this.notifyCallbackSuccess(this.current.callback);
            }
            this.succeeded();
        }

        public void writeFailed(Throwable throwable) {
            CompressExtension.this.notifyCallbackFailure(this.current.callback, throwable);
            this.failed(throwable);
        }
    }

    private static class FrameEntry {
        private final Frame frame;
        private final WriteCallback callback;
        private final BatchMode batchMode;

        private FrameEntry(Frame frame, WriteCallback writeCallback, BatchMode batchMode) {
            this.frame = frame;
            this.callback = writeCallback;
            this.batchMode = batchMode;
        }

        public String toString() {
            return this.frame.toString();
        }
    }
}

