/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.extensions.compress;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.websocket.api.MessageTooLargeException;

public class ByteAccumulator {
    private final List<byte[]> chunks = new ArrayList<byte[]>();
    private final int maxSize;
    private int length = 0;

    public ByteAccumulator(int n) {
        this.maxSize = n;
    }

    public void copyChunk(byte[] byArray, int n, int n2) {
        if (this.length + n2 > this.maxSize) {
            throw new MessageTooLargeException("Frame is too large");
        }
        byte[] byArray2 = new byte[n2 - n];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.chunks.add(byArray2);
        this.length += n2;
    }

    public int getLength() {
        return this.length;
    }

    public void transferTo(ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() < this.length) {
            throw new IllegalArgumentException(String.format("Not enough space in ByteBuffer remaining [%d] for accumulated buffers length [%d]", byteBuffer.remaining(), this.length));
        }
        int n = byteBuffer.position();
        for (byte[] byArray : this.chunks) {
            byteBuffer.put(byArray, 0, byArray.length);
        }
        BufferUtil.flipToFlush((ByteBuffer)byteBuffer, (int)n);
    }
}

