/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.extensions;

import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.eclipse.jetty.websocket.api.extensions.Extension;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.extensions.ExtensionFactory;
import org.eclipse.jetty.websocket.common.extensions.AbstractExtension;
import org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;

public class WebSocketExtensionFactory
extends ExtensionFactory {
    private WebSocketContainerScope container;

    public WebSocketExtensionFactory(WebSocketContainerScope webSocketContainerScope) {
        this.container = webSocketContainerScope;
    }

    public Extension newInstance(ExtensionConfig extensionConfig) {
        if (extensionConfig == null) {
            return null;
        }
        String string = extensionConfig.getName();
        if (StringUtil.isBlank((String)string)) {
            return null;
        }
        Class clazz = this.getExtension(string);
        if (clazz == null) {
            return null;
        }
        try {
            Extension extension = (Extension)this.container.getObjectFactory().createInstance(clazz);
            if (extension instanceof AbstractExtension) {
                AbstractExtension abstractExtension = (AbstractExtension)extension;
                abstractExtension.init(this.container);
                abstractExtension.setConfig(extensionConfig);
            }
            return extension;
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            throw new WebSocketException("Cannot instantiate extension: " + clazz, (Throwable)reflectiveOperationException);
        }
    }
}

