/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.extensions;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Calendar;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.Generator;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.extensions.AbstractExtension;

public class FrameCaptureExtension
extends AbstractExtension {
    private static final Logger LOG = Log.getLogger(FrameCaptureExtension.class);
    private static final int BUFSIZE = 32768;
    private Generator generator;
    private Path outputDir;
    private String prefix = "frame";
    private Path incomingFramesPath;
    private Path outgoingFramesPath;
    private AtomicInteger incomingCount = new AtomicInteger(0);
    private AtomicInteger outgoingCount = new AtomicInteger(0);
    private SeekableByteChannel incomingChannel;
    private SeekableByteChannel outgoingChannel;

    @Override
    public String getName() {
        return "@frame-capture";
    }

    public void incomingFrame(Frame frame) {
        this.saveFrame(frame, false);
        try {
            this.nextIncomingFrame(frame);
        }
        catch (Throwable throwable) {
            IO.close((Closeable)this.incomingChannel);
            this.incomingChannel = null;
            throw throwable;
        }
    }

    public void outgoingFrame(Frame frame, WriteCallback writeCallback, BatchMode batchMode) {
        this.saveFrame(frame, true);
        try {
            this.nextOutgoingFrame(frame, writeCallback, batchMode);
        }
        catch (Throwable throwable) {
            IO.close((Closeable)this.outgoingChannel);
            this.outgoingChannel = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveFrame(Frame frame, boolean bl) {
        SeekableByteChannel seekableByteChannel;
        if (this.outputDir == null || this.generator == null) {
            return;
        }
        SeekableByteChannel seekableByteChannel2 = seekableByteChannel = bl ? this.outgoingChannel : this.incomingChannel;
        if (seekableByteChannel == null) {
            return;
        }
        ByteBuffer byteBuffer = this.getBufferPool().acquire(32768, false);
        try {
            WebSocketFrame webSocketFrame = WebSocketFrame.copy(frame);
            webSocketFrame.setMasked(false);
            this.generator.generateHeaderBytes(webSocketFrame, byteBuffer);
            seekableByteChannel.write(byteBuffer);
            if (frame.hasPayload()) {
                seekableByteChannel.write(frame.getPayload().slice());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Saved {} frame #{}", new Object[]{bl ? "outgoing" : "incoming", bl ? this.outgoingCount.incrementAndGet() : this.incomingCount.incrementAndGet()});
            }
        }
        catch (IOException iOException) {
            LOG.warn("Unable to save frame: " + frame, (Throwable)iOException);
        }
        finally {
            this.getBufferPool().release(byteBuffer);
        }
    }

    @Override
    public void setConfig(ExtensionConfig extensionConfig) {
        Object object;
        super.setConfig(extensionConfig);
        String string = extensionConfig.getParameter("output-dir", null);
        if (StringUtil.isNotBlank((String)string)) {
            object = new File(string).toPath();
            if (Files.isDirectory((Path)object, new LinkOption[0]) && Files.exists((Path)object, new LinkOption[0]) && Files.isWritable((Path)object)) {
                this.outputDir = object;
            } else {
                LOG.warn("Unable to configure {}: not a valid output directory", new Object[]{object.toAbsolutePath().toString()});
            }
        }
        if (StringUtil.isNotBlank((String)(object = extensionConfig.getParameter("prefix", "frame")))) {
            this.prefix = object;
        }
        if (this.outputDir != null) {
            try {
                Path path = this.outputDir.toRealPath(new LinkOption[0]);
                String string2 = String.format("%1$tY%1$tm%1$td-%1$tH%1$tM%1$tS", Calendar.getInstance());
                this.incomingFramesPath = path.resolve(String.format("%s-%s-incoming.dat", this.prefix, string2));
                this.outgoingFramesPath = path.resolve(String.format("%s-%s-outgoing.dat", this.prefix, string2));
                this.incomingChannel = Files.newByteChannel(this.incomingFramesPath, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
                this.outgoingChannel = Files.newByteChannel(this.outgoingFramesPath, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
                this.generator = new Generator(WebSocketPolicy.newServerPolicy(), this.getBufferPool(), false, true);
            }
            catch (IOException iOException) {
                LOG.warn("Unable to create capture file(s)", (Throwable)iOException);
            }
        }
    }
}

