/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.extensions;

import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.Extension;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import org.eclipse.jetty.websocket.api.extensions.OutgoingFrames;
import org.eclipse.jetty.websocket.common.LogicalConnection;
import org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;

@ManagedObject(value="Abstract Extension")
public abstract class AbstractExtension
extends ContainerLifeCycle
implements Extension {
    private final Logger log = Log.getLogger(((Object)((Object)this)).getClass());
    private WebSocketPolicy policy;
    private ByteBufferPool bufferPool;
    private ExtensionConfig config;
    private LogicalConnection connection;
    private OutgoingFrames nextOutgoing;
    private IncomingFrames nextIncoming;

    public void dump(Appendable appendable, String string) {
        super.dump(appendable, string);
        this.dumpWithHeading(appendable, string, "incoming", this.nextIncoming);
        this.dumpWithHeading(appendable, string, "outgoing", this.nextOutgoing);
    }

    protected void dumpWithHeading(Appendable appendable, String string, String string2, Object object) {
        appendable.append(string).append(" +- ");
        appendable.append(string2).append(" : ");
        appendable.append(object.toString());
    }

    public void init(WebSocketContainerScope webSocketContainerScope) {
        this.policy = webSocketContainerScope.getPolicy();
        this.bufferPool = webSocketContainerScope.getBufferPool();
    }

    public ByteBufferPool getBufferPool() {
        return this.bufferPool;
    }

    public ExtensionConfig getConfig() {
        return this.config;
    }

    public LogicalConnection getConnection() {
        return this.connection;
    }

    public String getName() {
        return this.config.getName();
    }

    @ManagedAttribute(name="Next Incoming Frame Handler", readonly=true)
    public IncomingFrames getNextIncoming() {
        return this.nextIncoming;
    }

    @ManagedAttribute(name="Next Outgoing Frame Handler", readonly=true)
    public OutgoingFrames getNextOutgoing() {
        return this.nextOutgoing;
    }

    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    public void incomingError(Throwable throwable) {
        this.nextIncomingError(throwable);
    }

    public boolean isRsv1User() {
        return false;
    }

    public boolean isRsv2User() {
        return false;
    }

    public boolean isRsv3User() {
        return false;
    }

    protected void nextIncomingError(Throwable throwable) {
        this.nextIncoming.incomingError(throwable);
    }

    protected void nextIncomingFrame(Frame frame) {
        this.log.debug("nextIncomingFrame({})", new Object[]{frame});
        this.nextIncoming.incomingFrame(frame);
    }

    protected void nextOutgoingFrame(Frame frame, WriteCallback writeCallback, BatchMode batchMode) {
        this.log.debug("nextOutgoingFrame({})", new Object[]{frame});
        this.nextOutgoing.outgoingFrame(frame, writeCallback, batchMode);
    }

    public void setBufferPool(ByteBufferPool byteBufferPool) {
        this.bufferPool = byteBufferPool;
    }

    public void setConfig(ExtensionConfig extensionConfig) {
        this.config = extensionConfig;
    }

    public void setConnection(LogicalConnection logicalConnection) {
        this.connection = logicalConnection;
    }

    public void setNextIncomingFrames(IncomingFrames incomingFrames) {
        this.nextIncoming = incomingFrames;
    }

    public void setNextOutgoingFrames(OutgoingFrames outgoingFrames) {
        this.nextOutgoing = outgoingFrames;
    }

    public void setPolicy(WebSocketPolicy webSocketPolicy) {
        this.policy = webSocketPolicy;
    }

    public String toString() {
        return String.format("%s[%s]", ((Object)((Object)this)).getClass().getSimpleName(), this.config.getParameterizedName());
    }
}

