/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.events.annotated;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.eclipse.jetty.websocket.api.InvalidWebSocketException;
import org.eclipse.jetty.websocket.common.events.ParamList;
import org.eclipse.jetty.websocket.common.events.annotated.CallableMethod;
import org.eclipse.jetty.websocket.common.events.annotated.InvalidSignatureException;

public abstract class AbstractMethodAnnotationScanner<T> {
    protected void assertIsPublicNonStatic(Method method) {
        int n = method.getModifiers();
        if (!Modifier.isPublic(n)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Invalid declaration of ");
            stringBuilder.append(method);
            stringBuilder.append(System.lineSeparator());
            stringBuilder.append("Method modifier must be public");
            throw new InvalidWebSocketException(stringBuilder.toString());
        }
        if (Modifier.isStatic(n)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Invalid declaration of ");
            stringBuilder.append(method);
            stringBuilder.append(System.lineSeparator());
            stringBuilder.append("Method modifier may not be static");
            throw new InvalidWebSocketException(stringBuilder.toString());
        }
    }

    protected void assertIsReturn(Method method, Class<?> clazz) {
        if (!clazz.equals(method.getReturnType())) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Invalid declaration of ");
            stringBuilder.append(method);
            stringBuilder.append(System.lineSeparator());
            stringBuilder.append("Return type must be ").append(clazz);
            throw new InvalidWebSocketException(stringBuilder.toString());
        }
    }

    protected void assertIsVoidReturn(Method method) {
        this.assertIsReturn(method, Void.TYPE);
    }

    protected void assertUnset(CallableMethod callableMethod, Class<? extends Annotation> clazz, Method method) {
        if (callableMethod != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Duplicate @").append(clazz.getSimpleName()).append(" declaration on ");
            stringBuilder.append(method);
            stringBuilder.append(System.lineSeparator());
            stringBuilder.append("@").append(clazz.getSimpleName()).append(" previously declared at ");
            stringBuilder.append(callableMethod.getMethod());
            throw new InvalidWebSocketException(stringBuilder.toString());
        }
    }

    protected void assertValidSignature(Method method, Class<? extends Annotation> clazz, ParamList paramList) {
        this.assertIsPublicNonStatic(method);
        this.assertIsReturn(method, Void.TYPE);
        boolean bl = false;
        Class<?>[] classArray = method.getParameterTypes();
        for (Class[] classArray2 : paramList) {
            if (!this.isSameParameters(classArray, classArray2)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw InvalidSignatureException.build(method, clazz, paramList);
        }
    }

    public boolean isAnnotation(Annotation annotation, Class<? extends Annotation> clazz) {
        return annotation.annotationType().equals(clazz);
    }

    public boolean isSameParameters(Class<?>[] classArray, Class<?>[] classArray2) {
        if (classArray.length != classArray2.length) {
            return false;
        }
        int n = classArray2.length;
        for (int i = 0; i < n; ++i) {
            if (classArray[i].equals(classArray2[i])) continue;
            return false;
        }
        return true;
    }

    protected boolean isSignatureMatch(Method method, ParamList paramList) {
        this.assertIsPublicNonStatic(method);
        this.assertIsReturn(method, Void.TYPE);
        Class<?>[] classArray = method.getParameterTypes();
        for (Class[] classArray2 : paramList) {
            if (!this.isSameParameters(classArray, classArray2)) continue;
            return true;
        }
        return false;
    }

    protected boolean isTypeAnnotated(Class<?> clazz, Class<? extends Annotation> clazz2) {
        return clazz.getAnnotation(clazz2) != null;
    }

    public abstract void onMethodAnnotation(T var1, Class<?> var2, Method var3, Annotation var4);

    public void scanMethodAnnotations(T t, Class<?> clazz) {
        for (Class<?> clazz2 = clazz; clazz2 != null && Object.class.isAssignableFrom(clazz2); clazz2 = clazz2.getSuperclass()) {
            for (Method method : clazz2.getDeclaredMethods()) {
                Annotation[] annotationArray = method.getAnnotations();
                if (annotationArray == null || annotationArray.length <= 0) continue;
                for (Annotation annotation : annotationArray) {
                    this.onMethodAnnotation(t, clazz2, method, annotation);
                }
            }
        }
    }
}

