/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.events;

import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketConnectionListener;
import org.eclipse.jetty.websocket.api.WebSocketFrameListener;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.eclipse.jetty.websocket.api.WebSocketPartialListener;
import org.eclipse.jetty.websocket.api.WebSocketPingPongListener;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.events.AbstractEventDriver;
import org.eclipse.jetty.websocket.common.frames.ReadOnlyDelegatedFrame;
import org.eclipse.jetty.websocket.common.message.SimpleBinaryMessage;
import org.eclipse.jetty.websocket.common.message.SimpleTextMessage;
import org.eclipse.jetty.websocket.common.util.Utf8PartialBuilder;

public class JettyListenerEventDriver
extends AbstractEventDriver {
    private static final Logger LOG = Log.getLogger(JettyListenerEventDriver.class);
    private final WebSocketConnectionListener listener;
    private Utf8PartialBuilder utf8Partial;
    private boolean hasCloseBeenCalled = false;

    public JettyListenerEventDriver(WebSocketPolicy webSocketPolicy, WebSocketConnectionListener webSocketConnectionListener) {
        super(webSocketPolicy, webSocketConnectionListener);
        this.listener = webSocketConnectionListener;
    }

    @Override
    public void onBinaryFrame(ByteBuffer byteBuffer, boolean bl) {
        if (this.listener instanceof WebSocketListener) {
            if (this.activeMessage == null) {
                this.activeMessage = new SimpleBinaryMessage(this);
            }
            this.appendMessage(byteBuffer, bl);
        }
        if (this.listener instanceof WebSocketPartialListener) {
            ((WebSocketPartialListener)this.listener).onWebSocketPartialBinary(byteBuffer.slice().asReadOnlyBuffer(), bl);
        }
    }

    @Override
    public void onBinaryMessage(byte[] byArray) {
        if (this.listener instanceof WebSocketListener) {
            ((WebSocketListener)this.listener).onWebSocketBinary(byArray, 0, byArray.length);
        }
    }

    @Override
    public void onClose(CloseInfo closeInfo) {
        if (this.hasCloseBeenCalled) {
            return;
        }
        this.hasCloseBeenCalled = true;
        int n = closeInfo.getStatusCode();
        String string = closeInfo.getReason();
        this.listener.onWebSocketClose(n, string);
    }

    @Override
    public void onConnect() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onConnect()", new Object[0]);
        }
        this.listener.onWebSocketConnect((Session)this.session);
    }

    @Override
    public void onError(Throwable throwable) {
        this.listener.onWebSocketError(throwable);
    }

    @Override
    public void onFrame(Frame frame) {
        if (this.listener instanceof WebSocketFrameListener) {
            ((WebSocketFrameListener)this.listener).onWebSocketFrame((Frame)new ReadOnlyDelegatedFrame(frame));
        }
        if (this.listener instanceof WebSocketPingPongListener) {
            if (frame.getType() == Frame.Type.PING) {
                ((WebSocketPingPongListener)this.listener).onWebSocketPing(frame.getPayload().asReadOnlyBuffer());
            } else if (frame.getType() == Frame.Type.PONG) {
                ((WebSocketPingPongListener)this.listener).onWebSocketPong(frame.getPayload().asReadOnlyBuffer());
            }
        }
    }

    @Override
    public void onInputStream(InputStream inputStream) {
    }

    @Override
    public void onReader(Reader reader) {
    }

    @Override
    public void onTextFrame(ByteBuffer byteBuffer, boolean bl) {
        if (this.listener instanceof WebSocketListener) {
            if (this.activeMessage == null) {
                this.activeMessage = new SimpleTextMessage(this);
            }
            this.appendMessage(byteBuffer, bl);
        }
        if (this.listener instanceof WebSocketPartialListener) {
            if (this.utf8Partial == null) {
                this.utf8Partial = new Utf8PartialBuilder();
            }
            String string = this.utf8Partial.toPartialString(byteBuffer);
            ((WebSocketPartialListener)this.listener).onWebSocketPartialText(string, bl);
            if (bl) {
                string = null;
            }
        }
    }

    @Override
    public void onTextMessage(String string) {
        if (this.listener instanceof WebSocketListener) {
            ((WebSocketListener)this.listener).onWebSocketText(string);
        }
    }

    public String toString() {
        return String.format("%s[%s]", JettyListenerEventDriver.class.getSimpleName(), this.listener.getClass().getName());
    }
}

