/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.events;

import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.events.AbstractEventDriver;
import org.eclipse.jetty.websocket.common.events.JettyAnnotatedMetadata;
import org.eclipse.jetty.websocket.common.message.MessageAppender;
import org.eclipse.jetty.websocket.common.message.MessageInputStream;
import org.eclipse.jetty.websocket.common.message.MessageReader;
import org.eclipse.jetty.websocket.common.message.SimpleBinaryMessage;
import org.eclipse.jetty.websocket.common.message.SimpleTextMessage;

public class JettyAnnotatedEventDriver
extends AbstractEventDriver {
    private final JettyAnnotatedMetadata events;
    private boolean hasCloseBeenCalled = false;
    private BatchMode batchMode;

    public JettyAnnotatedEventDriver(WebSocketPolicy webSocketPolicy, Object object, JettyAnnotatedMetadata jettyAnnotatedMetadata) {
        super(webSocketPolicy, object);
        this.events = jettyAnnotatedMetadata;
        WebSocket webSocket = object.getClass().getAnnotation(WebSocket.class);
        if (webSocket.maxTextMessageSize() > 0) {
            this.policy.setMaxTextMessageSize(webSocket.maxTextMessageSize());
        }
        if (webSocket.maxBinaryMessageSize() > 0) {
            this.policy.setMaxBinaryMessageSize(webSocket.maxBinaryMessageSize());
        }
        if (webSocket.inputBufferSize() > 0) {
            this.policy.setInputBufferSize(webSocket.inputBufferSize());
        }
        if (webSocket.maxIdleTime() > 0) {
            this.policy.setIdleTimeout((long)webSocket.maxIdleTime());
        }
        this.batchMode = webSocket.batchMode();
    }

    @Override
    public BatchMode getBatchMode() {
        return this.batchMode;
    }

    @Override
    public void onBinaryFrame(ByteBuffer byteBuffer, boolean bl) {
        if (this.events.onBinary == null) {
            return;
        }
        if (this.activeMessage == null) {
            if (this.events.onBinary.isStreaming()) {
                final MessageAppender messageAppender = this.activeMessage = new MessageInputStream();
                this.dispatch(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ((JettyAnnotatedEventDriver)JettyAnnotatedEventDriver.this).events.onBinary.call(JettyAnnotatedEventDriver.this.websocket, JettyAnnotatedEventDriver.this.session, new Object[]{messageAppender});
                        }
                        catch (Throwable throwable) {
                            JettyAnnotatedEventDriver.this.onError(throwable);
                        }
                    }
                });
            } else {
                this.activeMessage = new SimpleBinaryMessage(this);
            }
        }
        this.appendMessage(byteBuffer, bl);
    }

    @Override
    public void onBinaryMessage(byte[] byArray) {
        if (this.events.onBinary != null) {
            this.events.onBinary.call(this.websocket, this.session, new Object[]{byArray, 0, byArray.length});
        }
    }

    @Override
    public void onClose(CloseInfo closeInfo) {
        if (this.hasCloseBeenCalled) {
            return;
        }
        this.hasCloseBeenCalled = true;
        if (this.events.onClose != null) {
            this.events.onClose.call(this.websocket, this.session, new Object[]{closeInfo.getStatusCode(), closeInfo.getReason()});
        }
    }

    @Override
    public void onConnect() {
        if (this.events.onConnect != null) {
            this.events.onConnect.call(this.websocket, this.session);
        }
    }

    @Override
    public void onError(Throwable throwable) {
        if (this.events.onError != null) {
            this.events.onError.call(this.websocket, this.session, new Object[]{throwable});
        }
    }

    @Override
    public void onFrame(Frame frame) {
        if (this.events.onFrame != null) {
            this.events.onFrame.call(this.websocket, this.session, new Object[]{frame});
        }
    }

    @Override
    public void onInputStream(InputStream inputStream) {
        if (this.events.onBinary != null) {
            this.events.onBinary.call(this.websocket, this.session, new Object[]{inputStream});
        }
    }

    @Override
    public void onReader(Reader reader) {
        if (this.events.onText != null) {
            this.events.onText.call(this.websocket, this.session, new Object[]{reader});
        }
    }

    @Override
    public void onTextFrame(ByteBuffer byteBuffer, boolean bl) {
        if (this.events.onText == null) {
            return;
        }
        if (this.activeMessage == null) {
            if (this.events.onText.isStreaming()) {
                final MessageAppender messageAppender = this.activeMessage = new MessageReader(new MessageInputStream());
                this.dispatch(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ((JettyAnnotatedEventDriver)JettyAnnotatedEventDriver.this).events.onText.call(JettyAnnotatedEventDriver.this.websocket, JettyAnnotatedEventDriver.this.session, new Object[]{messageAppender});
                        }
                        catch (Throwable throwable) {
                            JettyAnnotatedEventDriver.this.onError(throwable);
                        }
                    }
                });
            } else {
                this.activeMessage = new SimpleTextMessage(this);
            }
        }
        this.appendMessage(byteBuffer, bl);
    }

    @Override
    public void onTextMessage(String string) {
        if (this.events.onText != null) {
            this.events.onText.call(this.websocket, this.session, new Object[]{string});
        }
    }

    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.websocket);
    }
}

