/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.events;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.InvalidWebSocketException;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.common.events.EventDriver;
import org.eclipse.jetty.websocket.common.events.EventDriverImpl;
import org.eclipse.jetty.websocket.common.events.JettyAnnotatedImpl;
import org.eclipse.jetty.websocket.common.events.JettyListenerImpl;

public class EventDriverFactory {
    private static final Logger LOG = Log.getLogger(EventDriverFactory.class);
    private final WebSocketPolicy policy;
    private final List<EventDriverImpl> implementations;

    public EventDriverFactory(WebSocketPolicy webSocketPolicy) {
        this.policy = webSocketPolicy;
        this.implementations = new ArrayList<EventDriverImpl>();
        this.addImplementation(new JettyListenerImpl());
        this.addImplementation(new JettyAnnotatedImpl());
    }

    public void addImplementation(EventDriverImpl eventDriverImpl) {
        if (this.implementations.contains(eventDriverImpl)) {
            LOG.warn("Ignoring attempt to add duplicate EventDriverImpl: " + eventDriverImpl, new Object[0]);
            return;
        }
        this.implementations.add(eventDriverImpl);
    }

    public void clearImplementations() {
        this.implementations.clear();
    }

    protected String getClassName(Object object) {
        return object.getClass().getName();
    }

    public List<EventDriverImpl> getImplementations() {
        return this.implementations;
    }

    public boolean removeImplementation(EventDriverImpl eventDriverImpl) {
        return this.implementations.remove(eventDriverImpl);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append("[implementations=[");
        boolean bl = false;
        for (EventDriverImpl eventDriverImpl : this.implementations) {
            if (bl) {
                stringBuilder.append(',');
            }
            stringBuilder.append(eventDriverImpl.toString());
            bl = true;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public EventDriver wrap(Object object) {
        if (object == null) {
            throw new InvalidWebSocketException("null websocket object");
        }
        for (EventDriverImpl eventDriverImpl : this.implementations) {
            if (!eventDriverImpl.supports(object)) continue;
            try {
                return eventDriverImpl.create(object, this.policy.clonePolicy());
            }
            catch (Throwable throwable) {
                throw new InvalidWebSocketException("Unable to create websocket", throwable);
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClassName(object));
        stringBuilder.append(" is not a valid WebSocket object.");
        stringBuilder.append("  Object must obey one of the following rules: ");
        int n = this.implementations.size();
        for (int i = 0; i < n; ++i) {
            EventDriverImpl eventDriverImpl = this.implementations.get(i);
            if (i > 0) {
                stringBuilder.append(" or ");
            }
            stringBuilder.append("\n(").append(i + 1).append(") ");
            stringBuilder.append(eventDriverImpl.describeRule());
        }
        throw new InvalidWebSocketException(stringBuilder.toString());
    }
}

