/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.events;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Utf8Appendable;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.CloseException;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.common.events.EventDriver;
import org.eclipse.jetty.websocket.common.frames.CloseFrame;
import org.eclipse.jetty.websocket.common.message.MessageAppender;

public abstract class AbstractEventDriver
extends AbstractLifeCycle
implements IncomingFrames,
EventDriver {
    private static final Logger LOG = Log.getLogger(AbstractEventDriver.class);
    protected final Logger TARGET_LOG;
    protected WebSocketPolicy policy;
    protected final Object websocket;
    protected WebSocketSession session;
    protected MessageAppender activeMessage;

    public AbstractEventDriver(WebSocketPolicy webSocketPolicy, Object object) {
        this.policy = webSocketPolicy;
        this.websocket = object;
        this.TARGET_LOG = Log.getLogger(object.getClass());
    }

    protected void appendMessage(ByteBuffer byteBuffer, boolean bl) {
        this.activeMessage.appendFrame(byteBuffer, bl);
        if (bl) {
            this.activeMessage.messageComplete();
            this.activeMessage = null;
        }
    }

    protected void dispatch(Runnable runnable) {
        this.session.dispatch(runnable);
    }

    @Override
    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    @Override
    public WebSocketSession getSession() {
        return this.session;
    }

    public final void incomingError(Throwable throwable) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("incomingError(" + throwable.getClass().getName() + ")", throwable);
        }
        this.onError(throwable);
    }

    public void incomingFrame(Frame frame) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("incomingFrame({})", new Object[]{frame});
        }
        try {
            this.onFrame(frame);
            byte by = frame.getOpCode();
            switch (by) {
                case 8: {
                    boolean bl = true;
                    CloseFrame closeFrame = (CloseFrame)frame;
                    CloseInfo closeInfo = new CloseInfo(closeFrame, bl);
                    this.session.getConnection().getIOState().onCloseRemote(closeInfo);
                    return;
                }
                case 9: {
                    ByteBuffer byteBuffer;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("PING: {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)frame.getPayload())});
                    }
                    if (frame.hasPayload()) {
                        byteBuffer = ByteBuffer.allocate(frame.getPayload().remaining());
                        BufferUtil.put((ByteBuffer)frame.getPayload().slice(), (ByteBuffer)byteBuffer);
                        BufferUtil.flipToFlush((ByteBuffer)byteBuffer, (int)0);
                    } else {
                        byteBuffer = ByteBuffer.allocate(0);
                    }
                    this.onPing(frame.getPayload());
                    this.session.getRemote().sendPong(byteBuffer);
                    break;
                }
                case 10: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("PONG: {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)frame.getPayload())});
                    }
                    this.onPong(frame.getPayload());
                    break;
                }
                case 2: {
                    this.onBinaryFrame(frame.getPayload(), frame.isFin());
                    return;
                }
                case 1: {
                    this.onTextFrame(frame.getPayload(), frame.isFin());
                    return;
                }
                case 0: {
                    this.onContinuationFrame(frame.getPayload(), frame.isFin());
                    return;
                }
                default: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Unhandled OpCode: {}", (long)by);
                    }
                    break;
                }
            }
        }
        catch (Utf8Appendable.NotUtf8Exception notUtf8Exception) {
            this.terminateConnection(1007, notUtf8Exception.getMessage());
        }
        catch (CloseException closeException) {
            this.terminateConnection(closeException.getStatusCode(), closeException.getMessage());
        }
        catch (Throwable throwable) {
            this.unhandled(throwable);
        }
    }

    @Override
    public void onContinuationFrame(ByteBuffer byteBuffer, boolean bl) {
        if (this.activeMessage == null) {
            throw new IOException("Out of order Continuation frame encountered");
        }
        this.appendMessage(byteBuffer, bl);
    }

    @Override
    public void onPong(ByteBuffer byteBuffer) {
    }

    @Override
    public void onPing(ByteBuffer byteBuffer) {
    }

    @Override
    public BatchMode getBatchMode() {
        return null;
    }

    @Override
    public void openSession(WebSocketSession webSocketSession) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("openSession({})", new Object[]{webSocketSession});
        }
        this.session = webSocketSession;
        this.session.getContainerScope().getObjectFactory().decorate(this.websocket);
        try {
            this.onConnect();
        }
        catch (Throwable throwable) {
            this.unhandled(throwable);
            throw throwable;
        }
    }

    protected void doStop() {
        this.session = null;
    }

    protected void terminateConnection(int n, String string) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("terminateConnection({},{})", new Object[]{n, string});
        }
        this.session.close(n, CloseFrame.truncate(string));
    }

    private void unhandled(Throwable throwable) {
        this.TARGET_LOG.warn("Unhandled Error (closing connection)", throwable);
        this.onError(throwable);
        if (throwable instanceof CloseException) {
            this.terminateConnection(((CloseException)throwable).getStatusCode(), throwable.getClass().getSimpleName());
            return;
        }
        switch (this.policy.getBehavior()) {
            case SERVER: {
                this.terminateConnection(1011, throwable.getClass().getSimpleName());
                break;
            }
            case CLIENT: {
                this.terminateConnection(1008, throwable.getClass().getSimpleName());
            }
        }
    }
}

