/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common;

import java.net.URI;
import org.eclipse.jetty.websocket.common.LogicalConnection;
import org.eclipse.jetty.websocket.common.SessionFactory;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.common.events.EventDriver;
import org.eclipse.jetty.websocket.common.events.JettyAnnotatedEventDriver;
import org.eclipse.jetty.websocket.common.events.JettyListenerEventDriver;
import org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;

public class WebSocketSessionFactory
implements SessionFactory {
    private final WebSocketContainerScope containerScope;

    public WebSocketSessionFactory(WebSocketContainerScope webSocketContainerScope) {
        this.containerScope = webSocketContainerScope;
    }

    @Override
    public boolean supports(EventDriver eventDriver) {
        return eventDriver instanceof JettyAnnotatedEventDriver || eventDriver instanceof JettyListenerEventDriver;
    }

    @Override
    public WebSocketSession createSession(URI uRI, EventDriver eventDriver, LogicalConnection logicalConnection) {
        return new WebSocketSession(this.containerScope, uRI, eventDriver, logicalConnection);
    }
}

