/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ThreadClassLoaderScope;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.CloseException;
import org.eclipse.jetty.websocket.api.CloseStatus;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.SuspendToken;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.ExtensionFactory;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import org.eclipse.jetty.websocket.api.extensions.OutgoingFrames;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.ConnectionState;
import org.eclipse.jetty.websocket.common.LogicalConnection;
import org.eclipse.jetty.websocket.common.WebSocketRemoteEndpoint;
import org.eclipse.jetty.websocket.common.events.EventDriver;
import org.eclipse.jetty.websocket.common.io.IOState;
import org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;
import org.eclipse.jetty.websocket.common.scopes.WebSocketSessionScope;

@ManagedObject(value="A Jetty WebSocket Session")
public class WebSocketSession
extends ContainerLifeCycle
implements Connection.Listener,
Session,
IncomingFrames,
IOState.ConnectionStateListener,
WebSocketSessionScope {
    private static final Logger LOG = Log.getLogger(WebSocketSession.class);
    private static final Logger LOG_OPEN = Log.getLogger((String)(WebSocketSession.class.getName() + "_OPEN"));
    private final WebSocketContainerScope containerScope;
    private final URI requestURI;
    private final LogicalConnection connection;
    private final EventDriver websocket;
    private final Executor executor;
    private ClassLoader classLoader;
    private ExtensionFactory extensionFactory;
    private String protocolVersion;
    private Map<String, String[]> parameterMap = new HashMap<String, String[]>();
    private WebSocketRemoteEndpoint remote;
    private IncomingFrames incomingHandler;
    private OutgoingFrames outgoingHandler;
    private WebSocketPolicy policy;
    private UpgradeRequest upgradeRequest;
    private UpgradeResponse upgradeResponse;

    public WebSocketSession(WebSocketContainerScope webSocketContainerScope, URI uRI, EventDriver eventDriver, LogicalConnection logicalConnection) {
        Objects.requireNonNull(webSocketContainerScope, "Container Scope cannot be null");
        Objects.requireNonNull(uRI, "Request URI cannot be null");
        this.classLoader = Thread.currentThread().getContextClassLoader();
        this.containerScope = webSocketContainerScope;
        this.requestURI = uRI;
        this.websocket = eventDriver;
        this.connection = logicalConnection;
        this.executor = logicalConnection.getExecutor();
        this.outgoingHandler = logicalConnection;
        this.incomingHandler = eventDriver;
        this.connection.getIOState().addListener(this);
        this.policy = webSocketContainerScope.getPolicy();
        this.addBean(this.connection);
        this.addBean(this.websocket);
    }

    public void close() {
        this.connection.close(1000, null);
    }

    public void close(CloseStatus closeStatus) {
        this.close(closeStatus.getCode(), closeStatus.getPhrase());
    }

    public void close(int n, String string) {
        this.connection.close(n, string);
    }

    public void disconnect() {
        this.connection.disconnect();
        this.notifyClose(1006, "Harsh disconnect");
    }

    public void dispatch(Runnable runnable) {
        this.executor.execute(runnable);
    }

    protected void doStart() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("starting - {}", new Object[]{this});
        }
        super.doStart();
    }

    protected void doStop() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("stopping - {}", new Object[]{this});
        }
        if (this.getConnection() != null) {
            try {
                this.getConnection().close(1001, "Shutdown");
            }
            catch (Throwable throwable) {
                LOG.debug("During Connection Shutdown", throwable);
            }
        }
        super.doStop();
    }

    public void dump(Appendable appendable, String string) {
        this.dumpThis(appendable);
        appendable.append(string).append(" +- incomingHandler : ");
        if (this.incomingHandler instanceof Dumpable) {
            ((Dumpable)this.incomingHandler).dump(appendable, string + "    ");
        } else {
            appendable.append(this.incomingHandler.toString()).append(System.lineSeparator());
        }
        appendable.append(string).append(" +- outgoingHandler : ");
        if (this.outgoingHandler instanceof Dumpable) {
            ((Dumpable)this.outgoingHandler).dump(appendable, string + "    ");
        } else {
            appendable.append(this.outgoingHandler.toString()).append(System.lineSeparator());
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        WebSocketSession webSocketSession = (WebSocketSession)object;
        return !(this.connection == null ? webSocketSession.connection != null : !this.connection.equals(webSocketSession.connection));
    }

    public ByteBufferPool getBufferPool() {
        return this.connection.getBufferPool();
    }

    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    public LogicalConnection getConnection() {
        return this.connection;
    }

    @Override
    public WebSocketContainerScope getContainerScope() {
        return this.containerScope;
    }

    public ExtensionFactory getExtensionFactory() {
        return this.extensionFactory;
    }

    public long getIdleTimeout() {
        return this.connection.getMaxIdleTimeout();
    }

    @ManagedAttribute(readonly=true)
    public IncomingFrames getIncomingHandler() {
        return this.incomingHandler;
    }

    public InetSocketAddress getLocalAddress() {
        return this.connection.getLocalAddress();
    }

    @ManagedAttribute(readonly=true)
    public OutgoingFrames getOutgoingHandler() {
        return this.outgoingHandler;
    }

    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public RemoteEndpoint getRemote() {
        ConnectionState connectionState;
        if (LOG_OPEN.isDebugEnabled()) {
            LOG_OPEN.debug("[{}] {}.getRemote()", new Object[]{this.policy.getBehavior(), this.getClass().getSimpleName()});
        }
        if ((connectionState = this.connection.getIOState().getConnectionState()) == ConnectionState.OPEN || connectionState == ConnectionState.CONNECTED) {
            return this.remote;
        }
        throw new WebSocketException("RemoteEndpoint unavailable, current state [" + (Object)((Object)connectionState) + "], expecting [OPEN or CONNECTED]");
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remote.getInetSocketAddress();
    }

    public URI getRequestURI() {
        return this.requestURI;
    }

    public UpgradeRequest getUpgradeRequest() {
        return this.upgradeRequest;
    }

    public UpgradeResponse getUpgradeResponse() {
        return this.upgradeResponse;
    }

    @Override
    public WebSocketSession getWebSocketSession() {
        return this;
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.connection == null ? 0 : this.connection.hashCode());
        return n2;
    }

    public void incomingError(Throwable throwable) {
        if (this.connection.getIOState().isInputAvailable()) {
            this.websocket.incomingError(throwable);
        }
    }

    public void incomingFrame(Frame frame) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            if (this.connection.getIOState().isInputAvailable()) {
                this.incomingHandler.incomingFrame(frame);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    public boolean isOpen() {
        if (this.connection == null) {
            return false;
        }
        return this.connection.isOpen();
    }

    public boolean isSecure() {
        if (this.upgradeRequest == null) {
            throw new IllegalStateException("No valid UpgradeRequest yet");
        }
        URI uRI = this.upgradeRequest.getRequestURI();
        return "wss".equalsIgnoreCase(uRI.getScheme());
    }

    public void notifyClose(int n, String string) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("notifyClose({},{})", new Object[]{n, string});
        }
        this.websocket.onClose(new CloseInfo(n, string));
    }

    public void notifyError(Throwable throwable) {
        this.incomingError(throwable);
    }

    public void onClosed(Connection connection) {
    }

    public void onOpened(Connection connection) {
        if (LOG_OPEN.isDebugEnabled()) {
            LOG_OPEN.debug("[{}] {}.onOpened()", new Object[]{this.policy.getBehavior(), this.getClass().getSimpleName()});
        }
        this.open();
    }

    @Override
    public void onConnectionStateChange(ConnectionState connectionState) {
        switch (connectionState) {
            case CLOSED: {
                IOState iOState = this.connection.getIOState();
                CloseInfo closeInfo = iOState.getCloseInfo();
                this.notifyClose(closeInfo.getStatusCode(), closeInfo.getReason());
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{}.onSessionClosed()", new Object[]{this.containerScope.getClass().getSimpleName()});
                    }
                    this.containerScope.onSessionClosed(this);
                }
                catch (Throwable throwable) {
                    LOG.ignore(throwable);
                }
                break;
            }
            case CONNECTED: {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{}.onSessionOpened()", new Object[]{this.containerScope.getClass().getSimpleName()});
                    }
                    this.containerScope.onSessionOpened(this);
                    break;
                }
                catch (Throwable throwable) {
                    LOG.ignore(throwable);
                }
            }
        }
    }

    public void open() {
        if (LOG_OPEN.isDebugEnabled()) {
            LOG_OPEN.debug("[{}] {}.open()", new Object[]{this.policy.getBehavior(), this.getClass().getSimpleName()});
        }
        if (this.remote != null) {
            return;
        }
        try (ThreadClassLoaderScope threadClassLoaderScope = new ThreadClassLoaderScope(this.classLoader);){
            this.connection.getIOState().onConnected();
            this.remote = new WebSocketRemoteEndpoint(this.connection, this.outgoingHandler, this.getBatchMode());
            if (LOG_OPEN.isDebugEnabled()) {
                LOG_OPEN.debug("[{}] {}.open() remote={}", new Object[]{this.policy.getBehavior(), this.getClass().getSimpleName(), this.remote});
            }
            this.websocket.openSession(this);
            this.connection.getIOState().onOpened();
            if (LOG.isDebugEnabled()) {
                LOG.debug("open -> {}", new Object[]{this.dump()});
            }
        }
        catch (CloseException closeException) {
            LOG.warn((Throwable)closeException);
            this.close(closeException.getStatusCode(), closeException.getMessage());
        }
        catch (Throwable throwable) {
            LOG.warn(throwable);
            int n = 1011;
            if (this.policy.getBehavior() == WebSocketBehavior.CLIENT) {
                n = 1008;
            }
            this.close(n, throwable.getMessage());
        }
    }

    public void setExtensionFactory(ExtensionFactory extensionFactory) {
        this.extensionFactory = extensionFactory;
    }

    public void setIdleTimeout(long l) {
        this.connection.setMaxIdleTimeout(l);
    }

    public void setOutgoingHandler(OutgoingFrames outgoingFrames) {
        this.outgoingHandler = outgoingFrames;
    }

    public void setPolicy(WebSocketPolicy webSocketPolicy) {
        this.policy = webSocketPolicy;
    }

    public void setUpgradeRequest(UpgradeRequest upgradeRequest) {
        this.upgradeRequest = upgradeRequest;
        this.protocolVersion = upgradeRequest.getProtocolVersion();
        this.parameterMap.clear();
        if (upgradeRequest.getParameterMap() != null) {
            for (Map.Entry entry : upgradeRequest.getParameterMap().entrySet()) {
                List list = (List)entry.getValue();
                if (list != null) {
                    this.parameterMap.put((String)entry.getKey(), list.toArray(new String[list.size()]));
                    continue;
                }
                this.parameterMap.put((String)entry.getKey(), new String[0]);
            }
        }
    }

    public void setUpgradeResponse(UpgradeResponse upgradeResponse) {
        this.upgradeResponse = upgradeResponse;
    }

    public SuspendToken suspend() {
        return this.connection.suspend();
    }

    public BatchMode getBatchMode() {
        return BatchMode.AUTO;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("WebSocketSession[");
        stringBuilder.append("websocket=").append(this.websocket);
        stringBuilder.append(",behavior=").append(this.policy.getBehavior());
        stringBuilder.append(",connection=").append(this.connection);
        stringBuilder.append(",remote=").append(this.remote);
        stringBuilder.append(",incoming=").append(this.incomingHandler);
        stringBuilder.append(",outgoing=").append(this.outgoingHandler);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

