/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common;

public final class OpCode {
    public static final byte CONTINUATION = 0;
    public static final byte TEXT = 1;
    public static final byte BINARY = 2;
    public static final byte CLOSE = 8;
    public static final byte PING = 9;
    public static final byte PONG = 10;
    public static final byte UNDEFINED = -1;

    public static boolean isControlFrame(byte by) {
        return by >= 8;
    }

    public static boolean isDataFrame(byte by) {
        return by == 1 || by == 2;
    }

    public static boolean isKnown(byte by) {
        return by == 0 || by == 1 || by == 2 || by == 8 || by == 9 || by == 10;
    }

    public static String name(byte by) {
        switch (by) {
            case -1: {
                return "NO-OP";
            }
            case 0: {
                return "CONTINUATION";
            }
            case 1: {
                return "TEXT";
            }
            case 2: {
                return "BINARY";
            }
            case 8: {
                return "CLOSE";
            }
            case 9: {
                return "PING";
            }
            case 10: {
                return "PONG";
            }
        }
        return "NON-SPEC[" + by + "]";
    }
}

