/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common;

import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.SharedBlockingCallback;
import org.eclipse.jetty.websocket.api.WriteCallback;

public class BlockingWriteCallback
extends SharedBlockingCallback {
    public WriteBlocker acquireWriteBlocker() {
        return new WriteBlocker(this.acquire());
    }

    public static class WriteBlocker
    implements AutoCloseable,
    Callback.NonBlocking,
    WriteCallback {
        private final SharedBlockingCallback.Blocker blocker;

        protected WriteBlocker(SharedBlockingCallback.Blocker blocker) {
            this.blocker = blocker;
        }

        public void writeFailed(Throwable throwable) {
            this.blocker.failed(throwable);
        }

        public void writeSuccess() {
            this.blocker.succeeded();
        }

        public void succeeded() {
            this.blocker.succeeded();
        }

        public void failed(Throwable throwable) {
            this.blocker.failed(throwable);
        }

        @Override
        public void close() {
            this.blocker.close();
        }

        public void block() {
            this.blocker.block();
        }
    }
}

