/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.parameters;

import iaik.pkcs.pkcs11.TokenRuntimeException;
import iaik.pkcs.pkcs11.parameters.Parameters;
import iaik.pkcs.pkcs11.parameters.SSL3KeyMaterialOutParameters;
import iaik.pkcs.pkcs11.parameters.SSL3RandomDataParameters;
import iaik.pkcs.pkcs11.wrapper.CK_SSL3_KEY_MAT_OUT;
import iaik.pkcs.pkcs11.wrapper.CK_SSL3_KEY_MAT_PARAMS;
import iaik.pkcs.pkcs11.wrapper.CK_SSL3_RANDOM_DATA;
import iaik.pkcs.pkcs11.wrapper.Constants;

public class SSL3KeyMaterialParameters
implements Parameters {
    protected long macSizeInBits_;
    protected long keySizeInBits_;
    protected long initializationVectorSizeInBits_;
    protected boolean export_;
    protected SSL3RandomDataParameters randomInfo_;
    protected SSL3KeyMaterialOutParameters returnedKeyMaterial_;

    public SSL3KeyMaterialParameters(long l, long l2, long l3, boolean bl, SSL3RandomDataParameters sSL3RandomDataParameters, SSL3KeyMaterialOutParameters sSL3KeyMaterialOutParameters) {
        if (sSL3RandomDataParameters == null) {
            throw new NullPointerException("Argument \"randomInfo\" must not be null.");
        }
        if (sSL3KeyMaterialOutParameters == null) {
            throw new NullPointerException("Argument \"returnedKeyMaterial\" must not be null.");
        }
        this.macSizeInBits_ = l;
        this.keySizeInBits_ = l2;
        this.initializationVectorSizeInBits_ = l3;
        this.export_ = bl;
        this.randomInfo_ = sSL3RandomDataParameters;
        this.returnedKeyMaterial_ = sSL3KeyMaterialOutParameters;
    }

    public Object clone() {
        SSL3KeyMaterialParameters sSL3KeyMaterialParameters;
        try {
            sSL3KeyMaterialParameters = (SSL3KeyMaterialParameters)super.clone();
            sSL3KeyMaterialParameters.randomInfo_ = (SSL3RandomDataParameters)this.randomInfo_.clone();
            sSL3KeyMaterialParameters.returnedKeyMaterial_ = (SSL3KeyMaterialOutParameters)this.returnedKeyMaterial_.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new TokenRuntimeException("An unexpected clone exception occurred.", cloneNotSupportedException);
        }
        return sSL3KeyMaterialParameters;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof SSL3KeyMaterialParameters) {
            SSL3KeyMaterialParameters sSL3KeyMaterialParameters = (SSL3KeyMaterialParameters)object;
            bl = this == sSL3KeyMaterialParameters || this.macSizeInBits_ == sSL3KeyMaterialParameters.macSizeInBits_ && this.keySizeInBits_ == sSL3KeyMaterialParameters.keySizeInBits_ && this.initializationVectorSizeInBits_ == sSL3KeyMaterialParameters.initializationVectorSizeInBits_ && this.export_ == sSL3KeyMaterialParameters.export_ && this.randomInfo_.equals(sSL3KeyMaterialParameters.randomInfo_) && this.returnedKeyMaterial_.equals(sSL3KeyMaterialParameters.returnedKeyMaterial_);
        }
        return bl;
    }

    public long getInitializationVectorSizeInBits() {
        return this.initializationVectorSizeInBits_;
    }

    public long getKeySizeInBits() {
        return this.keySizeInBits_;
    }

    public long getMacSizeInBits() {
        return this.macSizeInBits_;
    }

    public Object getPKCS11ParamsObject() {
        CK_SSL3_KEY_MAT_PARAMS cK_SSL3_KEY_MAT_PARAMS = new CK_SSL3_KEY_MAT_PARAMS();
        cK_SSL3_KEY_MAT_PARAMS.ulMacSizeInBits = this.macSizeInBits_;
        cK_SSL3_KEY_MAT_PARAMS.ulKeySizeInBits = this.keySizeInBits_;
        cK_SSL3_KEY_MAT_PARAMS.ulIVSizeInBits = this.initializationVectorSizeInBits_;
        cK_SSL3_KEY_MAT_PARAMS.bIsExport = this.export_;
        cK_SSL3_KEY_MAT_PARAMS.RandomInfo = (CK_SSL3_RANDOM_DATA)this.randomInfo_.getPKCS11ParamsObject();
        cK_SSL3_KEY_MAT_PARAMS.pReturnedKeyMaterial = (CK_SSL3_KEY_MAT_OUT)this.returnedKeyMaterial_.getPKCS11ParamsObject();
        return cK_SSL3_KEY_MAT_PARAMS;
    }

    public SSL3RandomDataParameters getRandomInfo() {
        return this.randomInfo_;
    }

    public SSL3KeyMaterialOutParameters getReturnedKeyMaterial() {
        return this.returnedKeyMaterial_;
    }

    public int hashCode() {
        return (int)this.macSizeInBits_ ^ (int)this.keySizeInBits_ ^ (int)this.initializationVectorSizeInBits_ ^ this.randomInfo_.hashCode() ^ this.returnedKeyMaterial_.hashCode();
    }

    public boolean isExport() {
        return this.export_;
    }

    public void isExport(boolean bl) {
        this.export_ = bl;
    }

    public void setInitializationVectorSizeInBits(long l) {
        this.initializationVectorSizeInBits_ = l;
    }

    public void setKeySizeInBits(long l) {
        this.keySizeInBits_ = l;
    }

    public void setMacSizeInBits(long l) {
        this.macSizeInBits_ = l;
    }

    public void setRandomInfo(SSL3RandomDataParameters sSL3RandomDataParameters) {
        if (sSL3RandomDataParameters == null) {
            throw new NullPointerException("Argument \"randomInfo\" must not be null.");
        }
        this.randomInfo_ = sSL3RandomDataParameters;
    }

    public void setReturnedKeyMaterial(SSL3KeyMaterialOutParameters sSL3KeyMaterialOutParameters) {
        if (sSL3KeyMaterialOutParameters == null) {
            throw new NullPointerException("Argument \"returnedKeyMaterial\" must not be null.");
        }
        this.returnedKeyMaterial_ = sSL3KeyMaterialOutParameters;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("  ");
        stringBuffer.append("MAC Size in Bits (dec): ");
        stringBuffer.append(this.macSizeInBits_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Key Size in Bits (dec): ");
        stringBuffer.append(this.keySizeInBits_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Initialization Vector Size in Bits (dec): ");
        stringBuffer.append(this.initializationVectorSizeInBits_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("For Export Version: ");
        stringBuffer.append(this.export_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Client's and Server'S Random Information (hex): ");
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append(this.randomInfo_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Handles of the generated Keys and IVs: ");
        stringBuffer.append(this.returnedKeyMaterial_);
        return stringBuffer.toString();
    }
}

