/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.parameters;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenRuntimeException;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.parameters.Parameters;
import iaik.pkcs.pkcs11.wrapper.CK_SSL3_KEY_MAT_OUT;
import iaik.pkcs.pkcs11.wrapper.Constants;
import iaik.pkcs.pkcs11.wrapper.Functions;

public class SSL3KeyMaterialOutParameters
implements Parameters {
    protected SecretKey clientMacSecret_;
    protected SecretKey serverMacSecret_;
    protected SecretKey clientKey_;
    protected SecretKey serverKey_;
    protected byte[] clientIV_;
    protected byte[] serverIV_;

    public SSL3KeyMaterialOutParameters(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            throw new NullPointerException("Argument \"clientIV\" must not be null.");
        }
        if (byArray2 == null) {
            throw new NullPointerException("Argument \"serverIV\" must not be null.");
        }
        this.clientIV_ = byArray;
        this.serverIV_ = byArray2;
    }

    public Object clone() {
        SSL3KeyMaterialOutParameters sSL3KeyMaterialOutParameters;
        try {
            sSL3KeyMaterialOutParameters = (SSL3KeyMaterialOutParameters)super.clone();
            sSL3KeyMaterialOutParameters.clientMacSecret_ = (SecretKey)this.clientMacSecret_.clone();
            sSL3KeyMaterialOutParameters.serverMacSecret_ = (SecretKey)this.serverMacSecret_.clone();
            sSL3KeyMaterialOutParameters.clientKey_ = (SecretKey)this.clientKey_.clone();
            sSL3KeyMaterialOutParameters.serverKey_ = (SecretKey)this.serverKey_.clone();
            sSL3KeyMaterialOutParameters.clientIV_ = (byte[])this.clientIV_.clone();
            sSL3KeyMaterialOutParameters.serverIV_ = (byte[])this.serverIV_.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new TokenRuntimeException("An unexpected clone exception occurred.", cloneNotSupportedException);
        }
        return sSL3KeyMaterialOutParameters;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof SSL3KeyMaterialOutParameters) {
            SSL3KeyMaterialOutParameters sSL3KeyMaterialOutParameters = (SSL3KeyMaterialOutParameters)object;
            bl = this == sSL3KeyMaterialOutParameters || (this.clientMacSecret_ == null && sSL3KeyMaterialOutParameters.clientMacSecret_ == null || this.clientMacSecret_ != null && this.clientMacSecret_.equals(sSL3KeyMaterialOutParameters.clientMacSecret_)) && (this.serverMacSecret_ == null && sSL3KeyMaterialOutParameters.serverMacSecret_ == null || this.serverMacSecret_ != null && this.serverMacSecret_.equals(sSL3KeyMaterialOutParameters.serverMacSecret_)) && (this.clientKey_ == null && sSL3KeyMaterialOutParameters.clientKey_ == null || this.clientKey_ != null && this.clientKey_.equals(sSL3KeyMaterialOutParameters.clientKey_)) && (this.serverKey_ == null && sSL3KeyMaterialOutParameters.serverKey_ == null || this.serverKey_ != null && this.serverKey_.equals(sSL3KeyMaterialOutParameters.serverKey_)) && Functions.equals(this.clientIV_, sSL3KeyMaterialOutParameters.clientIV_) && Functions.equals(this.serverIV_, sSL3KeyMaterialOutParameters.serverIV_);
        }
        return bl;
    }

    public byte[] getClientIV() {
        return this.clientIV_;
    }

    public SecretKey getClientMacSecret() {
        return this.clientMacSecret_;
    }

    public SecretKey getClientSecret() {
        return this.clientKey_;
    }

    public Object getPKCS11ParamsObject() {
        CK_SSL3_KEY_MAT_OUT cK_SSL3_KEY_MAT_OUT = new CK_SSL3_KEY_MAT_OUT();
        cK_SSL3_KEY_MAT_OUT.hClientMacSecret = this.clientMacSecret_ != null ? this.clientMacSecret_.getObjectHandle() : 0L;
        cK_SSL3_KEY_MAT_OUT.hServerMacSecret = this.serverMacSecret_ != null ? this.serverMacSecret_.getObjectHandle() : 0L;
        cK_SSL3_KEY_MAT_OUT.hClientKey = this.clientKey_ != null ? this.clientKey_.getObjectHandle() : 0L;
        cK_SSL3_KEY_MAT_OUT.hServerKey = this.serverKey_ != null ? this.serverKey_.getObjectHandle() : 0L;
        cK_SSL3_KEY_MAT_OUT.pIVClient = this.clientIV_;
        cK_SSL3_KEY_MAT_OUT.pIVServer = this.serverIV_;
        return cK_SSL3_KEY_MAT_OUT;
    }

    public byte[] getServerIV() {
        return this.serverIV_;
    }

    public SecretKey getServerMacSecret() {
        return this.serverMacSecret_;
    }

    public SecretKey getServerSecret() {
        return this.serverKey_;
    }

    public int hashCode() {
        return (this.clientMacSecret_ != null ? this.clientMacSecret_.hashCode() : 0) ^ (this.serverMacSecret_ != null ? this.serverMacSecret_.hashCode() : 0) ^ (this.clientKey_ != null ? this.clientKey_.hashCode() : 0) ^ (this.serverKey_ != null ? this.serverKey_.hashCode() : 0);
    }

    public void setPKCS11ParamsObject(CK_SSL3_KEY_MAT_OUT cK_SSL3_KEY_MAT_OUT, Session session) {
        this.clientMacSecret_ = (SecretKey)iaik.pkcs.pkcs11.objects.Object.getInstance(session, cK_SSL3_KEY_MAT_OUT.hClientMacSecret);
        this.serverMacSecret_ = (SecretKey)iaik.pkcs.pkcs11.objects.Object.getInstance(session, cK_SSL3_KEY_MAT_OUT.hServerMacSecret);
        this.clientKey_ = (SecretKey)iaik.pkcs.pkcs11.objects.Object.getInstance(session, cK_SSL3_KEY_MAT_OUT.hClientKey);
        this.serverKey_ = (SecretKey)iaik.pkcs.pkcs11.objects.Object.getInstance(session, cK_SSL3_KEY_MAT_OUT.hServerKey);
        this.clientIV_ = cK_SSL3_KEY_MAT_OUT.pIVClient;
        this.serverIV_ = cK_SSL3_KEY_MAT_OUT.pIVServer;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("  ");
        stringBuffer.append("Client MAC Secret key: ");
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append(this.clientMacSecret_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Server MAC Secret key: ");
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append(this.serverMacSecret_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Client Secret key: ");
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append(this.clientKey_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Server Secret key: ");
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append(this.serverKey_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Client Initializatin Vector (hex): ");
        stringBuffer.append(Functions.toHexString(this.clientIV_));
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Server Initializatin Vector (hex): ");
        stringBuffer.append(Functions.toHexString(this.serverIV_));
        return stringBuffer.toString();
    }
}

