/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.parameters;

import iaik.pkcs.pkcs11.TokenRuntimeException;
import iaik.pkcs.pkcs11.parameters.Parameters;
import iaik.pkcs.pkcs11.wrapper.CK_KEA_DERIVE_PARAMS;
import iaik.pkcs.pkcs11.wrapper.Constants;
import iaik.pkcs.pkcs11.wrapper.Functions;

public class KEADeriveParameters
implements Parameters {
    protected boolean isSender_;
    protected byte[] randomA_;
    protected byte[] randomB_;
    protected byte[] publicData_;

    public KEADeriveParameters(boolean bl, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        if (byArray == null) {
            throw new NullPointerException("Argument \"randomA\" must not be null.");
        }
        if (byArray2 == null) {
            throw new NullPointerException("Argument \"randomB\" must not be null.");
        }
        if (byArray3 == null) {
            throw new NullPointerException("Argument \"publicData\" must not be null.");
        }
        this.isSender_ = bl;
        this.randomA_ = byArray;
        this.randomB_ = byArray2;
        this.publicData_ = byArray3;
    }

    public Object clone() {
        KEADeriveParameters kEADeriveParameters;
        try {
            kEADeriveParameters = (KEADeriveParameters)super.clone();
            kEADeriveParameters.randomA_ = (byte[])this.randomA_.clone();
            kEADeriveParameters.randomB_ = (byte[])this.randomB_.clone();
            kEADeriveParameters.publicData_ = (byte[])this.publicData_.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new TokenRuntimeException("An unexpected clone exception occurred.", cloneNotSupportedException);
        }
        return kEADeriveParameters;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof KEADeriveParameters) {
            KEADeriveParameters kEADeriveParameters = (KEADeriveParameters)object;
            bl = this == kEADeriveParameters || this.isSender_ == kEADeriveParameters.isSender_ && Functions.equals(this.randomA_, kEADeriveParameters.randomA_) && Functions.equals(this.randomB_, kEADeriveParameters.randomB_) && Functions.equals(this.publicData_, kEADeriveParameters.publicData_);
        }
        return bl;
    }

    public Object getPKCS11ParamsObject() {
        CK_KEA_DERIVE_PARAMS cK_KEA_DERIVE_PARAMS = new CK_KEA_DERIVE_PARAMS();
        cK_KEA_DERIVE_PARAMS.isSender = this.isSender_;
        cK_KEA_DERIVE_PARAMS.pRandomA = this.randomA_;
        cK_KEA_DERIVE_PARAMS.pRandomB = this.randomB_;
        cK_KEA_DERIVE_PARAMS.pPublicData = this.publicData_;
        return cK_KEA_DERIVE_PARAMS;
    }

    public byte[] getPublicData() {
        return this.publicData_;
    }

    public byte[] getRandomA() {
        return this.randomA_;
    }

    public byte[] getRandomB() {
        return this.randomB_;
    }

    public int hashCode() {
        return Functions.hashCode(this.randomA_) ^ Functions.hashCode(this.randomB_) ^ Functions.hashCode(this.publicData_);
    }

    public boolean isSender() {
        return this.isSender_;
    }

    public void setPublicData(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("Argument \"publicData\" must not be null.");
        }
        this.publicData_ = byArray;
    }

    public void setRandomA(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("Argument \"randomA\" must not be null.");
        }
        this.randomA_ = byArray;
    }

    public void setRandomB(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("Argument \"randomB\" must not be null.");
        }
        this.randomB_ = byArray;
    }

    public void setSender(boolean bl) {
        this.isSender_ = bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("  ");
        stringBuffer.append("Is Sender: ");
        stringBuffer.append(this.isSender_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Random Data A (hex): ");
        stringBuffer.append(Functions.toHexString(this.randomA_));
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Random Data B (hex): ");
        stringBuffer.append(Functions.toHexString(this.randomB_));
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Public Data (hex): ");
        stringBuffer.append(Functions.toHexString(this.publicData_));
        return stringBuffer.toString();
    }
}

