/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.BooleanAttribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.HardwareFeature;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.wrapper.Constants;

public class MonotonicCounter
extends HardwareFeature {
    protected BooleanAttribute resetOnInit_;
    protected BooleanAttribute hasReset_;
    protected ByteArrayAttribute value_;

    public MonotonicCounter() {
        this.hardwareFeatureType_.setLongValue(HardwareFeature.FeatureType.MONOTONIC_COUNTER);
    }

    protected MonotonicCounter(Session session, long l) {
        super(session, l);
        this.hardwareFeatureType_.setLongValue(HardwareFeature.FeatureType.MONOTONIC_COUNTER);
    }

    protected void allocateAttributes() {
        super.allocateAttributes();
        this.resetOnInit_ = new BooleanAttribute(Attribute.RESET_ON_INIT);
        this.hasReset_ = new BooleanAttribute(Attribute.HAS_RESET);
        this.value_ = new ByteArrayAttribute(Attribute.VALUE);
        MonotonicCounter.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        MonotonicCounter monotonicCounter = (MonotonicCounter)super.clone();
        monotonicCounter.resetOnInit_ = (BooleanAttribute)this.resetOnInit_.clone();
        monotonicCounter.hasReset_ = (BooleanAttribute)this.hasReset_.clone();
        monotonicCounter.value_ = (ByteArrayAttribute)this.value_.clone();
        MonotonicCounter.putAttributesInTable(monotonicCounter);
        return monotonicCounter;
    }

    public boolean equals(java.lang.Object object) {
        boolean bl = false;
        if (object instanceof MonotonicCounter) {
            MonotonicCounter monotonicCounter = (MonotonicCounter)object;
            bl = this == monotonicCounter || super.equals(monotonicCounter) && this.resetOnInit_.equals(monotonicCounter.resetOnInit_) && this.hasReset_.equals(monotonicCounter.hasReset_) && this.value_.equals(monotonicCounter.value_);
        }
        return bl;
    }

    public BooleanAttribute getHasReset() {
        return this.hasReset_;
    }

    public static Object getInstance(Session session, long l) {
        return new MonotonicCounter(session, l);
    }

    public ByteArrayAttribute getValue() {
        return this.value_;
    }

    public int hashCode() {
        return this.resetOnInit_.hashCode() ^ this.hasReset_.hashCode() ^ this.value_.hashCode();
    }

    public BooleanAttribute isResetOnInit() {
        return this.resetOnInit_;
    }

    protected static void putAttributesInTable(MonotonicCounter monotonicCounter) {
        if (monotonicCounter == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        monotonicCounter.attributeTable_.put(Attribute.RESET_ON_INIT, monotonicCounter.resetOnInit_);
        monotonicCounter.attributeTable_.put(Attribute.HAS_RESET, monotonicCounter.hasReset_);
        monotonicCounter.attributeTable_.put(Attribute.VALUE, monotonicCounter.value_);
    }

    public void readAttributes(Session session) {
        super.readAttributes(session);
        Object.getAttributeValues(session, this.objectHandle_, new Attribute[]{this.resetOnInit_, this.hasReset_, this.value_});
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(super.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Reset on Initialization: ");
        stringBuffer.append(this.resetOnInit_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Has been reset: ");
        stringBuffer.append(this.hasReset_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Value (hex): ");
        stringBuffer.append(this.value_.toString());
        return stringBuffer.toString();
    }
}

