/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.BooleanAttribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.DateAttribute;
import iaik.pkcs.pkcs11.objects.KeyTypeAttribute;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.objects.MechanismArrayAttribute;
import iaik.pkcs.pkcs11.objects.MechanismAttribute;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.objects.Storage;
import iaik.pkcs.pkcs11.wrapper.Constants;
import java.util.Hashtable;

public class Key
extends Storage {
    protected static VendorDefinedKeyBuilder vendorKeyBuilder_;
    protected static Hashtable keyTypeNames_;
    protected KeyTypeAttribute keyType_;
    protected ByteArrayAttribute id_;
    protected DateAttribute startDate_;
    protected DateAttribute endDate_;
    protected BooleanAttribute derive_;
    protected BooleanAttribute local_;
    protected MechanismAttribute keyGenMechanism_;
    protected MechanismArrayAttribute allowedMechanisms_;

    public Key() {
    }

    protected Key(Session session, long l) {
        super(session, l);
    }

    protected void allocateAttributes() {
        super.allocateAttributes();
        this.keyType_ = new KeyTypeAttribute();
        this.id_ = new ByteArrayAttribute(Attribute.ID);
        this.startDate_ = new DateAttribute(Attribute.START_DATE);
        this.endDate_ = new DateAttribute(Attribute.END_DATE);
        this.derive_ = new BooleanAttribute(Attribute.DERIVE);
        this.local_ = new BooleanAttribute(Attribute.LOCAL);
        this.keyGenMechanism_ = new MechanismAttribute(Attribute.KEY_GEN_MECHANISM);
        this.allowedMechanisms_ = new MechanismArrayAttribute(Attribute.ALLOWED_MECHANISMS);
        Key.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        Key key = (Key)super.clone();
        key.keyType_ = (KeyTypeAttribute)this.keyType_.clone();
        key.id_ = (ByteArrayAttribute)this.id_.clone();
        key.startDate_ = (DateAttribute)this.startDate_.clone();
        key.endDate_ = (DateAttribute)this.endDate_.clone();
        key.derive_ = (BooleanAttribute)this.derive_.clone();
        key.local_ = (BooleanAttribute)this.local_.clone();
        key.keyGenMechanism_ = (MechanismAttribute)this.keyGenMechanism_.clone();
        key.allowedMechanisms_ = (MechanismArrayAttribute)this.allowedMechanisms_.clone();
        Key.putAttributesInTable(key);
        return key;
    }

    public boolean equals(java.lang.Object object) {
        boolean bl = false;
        if (object instanceof Key) {
            Key key = (Key)object;
            bl = this == key || super.equals(key) && this.keyType_.equals(key.keyType_) && this.id_.equals(key.id_) && this.startDate_.equals(key.startDate_) && this.endDate_.equals(key.endDate_) && this.derive_.equals(key.derive_) && this.local_.equals(key.local_) && this.keyGenMechanism_.equals(key.keyGenMechanism_) && this.allowedMechanisms_.equals(key.allowedMechanisms_);
        }
        return bl;
    }

    public MechanismArrayAttribute getAllowedMechanisms() {
        return this.allowedMechanisms_;
    }

    public BooleanAttribute getDerive() {
        return this.derive_;
    }

    public DateAttribute getEndDate() {
        return this.endDate_;
    }

    public ByteArrayAttribute getId() {
        return this.id_;
    }

    public MechanismAttribute getKeyGenMechanism() {
        return this.keyGenMechanism_;
    }

    public LongAttribute getKeyType() {
        return this.keyType_;
    }

    public static String getKeyTypeName(Long l) {
        String string;
        if (l == null) {
            throw new NullPointerException("Argument \"keyType\" must not be null.");
        }
        if ((l & 0x80000000L) != 0L) {
            string = "Vendor Defined";
        } else {
            if (keyTypeNames_ == null) {
                Hashtable<Long, String> hashtable = new Hashtable<Long, String>(24);
                hashtable.put(KeyType.RSA, "RSA");
                hashtable.put(KeyType.DSA, "DSA");
                hashtable.put(KeyType.DH, "DH");
                hashtable.put(KeyType.ECDSA, "ECDSA");
                hashtable.put(KeyType.EC, "EC");
                hashtable.put(KeyType.X9_42_DH, "X9_42_DH");
                hashtable.put(KeyType.KEA, "KEA");
                hashtable.put(KeyType.GENERIC_SECRET, "GENERIC_SECRET");
                hashtable.put(KeyType.RC2, "RC2");
                hashtable.put(KeyType.RC4, "RC4");
                hashtable.put(KeyType.DES, "DES");
                hashtable.put(KeyType.DES2, "DES2");
                hashtable.put(KeyType.DES3, "DES3");
                hashtable.put(KeyType.CAST, "CAST");
                hashtable.put(KeyType.CAST3, "CAST3");
                hashtable.put(KeyType.CAST5, "CAST5");
                hashtable.put(KeyType.CAST128, "CAST128");
                hashtable.put(KeyType.RC5, "RC5");
                hashtable.put(KeyType.IDEA, "IDEA");
                hashtable.put(KeyType.SKIPJACK, "SKIPJACK");
                hashtable.put(KeyType.BATON, "BATON");
                hashtable.put(KeyType.JUNIPER, "JUNIPER");
                hashtable.put(KeyType.CDMF, "CDMF");
                hashtable.put(KeyType.AES, "AES");
                hashtable.put(KeyType.BLOWFISH, "BLOWFISH");
                hashtable.put(KeyType.TWOFISH, "TWOFISH");
                keyTypeNames_ = hashtable;
            }
            if ((string = (String)keyTypeNames_.get(l)) == null) {
                string = "<unknown>";
            }
        }
        return string;
    }

    public BooleanAttribute getLocal() {
        return this.local_;
    }

    public DateAttribute getStartDate() {
        return this.startDate_;
    }

    public static VendorDefinedKeyBuilder getVendorDefinedKeyBuilder() {
        return vendorKeyBuilder_;
    }

    public int hashCode() {
        return this.keyType_.hashCode() ^ this.id_.hashCode();
    }

    protected static void putAttributesInTable(Key key) {
        if (key == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        key.attributeTable_.put(Attribute.KEY_TYPE, key.keyType_);
        key.attributeTable_.put(Attribute.ID, key.id_);
        key.attributeTable_.put(Attribute.START_DATE, key.startDate_);
        key.attributeTable_.put(Attribute.END_DATE, key.endDate_);
        key.attributeTable_.put(Attribute.DERIVE, key.derive_);
        key.attributeTable_.put(Attribute.LOCAL, key.local_);
        key.attributeTable_.put(Attribute.KEY_GEN_MECHANISM, key.keyGenMechanism_);
        key.attributeTable_.put(Attribute.ALLOWED_MECHANISMS, key.allowedMechanisms_);
    }

    public void readAttributes(Session session) {
        super.readAttributes(session);
        Object.getAttributeValues(session, this.objectHandle_, new Attribute[]{this.id_, this.startDate_, this.endDate_, this.derive_, this.local_, this.keyGenMechanism_});
        Object.getAttributeValue(session, this.objectHandle_, this.allowedMechanisms_);
    }

    public static void setVendorDefinedKeyBuilder(VendorDefinedKeyBuilder vendorDefinedKeyBuilder) {
        vendorKeyBuilder_ = vendorDefinedKeyBuilder;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(super.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Key Type: ");
        if (this.keyType_ != null) {
            stringBuffer.append(this.keyType_.toString());
        } else {
            stringBuffer.append("<unavailable>");
        }
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("ID: ");
        stringBuffer.append(this.id_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Start Date: ");
        stringBuffer.append(this.startDate_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("End Date: ");
        stringBuffer.append(this.endDate_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Derive: ");
        stringBuffer.append(this.derive_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Local: ");
        stringBuffer.append(this.local_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Key Generation Mechanism: ");
        stringBuffer.append(this.keyGenMechanism_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Allowed Mechanisms: ");
        stringBuffer.append(this.allowedMechanisms_.toString());
        return stringBuffer.toString();
    }

    public static interface KeyType {
        public static final Long RSA = new Long(0L);
        public static final Long DSA = new Long(1L);
        public static final Long DH = new Long(2L);
        public static final Long ECDSA = new Long(3L);
        public static final Long EC = new Long(3L);
        public static final Long X9_42_DH = new Long(4L);
        public static final Long KEA = new Long(5L);
        public static final Long GENERIC_SECRET = new Long(16L);
        public static final Long RC2 = new Long(17L);
        public static final Long RC4 = new Long(18L);
        public static final Long DES = new Long(19L);
        public static final Long DES2 = new Long(20L);
        public static final Long DES3 = new Long(21L);
        public static final Long CAST = new Long(22L);
        public static final Long CAST3 = new Long(23L);
        public static final Long CAST5 = new Long(24L);
        public static final Long CAST128 = new Long(24L);
        public static final Long RC5 = new Long(25L);
        public static final Long IDEA = new Long(26L);
        public static final Long SKIPJACK = new Long(27L);
        public static final Long BATON = new Long(28L);
        public static final Long JUNIPER = new Long(29L);
        public static final Long CDMF = new Long(30L);
        public static final Long AES = new Long(31L);
        public static final Long BLOWFISH = new Long(32L);
        public static final Long TWOFISH = new Long(33L);
        public static final Long VENDOR_DEFINED = new Long(0x80000000L);
    }

    public static interface VendorDefinedKeyBuilder {
        public Object build(Session var1, long var2);
    }
}

