/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.CharArrayAttribute;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.objects.Storage;
import iaik.pkcs.pkcs11.wrapper.Constants;

public class Data
extends Storage {
    protected CharArrayAttribute application_;
    protected ByteArrayAttribute objectID_;
    protected ByteArrayAttribute value_;

    public Data() {
        this.objectClass_.setLongValue(Object.ObjectClass.DATA);
    }

    protected Data(Session session, long l) {
        super(session, l);
        this.objectClass_.setLongValue(Object.ObjectClass.DATA);
    }

    protected void allocateAttributes() {
        super.allocateAttributes();
        this.application_ = new CharArrayAttribute(Attribute.APPLICATION);
        this.objectID_ = new ByteArrayAttribute(Attribute.OBJECT_ID);
        this.value_ = new ByteArrayAttribute(Attribute.VALUE);
        Data.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        Data data = (Data)super.clone();
        data.application_ = (CharArrayAttribute)this.application_.clone();
        data.objectID_ = (ByteArrayAttribute)this.objectID_.clone();
        data.value_ = (ByteArrayAttribute)this.value_.clone();
        Data.putAttributesInTable(data);
        return data;
    }

    public boolean equals(java.lang.Object object) {
        boolean bl = false;
        if (object instanceof Data) {
            Data data = (Data)object;
            bl = this == data || super.equals(data) && this.application_.equals(data.application_) && this.objectID_.equals(data.objectID_) && this.value_.equals(data.value_);
        }
        return bl;
    }

    public CharArrayAttribute getApplication() {
        return this.application_;
    }

    public static Object getInstance(Session session, long l) {
        return new Data(session, l);
    }

    public ByteArrayAttribute getObjectID() {
        return this.objectID_;
    }

    public ByteArrayAttribute getValue() {
        return this.value_;
    }

    public int hashCode() {
        return this.application_.hashCode() ^ this.objectID_.hashCode() ^ this.value_.hashCode();
    }

    protected static void putAttributesInTable(Data data) {
        if (data == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        data.attributeTable_.put(Attribute.APPLICATION, data.application_);
        data.attributeTable_.put(Attribute.OBJECT_ID, data.objectID_);
        data.attributeTable_.put(Attribute.VALUE, data.value_);
    }

    public void readAttributes(Session session) {
        super.readAttributes(session);
        Object.getAttributeValue(session, this.objectHandle_, this.application_);
        Object.getAttributeValue(session, this.objectHandle_, this.objectID_);
        Object.getAttributeValue(session, this.objectHandle_, this.value_);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(super.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Application: ");
        stringBuffer.append(this.application_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Object ID (DER, hex): ");
        stringBuffer.append(this.objectID_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Value (hex): ");
        stringBuffer.append(this.value_.toString());
        return stringBuffer.toString();
    }
}

