/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.objects.PublicKey;
import iaik.pkcs.pkcs11.wrapper.Constants;

public class DHPublicKey
extends PublicKey {
    protected ByteArrayAttribute prime_;
    protected ByteArrayAttribute base_;
    protected ByteArrayAttribute value_;

    public DHPublicKey() {
        this.keyType_.setLongValue(Key.KeyType.DH);
    }

    protected DHPublicKey(Session session, long l) {
        super(session, l);
        this.keyType_.setLongValue(Key.KeyType.DH);
    }

    protected void allocateAttributes() {
        super.allocateAttributes();
        this.prime_ = new ByteArrayAttribute(Attribute.PRIME);
        this.base_ = new ByteArrayAttribute(Attribute.BASE);
        this.value_ = new ByteArrayAttribute(Attribute.VALUE);
        DHPublicKey.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        DHPublicKey dHPublicKey = (DHPublicKey)super.clone();
        dHPublicKey.prime_ = (ByteArrayAttribute)this.prime_.clone();
        dHPublicKey.base_ = (ByteArrayAttribute)this.base_.clone();
        dHPublicKey.value_ = (ByteArrayAttribute)this.value_.clone();
        DHPublicKey.putAttributesInTable(dHPublicKey);
        return dHPublicKey;
    }

    public boolean equals(java.lang.Object object) {
        boolean bl = false;
        if (object instanceof DHPublicKey) {
            DHPublicKey dHPublicKey = (DHPublicKey)object;
            bl = this == dHPublicKey || super.equals(dHPublicKey) && this.prime_.equals(dHPublicKey.prime_) && this.base_.equals(dHPublicKey.base_) && this.value_.equals(dHPublicKey.value_);
        }
        return bl;
    }

    public ByteArrayAttribute getBase() {
        return this.base_;
    }

    public static Object getInstance(Session session, long l) {
        return new DHPublicKey(session, l);
    }

    public ByteArrayAttribute getPrime() {
        return this.prime_;
    }

    public ByteArrayAttribute getValue() {
        return this.value_;
    }

    protected static void putAttributesInTable(DHPublicKey dHPublicKey) {
        if (dHPublicKey == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        dHPublicKey.attributeTable_.put(Attribute.PRIME, dHPublicKey.prime_);
        dHPublicKey.attributeTable_.put(Attribute.BASE, dHPublicKey.base_);
        dHPublicKey.attributeTable_.put(Attribute.VALUE, dHPublicKey.value_);
    }

    public void readAttributes(Session session) {
        super.readAttributes(session);
        Object.getAttributeValues(session, this.objectHandle_, new Attribute[]{this.prime_, this.base_, this.value_});
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(super.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Prime (hex): ");
        stringBuffer.append(this.prime_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Base (hex): ");
        stringBuffer.append(this.base_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Value (hex): ");
        stringBuffer.append(this.value_.toString());
        return stringBuffer.toString();
    }
}

