/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.wrapper.Constants;

public class CASTSecretKey
extends SecretKey {
    protected ByteArrayAttribute value_;
    protected LongAttribute valueLen_;

    public CASTSecretKey() {
        this.keyType_.setLongValue(Key.KeyType.CAST);
    }

    protected CASTSecretKey(Session session, long l) {
        super(session, l);
        this.keyType_.setLongValue(Key.KeyType.CAST);
    }

    protected void allocateAttributes() {
        super.allocateAttributes();
        this.value_ = new ByteArrayAttribute(Attribute.VALUE);
        this.valueLen_ = new LongAttribute(Attribute.VALUE_LEN);
        CASTSecretKey.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        CASTSecretKey cASTSecretKey = (CASTSecretKey)super.clone();
        cASTSecretKey.value_ = (ByteArrayAttribute)this.value_.clone();
        cASTSecretKey.valueLen_ = (LongAttribute)this.valueLen_.clone();
        CASTSecretKey.putAttributesInTable(cASTSecretKey);
        return cASTSecretKey;
    }

    public boolean equals(java.lang.Object object) {
        boolean bl = false;
        if (object instanceof CASTSecretKey) {
            CASTSecretKey cASTSecretKey = (CASTSecretKey)object;
            bl = this == cASTSecretKey || super.equals(cASTSecretKey) && this.value_.equals(cASTSecretKey.value_) && this.valueLen_.equals(cASTSecretKey.valueLen_);
        }
        return bl;
    }

    public static Object getInstance(Session session, long l) {
        return new CASTSecretKey(session, l);
    }

    public ByteArrayAttribute getValue() {
        return this.value_;
    }

    public LongAttribute getValueLen() {
        return this.valueLen_;
    }

    protected static void putAttributesInTable(CASTSecretKey cASTSecretKey) {
        if (cASTSecretKey == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        cASTSecretKey.attributeTable_.put(Attribute.VALUE, cASTSecretKey.value_);
        cASTSecretKey.attributeTable_.put(Attribute.VALUE_LEN, cASTSecretKey.valueLen_);
    }

    public void readAttributes(Session session) {
        super.readAttributes(session);
        Object.getAttributeValue(session, this.objectHandle_, this.value_);
        Object.getAttributeValue(session, this.objectHandle_, this.valueLen_);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(super.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Value (hex): ");
        stringBuffer.append(this.value_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Value Length (dec): ");
        stringBuffer.append(this.valueLen_.toString(10));
        return stringBuffer.toString();
    }
}

