/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.wrapper.Constants;

public class CAST128SecretKey
extends SecretKey {
    protected ByteArrayAttribute value_;
    protected LongAttribute valueLen_;

    public CAST128SecretKey() {
        this.keyType_.setLongValue(Key.KeyType.CAST128);
    }

    protected CAST128SecretKey(Session session, long l) {
        super(session, l);
        this.keyType_.setLongValue(Key.KeyType.CAST128);
    }

    protected void allocateAttributes() {
        super.allocateAttributes();
        this.value_ = new ByteArrayAttribute(Attribute.VALUE);
        this.valueLen_ = new LongAttribute(Attribute.VALUE_LEN);
        CAST128SecretKey.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        CAST128SecretKey cAST128SecretKey = (CAST128SecretKey)super.clone();
        cAST128SecretKey.value_ = (ByteArrayAttribute)this.value_.clone();
        cAST128SecretKey.valueLen_ = (LongAttribute)this.valueLen_.clone();
        CAST128SecretKey.putAttributesInTable(cAST128SecretKey);
        return cAST128SecretKey;
    }

    public boolean equals(java.lang.Object object) {
        boolean bl = false;
        if (object instanceof CAST128SecretKey) {
            CAST128SecretKey cAST128SecretKey = (CAST128SecretKey)object;
            bl = this == cAST128SecretKey || super.equals(cAST128SecretKey) && this.value_.equals(cAST128SecretKey.value_) && this.valueLen_.equals(cAST128SecretKey.valueLen_);
        }
        return bl;
    }

    public static Object getInstance(Session session, long l) {
        return new CAST128SecretKey(session, l);
    }

    public ByteArrayAttribute getValue() {
        return this.value_;
    }

    public LongAttribute getValueLen() {
        return this.valueLen_;
    }

    protected static void putAttributesInTable(CAST128SecretKey cAST128SecretKey) {
        if (cAST128SecretKey == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        cAST128SecretKey.attributeTable_.put(Attribute.VALUE, cAST128SecretKey.value_);
        cAST128SecretKey.attributeTable_.put(Attribute.VALUE_LEN, cAST128SecretKey.valueLen_);
    }

    public void readAttributes(Session session) {
        super.readAttributes(session);
        Object.getAttributeValue(session, this.objectHandle_, this.value_);
        Object.getAttributeValue(session, this.objectHandle_, this.valueLen_);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(super.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Value (hex): ");
        stringBuffer.append(this.value_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Value Length (dec): ");
        stringBuffer.append(this.valueLen_.toString(10));
        return stringBuffer.toString();
    }
}

