/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.TokenRuntimeException;
import iaik.pkcs.pkcs11.wrapper.CK_ATTRIBUTE;
import java.util.Hashtable;

public class Attribute
implements Cloneable {
    public static final Long CLASS = new Long(0L);
    public static final Long TOKEN = new Long(1L);
    public static final Long PRIVATE = new Long(2L);
    public static final Long LABEL = new Long(3L);
    public static final Long APPLICATION = new Long(16L);
    public static final Long VALUE = new Long(17L);
    public static final Long OBJECT_ID = new Long(18L);
    public static final Long CERTIFICATE_TYPE = new Long(128L);
    public static final Long ISSUER = new Long(129L);
    public static final Long SERIAL_NUMBER = new Long(130L);
    public static final Long URL = new Long(137L);
    public static final Long HASH_OF_SUBJECT_PUBLIC_KEY = new Long(138L);
    public static final Long HASH_OF_ISSUER_PUBLIC_KEY = new Long(139L);
    public static final Long JAVA_MIDP_SECURITY_DOMAIN = new Long(136L);
    public static final Long AC_ISSUER = new Long(131L);
    public static final Long OWNER = new Long(132L);
    public static final Long ATTR_TYPES = new Long(133L);
    public static final Long TRUSTED = new Long(134L);
    public static final Long KEY_TYPE = new Long(256L);
    public static final Long SUBJECT = new Long(257L);
    public static final Long ID = new Long(258L);
    public static final Long CHECK_VALUE = new Long(144L);
    public static final Long CERTIFICATE_CATEGORY = new Long(135L);
    public static final Long SENSITIVE = new Long(259L);
    public static final Long ENCRYPT = new Long(260L);
    public static final Long DECRYPT = new Long(261L);
    public static final Long WRAP = new Long(262L);
    public static final Long WRAP_TEMPLATE = new Long(1073742353L);
    public static final Long UNWRAP = new Long(263L);
    public static final Long UNWRAP_TEMPLATE = new Long(1073742354L);
    public static final Long SIGN = new Long(264L);
    public static final Long SIGN_RECOVER = new Long(265L);
    public static final Long VERIFY = new Long(266L);
    public static final Long VERIFY_RECOVER = new Long(267L);
    public static final Long DERIVE = new Long(268L);
    public static final Long START_DATE = new Long(272L);
    public static final Long END_DATE = new Long(273L);
    public static final Long MODULUS = new Long(288L);
    public static final Long MODULUS_BITS = new Long(289L);
    public static final Long PUBLIC_EXPONENT = new Long(290L);
    public static final Long PRIVATE_EXPONENT = new Long(291L);
    public static final Long PRIME_1 = new Long(292L);
    public static final Long PRIME_2 = new Long(293L);
    public static final Long EXPONENT_1 = new Long(294L);
    public static final Long EXPONENT_2 = new Long(295L);
    public static final Long COEFFICIENT = new Long(296L);
    public static final Long PRIME = new Long(304L);
    public static final Long SUBPRIME = new Long(305L);
    public static final Long BASE = new Long(306L);
    public static final Long PRIME_BITS = new Long(307L);
    public static final Long SUB_PRIME_BITS = new Long(308L);
    public static final Long VALUE_BITS = new Long(352L);
    public static final Long VALUE_LEN = new Long(353L);
    public static final Long EXTRACTABLE = new Long(354L);
    public static final Long LOCAL = new Long(355L);
    public static final Long NEVER_EXTRACTABLE = new Long(356L);
    public static final Long WRAP_WITH_TRUSTED = new Long(528L);
    public static final Long ALWAYS_SENSITIVE = new Long(357L);
    public static final Long ALWAYS_AUTHENTICATE = new Long(514L);
    public static final Long KEY_GEN_MECHANISM = new Long(358L);
    public static final Long ALLOWED_MECHANISMS = new Long(0x40000600L);
    public static final Long MODIFIABLE = new Long(368L);
    public static final Long ECDSA_PARAMS = new Long(384L);
    public static final Long EC_PARAMS = new Long(384L);
    public static final Long EC_POINT = new Long(385L);
    public static final Long SECONDARY_AUTH = new Long(512L);
    public static final Long AUTH_PIN_FLAGS = new Long(513L);
    public static final Long HW_FEATURE_TYPE = new Long(768L);
    public static final Long RESET_ON_INIT = new Long(769L);
    public static final Long HAS_RESET = new Long(770L);
    public static final Long VENDOR_DEFINED = new Long(0x80000000L);
    protected static Hashtable attributeNames_;
    protected static Hashtable attributeClasses_;
    protected boolean present_;
    protected boolean sensitive_;
    protected CK_ATTRIBUTE ckAttribute_;
    static Class wx;
    static Class wy;
    static Class wz;
    static Class wA;
    static Class wB;
    static Class wC;
    static Class wD;
    static Class wE;
    static Class wF;
    static Class wG;
    static Class wH;
    static Class wI;

    protected Attribute() {
    }

    protected Attribute(Long l) {
        if (l == null) {
            throw new NullPointerException("Argument \"type\" must not be null.");
        }
        this.present_ = false;
        this.sensitive_ = false;
        this.ckAttribute_ = new CK_ATTRIBUTE();
        this.ckAttribute_.type = l;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Object clone() {
        Attribute attribute;
        try {
            attribute = (Attribute)super.clone();
            attribute.ckAttribute_ = (CK_ATTRIBUTE)this.ckAttribute_.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new TokenRuntimeException("An unexpected clone exception occurred.", cloneNotSupportedException);
        }
        return attribute;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Attribute) {
            Attribute attribute = (Attribute)object;
            bl = this == attribute || !this.present_ && !attribute.present_ || this.present_ && attribute.present_ && this.sensitive_ == attribute.sensitive_ && this.ckAttribute_.type == attribute.ckAttribute_.type && (this.ckAttribute_.pValue == attribute.ckAttribute_.pValue || this.ckAttribute_.pValue != null && this.ckAttribute_.pValue.equals(attribute.ckAttribute_.pValue));
        }
        return bl;
    }

    protected static Class getAttributeClass(Long l) {
        if (l == null) {
            throw new NullPointerException("Argument \"type\" must not be null.");
        }
        if (attributeClasses_ == null) {
            attributeClasses_ = new Hashtable(85);
            attributeClasses_.put(CLASS, wx != null ? wx : (wx = Attribute.class$("iaik.pkcs.pkcs11.objects.ObjectClassAttribute")));
            attributeClasses_.put(TOKEN, wy != null ? wy : (wy = Attribute.class$("iaik.pkcs.pkcs11.objects.BooleanAttribute")));
            attributeClasses_.put(PRIVATE, wy != null ? wy : (wy = Attribute.class$("iaik.pkcs.pkcs11.objects.BooleanAttribute")));
            attributeClasses_.put(LABEL, wz != null ? wz : (wz = Attribute.class$("iaik.pkcs.pkcs11.objects.CharArrayAttribute")));
            attributeClasses_.put(APPLICATION, wz != null ? wz : (wz = Attribute.class$("iaik.pkcs.pkcs11.objects.CharArrayAttribute")));
            attributeClasses_.put(VALUE, wA != null ? wA : (wA = Attribute.class$("iaik.pkcs.pkcs11.objects.ByteArrayAttribute")));
            attributeClasses_.put(OBJECT_ID, wA != null ? wA : (wA = Attribute.class$("iaik.pkcs.pkcs11.objects.ByteArrayAttribute")));
            attributeClasses_.put(CERTIFICATE_TYPE, wB != null ? wB : (wB = Attribute.class$("iaik.pkcs.pkcs11.objects.CertificateTypeAttribute")));
            attributeClasses_.put(ISSUER, wA != null ? wA : (wA = Attribute.class$("iaik.pkcs.pkcs11.objects.ByteArrayAttribute")));
            attributeClasses_.put(SERIAL_NUMBER, wA != null ? wA : (wA = Attribute.class$("iaik.pkcs.pkcs11.objects.ByteArrayAttribute")));
            attributeClasses_.put(URL, wz != null ? wz : (wz = Attribute.class$("iaik.pkcs.pkcs11.objects.CharArrayAttribute")));
            attributeClasses_.put(HASH_OF_SUBJECT_PUBLIC_KEY, wA != null ? wA : (wA = Attribute.class$("iaik.pkcs.pkcs11.objects.ByteArrayAttribute")));
            attributeClasses_.put(HASH_OF_ISSUER_PUBLIC_KEY, wA != null ? wA : (wA = Attribute.class$("iaik.pkcs.pkcs11.objects.ByteArrayAttribute")));
            attributeClasses_.put(JAVA_MIDP_SECURITY_DOMAIN, wC != null ? wC : (wC = Attribute.class$("iaik.pkcs.pkcs11.objects.LongAttribute")));
            attributeClasses_.put(AC_ISSUER, wA != null ? wA : (wA = Attribute.class$("iaik.pkcs.pkcs11.objects.ByteArrayAttribute")));
            attributeClasses_.put(OWNER, wA != null ? wA : (wA = Attribute.class$("iaik.pkcs.pkcs11.objects.ByteArrayAttribute")));
            attributeClasses_.put(ATTR_TYPES, wA != null ? wA : (wA = Attribute.class$("iaik.pkcs.pkcs11.objects.ByteArrayAttribute")));
            attributeClasses_.put(TRUSTED, wy != null ? wy : (wy = Attribute.class$("iaik.pkcs.pkcs11.objects.BooleanAttribute")));
            attributeClasses_.put(KEY_TYPE, wD != null ? wD : (wD = Attribute.class$("iaik.pkcs.pkcs11.objects.KeyTypeAttribute")));
            attributeClasses_.put(SUBJECT, wA != null ? wA : (wA = Attribute.class$("iaik.pkcs.pkcs11.objects.ByteArrayAttribute")));
            attributeClasses_.put(ID, wA != null ? wA : (wA = Attribute.class$("iaik.pkcs.pkcs11.objects.ByteArrayAttribute")));
            attributeClasses_.put(CHECK_VALUE, wA != null ? wA : (wA = Attribute.class$("iaik.pkcs.pkcs11.objects.ByteArrayAttribute")));
            attributeClasses_.put(CERTIFICATE_CATEGORY, wC != null ? wC : (wC = Attribute.class$("iaik.pkcs.pkcs11.objects.LongAttribute")));
            attributeClasses_.put(SENSITIVE, wy != null ? wy : (wy = Attribute.class$("iaik.pkcs.pkcs11.objects.BooleanAttribute")));
            attributeClasses_.put(ENCRYPT, wy != null ? wy : (wy = Attribute.class$("iaik.pkcs.pkcs11.objects.BooleanAttribute")));
            attributeClasses_.put(DECRYPT, wy != null ? wy : (wy = Attribute.class$("iaik.pkcs.pkcs11.objects.BooleanAttribute")));
            attributeClasses_.put(WRAP, wy != null ? wy : (wy = Attribute.class$("iaik.pkcs.pkcs11.objects.BooleanAttribute")));
            attributeClasses_.put(UNWRAP, wy != null ? wy : (wy = Attribute.class$("iaik.pkcs.pkcs11.objects.BooleanAttribute")));
            attributeClasses_.put(WRAP_TEMPLATE, wE != null ? wE : (wE = Attribute.class$("iaik.pkcs.pkcs11.objects.AttributeArray")));
            attributeClasses_.put(UNWRAP_TEMPLATE, wE != null ? wE : (wE = Attribute.class$("iaik.pkcs.pkcs11.objects.AttributeArray")));
            attributeClasses_.put(SIGN, wy != null ? wy : (wy = Attribute.class$("iaik.pkcs.pkcs11.objects.BooleanAttribute")));
            attributeClasses_.put(SIGN_RECOVER, wy != null ? wy : (wy = Attribute.class$("iaik.pkcs.pkcs11.objects.BooleanAttribute")));
            attributeClasses_.put(VERIFY, wy != null ? wy : (wy = Attribute.class$("iaik.pkcs.pkcs11.objects.BooleanAttribute")));
            attributeClasses_.put(VERIFY_RECOVER, wy != null ? wy : (wy = Attribute.class$("iaik.pkcs.pkcs11.objects.BooleanAttribute")));
            attributeClasses_.put(DERIVE, wy != null ? wy : (wy = Attribute.class$("iaik.pkcs.pkcs11.objects.BooleanAttribute")));
            attributeClasses_.put(START_DATE, wF != null ? wF : (wF = Attribute.class$("iaik.pkcs.pkcs11.objects.DateAttribute")));
            attributeClasses_.put(END_DATE, wF != null ? wF : (wF = Attribute.class$("iaik.pkcs.pkcs11.objects.DateAttribute")));
            attributeClasses_.put(MODULUS, wA != null ? wA : (wA = Attribute.class$("iaik.pkcs.pkcs11.objects.ByteArrayAttribute")));
            attributeClasses_.put(MODULUS_BITS, wC != null ? wC : (wC = Attribute.class$("iaik.pkcs.pkcs11.objects.LongAttribute")));
            attributeClasses_.put(PUBLIC_EXPONENT, wA != null ? wA : (wA = Attribute.class$("iaik.pkcs.pkcs11.objects.ByteArrayAttribute")));
            attributeClasses_.put(PRIVATE_EXPONENT, wA != null ? wA : (wA = Attribute.class$("iaik.pkcs.pkcs11.objects.ByteArrayAttribute")));
            attributeClasses_.put(PRIME_1, wA != null ? wA : (wA = Attribute.class$("iaik.pkcs.pkcs11.objects.ByteArrayAttribute")));
            attributeClasses_.put(PRIME_2, wA != null ? wA : (wA = Attribute.class$("iaik.pkcs.pkcs11.objects.ByteArrayAttribute")));
            attributeClasses_.put(EXPONENT_1, wA != null ? wA : (wA = Attribute.class$("iaik.pkcs.pkcs11.objects.ByteArrayAttribute")));
            attributeClasses_.put(EXPONENT_2, wA != null ? wA : (wA = Attribute.class$("iaik.pkcs.pkcs11.objects.ByteArrayAttribute")));
            attributeClasses_.put(COEFFICIENT, wA != null ? wA : (wA = Attribute.class$("iaik.pkcs.pkcs11.objects.ByteArrayAttribute")));
            attributeClasses_.put(PRIME, wA != null ? wA : (wA = Attribute.class$("iaik.pkcs.pkcs11.objects.ByteArrayAttribute")));
            attributeClasses_.put(SUBPRIME, wA != null ? wA : (wA = Attribute.class$("iaik.pkcs.pkcs11.objects.ByteArrayAttribute")));
            attributeClasses_.put(BASE, wA != null ? wA : (wA = Attribute.class$("iaik.pkcs.pkcs11.objects.ByteArrayAttribute")));
            attributeClasses_.put(PRIME_BITS, wC != null ? wC : (wC = Attribute.class$("iaik.pkcs.pkcs11.objects.LongAttribute")));
            attributeClasses_.put(SUB_PRIME_BITS, wC != null ? wC : (wC = Attribute.class$("iaik.pkcs.pkcs11.objects.LongAttribute")));
            attributeClasses_.put(VALUE_BITS, wC != null ? wC : (wC = Attribute.class$("iaik.pkcs.pkcs11.objects.LongAttribute")));
            attributeClasses_.put(VALUE_LEN, wC != null ? wC : (wC = Attribute.class$("iaik.pkcs.pkcs11.objects.LongAttribute")));
            attributeClasses_.put(EXTRACTABLE, wy != null ? wy : (wy = Attribute.class$("iaik.pkcs.pkcs11.objects.BooleanAttribute")));
            attributeClasses_.put(LOCAL, wy != null ? wy : (wy = Attribute.class$("iaik.pkcs.pkcs11.objects.BooleanAttribute")));
            attributeClasses_.put(NEVER_EXTRACTABLE, wy != null ? wy : (wy = Attribute.class$("iaik.pkcs.pkcs11.objects.BooleanAttribute")));
            attributeClasses_.put(WRAP_WITH_TRUSTED, wy != null ? wy : (wy = Attribute.class$("iaik.pkcs.pkcs11.objects.BooleanAttribute")));
            attributeClasses_.put(ALWAYS_SENSITIVE, wy != null ? wy : (wy = Attribute.class$("iaik.pkcs.pkcs11.objects.BooleanAttribute")));
            attributeClasses_.put(ALWAYS_AUTHENTICATE, wy != null ? wy : (wy = Attribute.class$("iaik.pkcs.pkcs11.objects.BooleanAttribute")));
            attributeClasses_.put(KEY_GEN_MECHANISM, wG != null ? wG : (wG = Attribute.class$("iaik.pkcs.pkcs11.objects.MechanismAttribute")));
            attributeClasses_.put(ALLOWED_MECHANISMS, wH != null ? wH : (wH = Attribute.class$("iaik.pkcs.pkcs11.objects.MechanismArrayAttribute")));
            attributeClasses_.put(MODIFIABLE, wy != null ? wy : (wy = Attribute.class$("iaik.pkcs.pkcs11.objects.BooleanAttribute")));
            attributeClasses_.put(ECDSA_PARAMS, wA != null ? wA : (wA = Attribute.class$("iaik.pkcs.pkcs11.objects.ByteArrayAttribute")));
            attributeClasses_.put(EC_PARAMS, wA != null ? wA : (wA = Attribute.class$("iaik.pkcs.pkcs11.objects.ByteArrayAttribute")));
            attributeClasses_.put(EC_POINT, wA != null ? wA : (wA = Attribute.class$("iaik.pkcs.pkcs11.objects.ByteArrayAttribute")));
            attributeClasses_.put(SECONDARY_AUTH, wy != null ? wy : (wy = Attribute.class$("iaik.pkcs.pkcs11.objects.BooleanAttribute")));
            attributeClasses_.put(AUTH_PIN_FLAGS, wC != null ? wC : (wC = Attribute.class$("iaik.pkcs.pkcs11.objects.LongAttribute")));
            attributeClasses_.put(HW_FEATURE_TYPE, wI != null ? wI : (wI = Attribute.class$("iaik.pkcs.pkcs11.objects.HardwareFeatureTypeAttribute")));
            attributeClasses_.put(RESET_ON_INIT, wy != null ? wy : (wy = Attribute.class$("iaik.pkcs.pkcs11.objects.BooleanAttribute")));
            attributeClasses_.put(HAS_RESET, wy != null ? wy : (wy = Attribute.class$("iaik.pkcs.pkcs11.objects.BooleanAttribute")));
        }
        Class clazz = (Class)attributeClasses_.get(l);
        return clazz;
    }

    protected static String getAttributeName(Long l) {
        String string;
        if (l == null) {
            throw new NullPointerException("Argument \"type\" must not be null.");
        }
        if (attributeNames_ == null) {
            attributeNames_ = new Hashtable(85);
            attributeNames_.put(CLASS, "Class");
            attributeNames_.put(TOKEN, "Token");
            attributeNames_.put(PRIVATE, "Private");
            attributeNames_.put(LABEL, "Label");
            attributeNames_.put(APPLICATION, "Application");
            attributeNames_.put(VALUE, "Value");
            attributeNames_.put(OBJECT_ID, "Object ID");
            attributeNames_.put(CERTIFICATE_TYPE, "Certificate Type");
            attributeNames_.put(ISSUER, "Issuer");
            attributeNames_.put(SERIAL_NUMBER, "Serial Number");
            attributeNames_.put(URL, "URL");
            attributeNames_.put(HASH_OF_SUBJECT_PUBLIC_KEY, "Hash Of Subject Public Key");
            attributeNames_.put(HASH_OF_ISSUER_PUBLIC_KEY, "Hash Of Issuer Public Key");
            attributeNames_.put(JAVA_MIDP_SECURITY_DOMAIN, "Java MIDP Security Domain");
            attributeNames_.put(AC_ISSUER, "AC Issuer");
            attributeNames_.put(OWNER, "Owner");
            attributeNames_.put(ATTR_TYPES, "Attribute Types");
            attributeNames_.put(TRUSTED, "Trusted");
            attributeNames_.put(KEY_TYPE, "Key Type");
            attributeNames_.put(SUBJECT, "Subject");
            attributeNames_.put(ID, "ID");
            attributeNames_.put(CHECK_VALUE, "Check Value");
            attributeNames_.put(CERTIFICATE_CATEGORY, "Certificate Category");
            attributeNames_.put(SENSITIVE, "Sensitive");
            attributeNames_.put(ENCRYPT, "Encrypt");
            attributeNames_.put(DECRYPT, "Decrypt");
            attributeNames_.put(WRAP, "Wrap");
            attributeNames_.put(UNWRAP, "Unwrap");
            attributeNames_.put(WRAP_TEMPLATE, "Wrap Template");
            attributeNames_.put(UNWRAP_TEMPLATE, "Unwrap Template");
            attributeNames_.put(SIGN, "Sign");
            attributeNames_.put(SIGN_RECOVER, "Sign Recover");
            attributeNames_.put(VERIFY, "Verify");
            attributeNames_.put(VERIFY_RECOVER, "Verify Recover");
            attributeNames_.put(DERIVE, "Derive");
            attributeNames_.put(START_DATE, "Start Date");
            attributeNames_.put(END_DATE, "End Date");
            attributeNames_.put(MODULUS, "Modulus");
            attributeNames_.put(MODULUS_BITS, "Modulus Bits");
            attributeNames_.put(PUBLIC_EXPONENT, "Public Exponent");
            attributeNames_.put(PRIVATE_EXPONENT, "Private Exponent");
            attributeNames_.put(PRIME_1, "Prime 1");
            attributeNames_.put(PRIME_2, "Prime 2");
            attributeNames_.put(EXPONENT_1, "Exponent 1");
            attributeNames_.put(EXPONENT_2, "Exponent 2");
            attributeNames_.put(COEFFICIENT, "Coefficient");
            attributeNames_.put(PRIME, "Prime");
            attributeNames_.put(SUBPRIME, "Subprime");
            attributeNames_.put(BASE, "Base");
            attributeNames_.put(PRIME_BITS, "Prime Pits");
            attributeNames_.put(SUB_PRIME_BITS, "Subprime Bits");
            attributeNames_.put(VALUE_BITS, "Value Bits");
            attributeNames_.put(VALUE_LEN, "Value Length");
            attributeNames_.put(EXTRACTABLE, "Extractable");
            attributeNames_.put(LOCAL, "Local");
            attributeNames_.put(NEVER_EXTRACTABLE, "Never Extractable");
            attributeNames_.put(WRAP_WITH_TRUSTED, "Wrap With Trusted");
            attributeNames_.put(ALWAYS_SENSITIVE, "Always Sensitive");
            attributeNames_.put(ALWAYS_AUTHENTICATE, "Always Authenticate");
            attributeNames_.put(KEY_GEN_MECHANISM, "Key Generation Mechanism");
            attributeNames_.put(ALLOWED_MECHANISMS, "Allowed Mechanisms");
            attributeNames_.put(MODIFIABLE, "Modifiable");
            attributeNames_.put(ECDSA_PARAMS, "ECDSA Parameters");
            attributeNames_.put(EC_PARAMS, "EC Parameters");
            attributeNames_.put(EC_POINT, "EC Point");
            attributeNames_.put(SECONDARY_AUTH, "Secondary Authentication");
            attributeNames_.put(AUTH_PIN_FLAGS, "Authentication PIN Flags");
            attributeNames_.put(HW_FEATURE_TYPE, "Hardware Feature Type");
            attributeNames_.put(RESET_ON_INIT, "Reset on Initialization");
            attributeNames_.put(HAS_RESET, "Has been reset");
            attributeNames_.put(VENDOR_DEFINED, "Vendor Defined");
        }
        if ((l & VENDOR_DEFINED) != 0L) {
            StringBuffer stringBuffer = new StringBuffer(36);
            stringBuffer.append("VENDOR_DEFINED [0x");
            stringBuffer.append(Long.toHexString(l));
            stringBuffer.append(']');
            string = stringBuffer.toString();
        } else {
            string = (String)attributeNames_.get(l);
            if (string == null) {
                StringBuffer stringBuffer = new StringBuffer(25);
                stringBuffer.append("[0x");
                stringBuffer.append(Long.toHexString(l));
                stringBuffer.append(']');
                string = stringBuffer.toString();
            }
        }
        return string;
    }

    protected CK_ATTRIBUTE getCkAttribute() {
        return this.ckAttribute_;
    }

    protected Long getType() {
        return new Long(this.ckAttribute_.type);
    }

    protected String getValueString() {
        String string = this.ckAttribute_ != null && this.ckAttribute_.pValue != null ? this.ckAttribute_.pValue.toString() : "<NULL_PTR>";
        return string;
    }

    public int hashCode() {
        return (int)this.ckAttribute_.type ^ (this.ckAttribute_.pValue != null ? this.ckAttribute_.pValue.hashCode() : 0);
    }

    public boolean isPresent() {
        return this.present_;
    }

    public boolean isSensitive() {
        return this.sensitive_;
    }

    protected void setCkAttribute(CK_ATTRIBUTE cK_ATTRIBUTE) {
        if (cK_ATTRIBUTE == null) {
            throw new NullPointerException("Argument \"ckAttribute\" must not be null.");
        }
        this.ckAttribute_ = cK_ATTRIBUTE;
    }

    public void setPresent(boolean bl) {
        this.present_ = bl;
    }

    public void setSensitive(boolean bl) {
        this.sensitive_ = bl;
    }

    protected void setType(Long l) {
        if (l == null) {
            throw new NullPointerException("Argument \"type\" must not be null.");
        }
        this.ckAttribute_.type = l;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(32);
        if (bl) {
            String string = Attribute.getAttributeName(new Long(this.ckAttribute_.type));
            stringBuffer.append(string);
            stringBuffer.append(": ");
        }
        if (this.present_) {
            if (this.sensitive_) {
                stringBuffer.append("<Value is sensitive>");
            } else {
                stringBuffer.append(this.getValueString());
            }
        } else {
            stringBuffer.append("<Attribute not present>");
        }
        return stringBuffer.toString();
    }
}

