/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11;

import iaik.pkcs.pkcs11.State;
import iaik.pkcs.pkcs11.TokenRuntimeException;
import iaik.pkcs.pkcs11.wrapper.CK_SESSION_INFO;
import iaik.pkcs.pkcs11.wrapper.Constants;
import iaik.pkcs.pkcs11.wrapper.Functions;

public class SessionInfo
implements Cloneable {
    protected long slotID_;
    protected State state_;
    protected long deviceError_;
    protected boolean rwSession_;
    protected boolean serialSession_;

    protected SessionInfo(CK_SESSION_INFO cK_SESSION_INFO) {
        if (cK_SESSION_INFO == null) {
            throw new NullPointerException("Argument \"ckSessionInfo\" must not be null.");
        }
        this.slotID_ = cK_SESSION_INFO.slotID;
        this.state_ = new State(cK_SESSION_INFO.state);
        this.deviceError_ = cK_SESSION_INFO.ulDeviceError;
        this.rwSession_ = (cK_SESSION_INFO.flags & 2L) != 0L;
        this.serialSession_ = (cK_SESSION_INFO.flags & 4L) != 0L;
    }

    public Object clone() {
        SessionInfo sessionInfo;
        try {
            sessionInfo = (SessionInfo)super.clone();
            sessionInfo.state_ = (State)this.state_.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new TokenRuntimeException("An unexpected clone exception occurred.", cloneNotSupportedException);
        }
        return sessionInfo;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof SessionInfo) {
            SessionInfo sessionInfo = (SessionInfo)object;
            bl = this == sessionInfo || this.slotID_ == sessionInfo.slotID_ && this.state_.equals(sessionInfo.state_) && this.deviceError_ == sessionInfo.deviceError_ && this.rwSession_ == sessionInfo.rwSession_ && this.serialSession_ == sessionInfo.serialSession_;
        }
        return bl;
    }

    public long getDeviceError() {
        return this.deviceError_;
    }

    public State getState() {
        return this.state_;
    }

    public int hashCode() {
        return (int)this.slotID_ ^ this.state_.hashCode() ^ (int)this.deviceError_;
    }

    public boolean isRwSession() {
        return this.rwSession_;
    }

    public boolean isSerialSession() {
        return this.serialSession_;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("State: ");
        stringBuffer.append(this.state_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("Device Error: 0x");
        stringBuffer.append(Functions.toHexString(this.deviceError_));
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("Read/Write Session: ");
        stringBuffer.append(this.rwSession_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("Serial Session: ");
        stringBuffer.append(this.serialSession_);
        return stringBuffer.toString();
    }
}

