/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11;

import iaik.pkcs.pkcs11.Info;
import iaik.pkcs.pkcs11.InitializeArgs;
import iaik.pkcs.pkcs11.MutexHandler;
import iaik.pkcs.pkcs11.Slot;
import iaik.pkcs.pkcs11.wrapper.CK_CREATEMUTEX;
import iaik.pkcs.pkcs11.wrapper.CK_C_INITIALIZE_ARGS;
import iaik.pkcs.pkcs11.wrapper.CK_DESTROYMUTEX;
import iaik.pkcs.pkcs11.wrapper.CK_INFO;
import iaik.pkcs.pkcs11.wrapper.CK_LOCKMUTEX;
import iaik.pkcs.pkcs11.wrapper.CK_UNLOCKMUTEX;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Connector;

public class Module {
    protected PKCS11 pkcs11Module_;

    protected Module(PKCS11 pKCS11) {
        if (pKCS11 == null) {
            throw new NullPointerException("Argument \"pkcs11Module\" must not be null.");
        }
        this.pkcs11Module_ = pKCS11;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Module) {
            Module module = (Module)object;
            bl = this == module || this.pkcs11Module_.equals(module.pkcs11Module_);
        }
        return bl;
    }

    public void finalize() {
        this.pkcs11Module_.finalize();
        super.finalize();
    }

    public void finalize(Object object) {
        this.pkcs11Module_.C_Finalize(object);
    }

    public Info getInfo() {
        CK_INFO cK_INFO = this.pkcs11Module_.C_GetInfo();
        return new Info(cK_INFO);
    }

    public static Module getInstance(String string) {
        if (string == null) {
            throw new NullPointerException("Argument \"pkcs11ModuleName\" must not be null.");
        }
        PKCS11 pKCS11 = PKCS11Connector.connectToPKCS11Module(string);
        return new Module(pKCS11);
    }

    public static Module getInstance(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("Argument \"pkcs11ModuleName\" must not be null.");
        }
        PKCS11 pKCS11 = PKCS11Connector.connectToPKCS11Module(string, string2);
        return new Module(pKCS11);
    }

    public PKCS11 getPKCS11Module() {
        return this.pkcs11Module_;
    }

    public Slot[] getSlotList(boolean bl) {
        long[] lArray = this.pkcs11Module_.C_GetSlotList(bl);
        Slot[] slotArray = new Slot[lArray.length];
        int n = 0;
        while (n < slotArray.length) {
            slotArray[n] = new Slot(this, lArray[n]);
            ++n;
        }
        return slotArray;
    }

    public int hashCode() {
        return this.pkcs11Module_.hashCode();
    }

    public void initialize(InitializeArgs initializeArgs) {
        CK_C_INITIALIZE_ARGS cK_C_INITIALIZE_ARGS = null;
        if (initializeArgs != null) {
            InitializeArgs initializeArgs2 = initializeArgs;
            MutexHandler mutexHandler = initializeArgs2.getMutexHandler();
            cK_C_INITIALIZE_ARGS = new CK_C_INITIALIZE_ARGS();
            if (mutexHandler != null) {
                cK_C_INITIALIZE_ARGS.CreateMutex = new CK_CREATEMUTEX(mutexHandler){
                    private final MutexHandler wu;
                    {
                        this.wu = mutexHandler;
                    }

                    public Object CK_CREATEMUTEX() {
                        return this.wu.createMutex();
                    }
                };
                cK_C_INITIALIZE_ARGS.DestroyMutex = new CK_DESTROYMUTEX(mutexHandler){
                    private final MutexHandler wu;
                    {
                        this.wu = mutexHandler;
                    }

                    public void CK_DESTROYMUTEX(Object object) {
                        this.wu.destroyMutex(object);
                    }
                };
                cK_C_INITIALIZE_ARGS.LockMutex = new CK_LOCKMUTEX(mutexHandler){
                    private final MutexHandler wu;
                    {
                        this.wu = mutexHandler;
                    }

                    public void CK_LOCKMUTEX(Object object) {
                        this.wu.lockMutex(object);
                    }
                };
                cK_C_INITIALIZE_ARGS.UnlockMutex = new CK_UNLOCKMUTEX(mutexHandler){
                    private final MutexHandler wu;
                    {
                        this.wu = mutexHandler;
                    }

                    public void CK_UNLOCKMUTEX(Object object) {
                        this.wu.unlockMutex(object);
                    }
                };
            } else {
                cK_C_INITIALIZE_ARGS.CreateMutex = null;
                cK_C_INITIALIZE_ARGS.DestroyMutex = null;
                cK_C_INITIALIZE_ARGS.LockMutex = null;
                cK_C_INITIALIZE_ARGS.UnlockMutex = null;
            }
            if (initializeArgs2.isLibraryCantCreateOsThreads()) {
                cK_C_INITIALIZE_ARGS.flags |= 1L;
            }
            if (initializeArgs2.isOsLockingOk()) {
                cK_C_INITIALIZE_ARGS.flags |= 2L;
            }
            cK_C_INITIALIZE_ARGS.pReserved = initializeArgs2.getReserved();
        }
        this.pkcs11Module_.C_Initialize(cK_C_INITIALIZE_ARGS);
    }

    public String toString() {
        return this.pkcs11Module_ != null ? this.pkcs11Module_.toString() : null;
    }

    public Slot waitForSlotEvent(boolean bl, Object object) {
        long l = bl ? 1L : 0L;
        long l2 = this.pkcs11Module_.C_WaitForSlotEvent(l, object);
        return new Slot(this, l2);
    }

    public static interface SlotRequirement {
        public static final boolean ALL_SLOTS = false;
        public static final boolean TOKEN_PRESENT = true;
    }

    public static interface WaitingBehavior {
        public static final boolean BLOCK = false;
        public static final boolean DONT_BLOCK = true;
    }
}

