/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11;

import iaik.pkcs.pkcs11.MutexHandler;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;

public class DefaultMutexHandler
implements MutexHandler {
    public Object createMutex() {
        return new Mutex(this);
    }

    public void destroyMutex(Object object) {
    }

    public void lockMutex(Object object) {
        try {
            Mutex mutex = (Mutex)object;
            while (true) {
                try {
                    mutex.lock();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        catch (ClassCastException classCastException) {
            throw new PKCS11Exception(416L);
        }
    }

    public void unlockMutex(Object object) {
        try {
            Mutex mutex = (Mutex)object;
            mutex.unlock();
        }
        catch (ClassCastException classCastException) {
            throw new PKCS11Exception(416L);
        }
    }

    class Mutex {
        private final DefaultMutexHandler wt;
        protected boolean locked_;

        public Mutex(DefaultMutexHandler defaultMutexHandler) {
            this.wt = defaultMutexHandler;
            this.locked_ = false;
        }

        public synchronized void lock() {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            try {
                while (this.locked_) {
                    this.wait();
                }
                this.locked_ = true;
            }
            catch (InterruptedException interruptedException) {
                this.notify();
                throw interruptedException;
            }
        }

        public String toString() {
            return this.locked_ ? "locked" : "unlocked";
        }

        public synchronized boolean unlock() {
            boolean bl = this.locked_;
            this.locked_ = false;
            this.notify();
            return bl;
        }
    }
}

