/*
 * Decompiled with CFR 0.152.
 */
package pl.unizeto.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.unizeto.b.a.a.b;
import pl.unizeto.swing.a;

public class j
extends JPanel
implements Printable {
    private static final Logger log = LoggerFactory.getLogger(j.class);
    private Map<URL, byte[]> ctc = new HashMap<URL, byte[]>();
    private String title;
    private JScrollPane ctd;
    private JTextPane cte;

    public j() {
        this.pB();
    }

    public j(byte[] byArray) {
        this();
        this.loadXML(byArray);
    }

    private void pB() {
        this.ctd = new JScrollPane();
        this.cte = new JTextPane();
        this.setLayout(new GridBagLayout());
        this.cte.setEditable(false);
        this.ctd.setViewportView(this.cte);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.ctd, gridBagConstraints);
    }

    public void loadXML(byte[] byArray) {
        Set<URI> set = a.getXMLStyleSheetURLs(new ByteArrayInputStream(byArray));
        if (set.size() > 1) {
            throw new IllegalArgumentException("XML documents with multiple XML StyleSheet instructions not supported");
        }
        if (set.size() == 0) {
            throw new IllegalArgumentException("XML StyleSheet instruction not found in XML document");
        }
        URL uRL = set.iterator().next().toURL();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (this.ctc.containsKey(uRL)) {
            IOUtils.write((byte[])this.ctc.get(uRL), (OutputStream)byteArrayOutputStream);
        } else {
            URLConnection uRLConnection = uRL.openConnection();
            IOUtils.copy((InputStream)uRLConnection.getInputStream(), (OutputStream)byteArrayOutputStream);
            this.ctc.put(uRL, byteArrayOutputStream.toByteArray());
        }
        this.s(byArray, byteArrayOutputStream.toByteArray());
    }

    private void s(byte[] byArray, byte[] byArray2) {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        StringWriter stringWriter = new StringWriter();
        StreamSource streamSource = new StreamSource(new ByteArrayInputStream(byArray));
        StreamResult streamResult = new StreamResult(stringWriter);
        Transformer transformer = transformerFactory.newTransformer(new StreamSource(new ByteArrayInputStream(byArray2)));
        transformer.transform(streamSource, streamResult);
        String string = stringWriter.toString();
        HTMLEditorKit hTMLEditorKit = new HTMLEditorKit();
        HTMLDocument hTMLDocument = (HTMLDocument)hTMLEditorKit.createDefaultDocument();
        this.cte.setEditorKit(hTMLEditorKit);
        this.cte.setContentType("text/html;");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
        this.cte.read((InputStream)byteArrayInputStream, (Object)hTMLDocument);
        this.cte.setDocument(hTMLDocument);
        this.cte.setCaretPosition(0);
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n2) {
        if (n2 >= 1) {
            return 1;
        }
        j.scaleForPrint(graphics, pageFormat, this.cte.getWidth(), this.cte.getHeight());
        this.export((Graphics2D)graphics, this.cte);
        return 0;
    }

    public void export(Graphics2D graphics2D, JTextPane jTextPane) {
        jTextPane.print(graphics2D);
    }

    public static void scaleForPrint(Graphics graphics, PageFormat pageFormat, int n2, int n3) {
        double d2 = pageFormat.getImageableWidth();
        double d3 = pageFormat.getImageableHeight();
        double d4 = d2 / (double)n2;
        double d5 = d3 / (double)n3;
        double d6 = Math.min(d4, d5);
        double d7 = 0.0;
        double d8 = 0.0;
        if (d4 > d6) {
            d7 = 0.5 * (d4 - d6) * (double)n2;
        } else {
            d8 = 0.5 * (d5 - d6) * (double)n3;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
        graphics2D.translate(d7, d8);
        graphics2D.scale(d6, d6);
    }

    public void print() {
        log.info("Drukowanie dokumentu {}", (Object)this.getTitle());
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(this);
        if (StringUtils.isNotBlank((String)this.getTitle())) {
            printerJob.setJobName(this.getTitle());
        } else {
            printerJob.setJobName("Document");
        }
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (PrinterException printerException) {
                log.error("B\u0142\u0105d podczas drukowania", (Throwable)printerException);
                b.showFault((Throwable)printerException);
            }
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public Map<URL, byte[]> getXsltCache() {
        return this.ctc;
    }

    public void setXsltCache(Map<URL, byte[]> map) {
        this.ctc = map;
    }
}

