/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.slf4j.Marker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicMarker
implements Marker {
    private static final long serialVersionUID = 1803952589649545191L;
    private final String name;
    private List<Marker> referenceList;
    private static String OPEN = "[ ";
    private static String CLOSE = " ]";
    private static String SEP = ", ";

    BasicMarker(String string) {
        if (string == null) {
            throw new IllegalArgumentException("A marker name cannot be null");
        }
        this.name = string;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public synchronized void add(Marker marker) {
        if (marker == null) {
            throw new IllegalArgumentException("A null value cannot be added to a Marker as reference.");
        }
        if (this.contains(marker)) {
            return;
        }
        if (marker.contains(this)) {
            return;
        }
        if (this.referenceList == null) {
            this.referenceList = new Vector<Marker>();
        }
        this.referenceList.add(marker);
    }

    @Override
    public synchronized boolean hasReferences() {
        return this.referenceList != null && this.referenceList.size() > 0;
    }

    @Override
    public boolean hasChildren() {
        return this.hasReferences();
    }

    @Override
    public synchronized Iterator<Marker> iterator() {
        if (this.referenceList != null) {
            return this.referenceList.iterator();
        }
        List list = Collections.emptyList();
        return list.iterator();
    }

    @Override
    public synchronized boolean remove(Marker marker) {
        if (this.referenceList == null) {
            return false;
        }
        int n = this.referenceList.size();
        for (int i = 0; i < n; ++i) {
            Marker marker2 = this.referenceList.get(i);
            if (!marker.equals(marker2)) continue;
            this.referenceList.remove(i);
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Marker marker) {
        if (marker == null) {
            throw new IllegalArgumentException("Other cannot be null");
        }
        if (this.equals(marker)) {
            return true;
        }
        if (this.hasReferences()) {
            for (int i = 0; i < this.referenceList.size(); ++i) {
                Marker marker2 = this.referenceList.get(i);
                if (!marker2.contains(marker)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean contains(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Other cannot be null");
        }
        if (this.name.equals(string)) {
            return true;
        }
        if (this.hasReferences()) {
            for (int i = 0; i < this.referenceList.size(); ++i) {
                Marker marker = this.referenceList.get(i);
                if (!marker.contains(string)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Marker)) {
            return false;
        }
        Marker marker = (Marker)object;
        return this.name.equals(marker.getName());
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        if (!this.hasReferences()) {
            return this.getName();
        }
        Iterator<Marker> iterator = this.iterator();
        StringBuilder stringBuilder = new StringBuilder(this.getName());
        stringBuilder.append(' ').append(OPEN);
        while (iterator.hasNext()) {
            Marker marker = iterator.next();
            stringBuilder.append(marker.getName());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(SEP);
        }
        stringBuilder.append(CLOSE);
        return stringBuilder.toString();
    }
}

