/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.objects.PrivateKey;
import iaik.pkcs.pkcs11.wrapper.Constants;

public class X942DHPrivateKey
extends PrivateKey {
    protected ByteArrayAttribute prime_;
    protected ByteArrayAttribute base_;
    protected ByteArrayAttribute subprime_;
    protected ByteArrayAttribute value_;

    public X942DHPrivateKey() {
        this.keyType_.setLongValue(Key.KeyType.X9_42_DH);
    }

    protected X942DHPrivateKey(Session session, long l) {
        super(session, l);
        this.keyType_.setLongValue(Key.KeyType.X9_42_DH);
    }

    protected void allocateAttributes() {
        super.allocateAttributes();
        this.prime_ = new ByteArrayAttribute(Attribute.PRIME);
        this.base_ = new ByteArrayAttribute(Attribute.BASE);
        this.subprime_ = new ByteArrayAttribute(Attribute.SUBPRIME);
        this.value_ = new ByteArrayAttribute(Attribute.VALUE);
        X942DHPrivateKey.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        X942DHPrivateKey x942DHPrivateKey = (X942DHPrivateKey)super.clone();
        x942DHPrivateKey.prime_ = (ByteArrayAttribute)this.prime_.clone();
        x942DHPrivateKey.base_ = (ByteArrayAttribute)this.base_.clone();
        x942DHPrivateKey.subprime_ = (ByteArrayAttribute)this.subprime_.clone();
        x942DHPrivateKey.value_ = (ByteArrayAttribute)this.value_.clone();
        X942DHPrivateKey.putAttributesInTable(x942DHPrivateKey);
        return x942DHPrivateKey;
    }

    public boolean equals(java.lang.Object object) {
        boolean bl = false;
        if (object instanceof X942DHPrivateKey) {
            X942DHPrivateKey x942DHPrivateKey = (X942DHPrivateKey)object;
            bl = this == x942DHPrivateKey || super.equals(x942DHPrivateKey) && this.prime_.equals(x942DHPrivateKey.prime_) && this.base_.equals(x942DHPrivateKey.base_) && this.subprime_.equals(x942DHPrivateKey.subprime_) && this.value_.equals(x942DHPrivateKey.value_);
        }
        return bl;
    }

    public ByteArrayAttribute getBase() {
        return this.base_;
    }

    public static Object getInstance(Session session, long l) {
        return new X942DHPrivateKey(session, l);
    }

    public ByteArrayAttribute getPrime() {
        return this.prime_;
    }

    public ByteArrayAttribute getSubprime() {
        return this.subprime_;
    }

    public ByteArrayAttribute getValue() {
        return this.value_;
    }

    protected static void putAttributesInTable(X942DHPrivateKey x942DHPrivateKey) {
        if (x942DHPrivateKey == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        x942DHPrivateKey.attributeTable_.put(Attribute.PRIME, x942DHPrivateKey.prime_);
        x942DHPrivateKey.attributeTable_.put(Attribute.BASE, x942DHPrivateKey.base_);
        x942DHPrivateKey.attributeTable_.put(Attribute.SUBPRIME, x942DHPrivateKey.subprime_);
        x942DHPrivateKey.attributeTable_.put(Attribute.VALUE, x942DHPrivateKey.value_);
    }

    public void readAttributes(Session session) {
        super.readAttributes(session);
        Object.getAttributeValues(session, this.objectHandle_, new Attribute[]{this.prime_, this.base_, this.subprime_});
        Object.getAttributeValue(session, this.objectHandle_, this.value_);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(super.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Prime (hex): ");
        stringBuffer.append(this.prime_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Base (hex): ");
        stringBuffer.append(this.base_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Subprime (hex): ");
        stringBuffer.append(this.subprime_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Value (hex): ");
        stringBuffer.append(this.value_.toString());
        return stringBuffer.toString();
    }
}

