/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.objects.PublicKey;
import iaik.pkcs.pkcs11.wrapper.Constants;

public class RSAPublicKey
extends PublicKey {
    protected ByteArrayAttribute modulus_;
    protected ByteArrayAttribute publicExponent_;
    protected LongAttribute modulusBits_;

    public RSAPublicKey() {
        this.keyType_.setLongValue(Key.KeyType.RSA);
    }

    protected RSAPublicKey(Session session, long l) {
        super(session, l);
        this.keyType_.setLongValue(Key.KeyType.RSA);
    }

    protected void allocateAttributes() {
        super.allocateAttributes();
        this.modulus_ = new ByteArrayAttribute(Attribute.MODULUS);
        this.publicExponent_ = new ByteArrayAttribute(Attribute.PUBLIC_EXPONENT);
        this.modulusBits_ = new LongAttribute(Attribute.MODULUS_BITS);
        RSAPublicKey.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        RSAPublicKey rSAPublicKey = (RSAPublicKey)super.clone();
        rSAPublicKey.modulus_ = (ByteArrayAttribute)this.modulus_.clone();
        rSAPublicKey.publicExponent_ = (ByteArrayAttribute)this.publicExponent_.clone();
        rSAPublicKey.modulusBits_ = (LongAttribute)this.modulusBits_.clone();
        RSAPublicKey.putAttributesInTable(rSAPublicKey);
        return rSAPublicKey;
    }

    public boolean equals(java.lang.Object object) {
        boolean bl = false;
        if (object instanceof RSAPublicKey) {
            RSAPublicKey rSAPublicKey = (RSAPublicKey)object;
            bl = this == rSAPublicKey || super.equals(rSAPublicKey) && this.modulus_.equals(rSAPublicKey.modulus_) && this.publicExponent_.equals(rSAPublicKey.publicExponent_) && this.modulusBits_.equals(rSAPublicKey.modulusBits_);
        }
        return bl;
    }

    public static Object getInstance(Session session, long l) {
        return new RSAPublicKey(session, l);
    }

    public ByteArrayAttribute getModulus() {
        return this.modulus_;
    }

    public LongAttribute getModulusBits() {
        return this.modulusBits_;
    }

    public ByteArrayAttribute getPublicExponent() {
        return this.publicExponent_;
    }

    protected static void putAttributesInTable(RSAPublicKey rSAPublicKey) {
        if (rSAPublicKey == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        rSAPublicKey.attributeTable_.put(Attribute.MODULUS, rSAPublicKey.modulus_);
        rSAPublicKey.attributeTable_.put(Attribute.PUBLIC_EXPONENT, rSAPublicKey.publicExponent_);
        rSAPublicKey.attributeTable_.put(Attribute.MODULUS_BITS, rSAPublicKey.modulusBits_);
    }

    public void readAttributes(Session session) {
        super.readAttributes(session);
        Object.getAttributeValues(session, this.objectHandle_, new Attribute[]{this.modulus_, this.publicExponent_, this.modulusBits_});
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(super.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Modulus (hex): ");
        stringBuffer.append(this.modulus_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Public Exponent (hex): ");
        stringBuffer.append(this.publicExponent_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Modulus Bits (dec): ");
        stringBuffer.append(this.modulusBits_.toString(10));
        return stringBuffer.toString();
    }
}

