/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.objects.PrivateKey;
import iaik.pkcs.pkcs11.wrapper.Constants;

public class RSAPrivateKey
extends PrivateKey {
    protected ByteArrayAttribute modulus_;
    protected ByteArrayAttribute publicExponent_;
    protected ByteArrayAttribute privateExponent_;
    protected ByteArrayAttribute prime1_;
    protected ByteArrayAttribute prime2_;
    protected ByteArrayAttribute exponent1_;
    protected ByteArrayAttribute exponent2_;
    protected ByteArrayAttribute coefficient_;

    public RSAPrivateKey() {
        this.keyType_.setLongValue(Key.KeyType.RSA);
    }

    protected RSAPrivateKey(Session session, long l) {
        super(session, l);
        this.keyType_.setLongValue(Key.KeyType.RSA);
    }

    protected void allocateAttributes() {
        super.allocateAttributes();
        this.modulus_ = new ByteArrayAttribute(Attribute.MODULUS);
        this.publicExponent_ = new ByteArrayAttribute(Attribute.PUBLIC_EXPONENT);
        this.privateExponent_ = new ByteArrayAttribute(Attribute.PRIVATE_EXPONENT);
        this.prime1_ = new ByteArrayAttribute(Attribute.PRIME_1);
        this.prime2_ = new ByteArrayAttribute(Attribute.PRIME_2);
        this.exponent1_ = new ByteArrayAttribute(Attribute.EXPONENT_1);
        this.exponent2_ = new ByteArrayAttribute(Attribute.EXPONENT_2);
        this.coefficient_ = new ByteArrayAttribute(Attribute.COEFFICIENT);
        RSAPrivateKey.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)super.clone();
        rSAPrivateKey.modulus_ = (ByteArrayAttribute)this.modulus_.clone();
        rSAPrivateKey.publicExponent_ = (ByteArrayAttribute)this.publicExponent_.clone();
        rSAPrivateKey.privateExponent_ = (ByteArrayAttribute)this.privateExponent_.clone();
        rSAPrivateKey.prime1_ = (ByteArrayAttribute)this.prime1_.clone();
        rSAPrivateKey.prime2_ = (ByteArrayAttribute)this.prime2_.clone();
        rSAPrivateKey.exponent1_ = (ByteArrayAttribute)this.exponent1_.clone();
        rSAPrivateKey.exponent2_ = (ByteArrayAttribute)this.exponent2_.clone();
        rSAPrivateKey.coefficient_ = (ByteArrayAttribute)this.coefficient_.clone();
        RSAPrivateKey.putAttributesInTable(rSAPrivateKey);
        return rSAPrivateKey;
    }

    public boolean equals(java.lang.Object object) {
        boolean bl = false;
        if (object instanceof RSAPrivateKey) {
            RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)object;
            bl = this == rSAPrivateKey || super.equals(rSAPrivateKey) && this.modulus_.equals(rSAPrivateKey.modulus_) && this.publicExponent_.equals(rSAPrivateKey.publicExponent_) && this.privateExponent_.equals(rSAPrivateKey.privateExponent_) && this.prime1_.equals(rSAPrivateKey.prime1_) && this.prime2_.equals(rSAPrivateKey.prime2_) && this.exponent1_.equals(rSAPrivateKey.exponent1_) && this.exponent2_.equals(rSAPrivateKey.exponent2_) && this.coefficient_.equals(rSAPrivateKey.coefficient_);
        }
        return bl;
    }

    public ByteArrayAttribute getCoefficient() {
        return this.coefficient_;
    }

    public ByteArrayAttribute getExponent1() {
        return this.exponent1_;
    }

    public ByteArrayAttribute getExponent2() {
        return this.exponent2_;
    }

    public static Object getInstance(Session session, long l) {
        return new RSAPrivateKey(session, l);
    }

    public ByteArrayAttribute getModulus() {
        return this.modulus_;
    }

    public ByteArrayAttribute getPrime1() {
        return this.prime1_;
    }

    public ByteArrayAttribute getPrime2() {
        return this.prime2_;
    }

    public ByteArrayAttribute getPrivateExponent() {
        return this.privateExponent_;
    }

    public ByteArrayAttribute getPublicExponent() {
        return this.publicExponent_;
    }

    protected static void putAttributesInTable(RSAPrivateKey rSAPrivateKey) {
        if (rSAPrivateKey == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        rSAPrivateKey.attributeTable_.put(Attribute.MODULUS, rSAPrivateKey.modulus_);
        rSAPrivateKey.attributeTable_.put(Attribute.PUBLIC_EXPONENT, rSAPrivateKey.publicExponent_);
        rSAPrivateKey.attributeTable_.put(Attribute.PRIVATE_EXPONENT, rSAPrivateKey.privateExponent_);
        rSAPrivateKey.attributeTable_.put(Attribute.PRIME_1, rSAPrivateKey.prime1_);
        rSAPrivateKey.attributeTable_.put(Attribute.PRIME_2, rSAPrivateKey.prime2_);
        rSAPrivateKey.attributeTable_.put(Attribute.EXPONENT_1, rSAPrivateKey.exponent1_);
        rSAPrivateKey.attributeTable_.put(Attribute.EXPONENT_2, rSAPrivateKey.exponent2_);
        rSAPrivateKey.attributeTable_.put(Attribute.COEFFICIENT, rSAPrivateKey.coefficient_);
    }

    public void readAttributes(Session session) {
        super.readAttributes(session);
        Object.getAttributeValues(session, this.objectHandle_, new Attribute[]{this.modulus_, this.publicExponent_});
        Object.getAttributeValues(session, this.objectHandle_, new Attribute[]{this.privateExponent_, this.prime1_, this.prime2_, this.exponent1_, this.exponent2_, this.coefficient_});
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(super.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Modulus (hex): ");
        stringBuffer.append(this.modulus_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Public Exponent (hex): ");
        stringBuffer.append(this.publicExponent_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Private Exponent (hex): ");
        stringBuffer.append(this.privateExponent_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Prime 1 (hex): ");
        stringBuffer.append(this.prime1_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Prime 2 (hex): ");
        stringBuffer.append(this.prime2_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Exponent 1 (hex): ");
        stringBuffer.append(this.exponent1_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Exponent 2 (hex): ");
        stringBuffer.append(this.exponent2_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Coefficient (hex): ");
        stringBuffer.append(this.coefficient_.toString());
        return stringBuffer.toString();
    }
}

