/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.wrapper.Constants;

public class RC2SecretKey
extends SecretKey {
    protected ByteArrayAttribute value_;
    protected LongAttribute valueLen_;

    public RC2SecretKey() {
        this.keyType_.setLongValue(Key.KeyType.RC2);
    }

    protected RC2SecretKey(Session session, long l) {
        super(session, l);
        this.keyType_.setLongValue(Key.KeyType.RC2);
    }

    protected void allocateAttributes() {
        super.allocateAttributes();
        this.value_ = new ByteArrayAttribute(Attribute.VALUE);
        this.valueLen_ = new LongAttribute(Attribute.VALUE_LEN);
        RC2SecretKey.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        RC2SecretKey rC2SecretKey = (RC2SecretKey)super.clone();
        rC2SecretKey.value_ = (ByteArrayAttribute)this.value_.clone();
        rC2SecretKey.valueLen_ = (LongAttribute)this.valueLen_.clone();
        RC2SecretKey.putAttributesInTable(rC2SecretKey);
        return rC2SecretKey;
    }

    public boolean equals(java.lang.Object object) {
        boolean bl = false;
        if (object instanceof RC2SecretKey) {
            RC2SecretKey rC2SecretKey = (RC2SecretKey)object;
            bl = this == rC2SecretKey || super.equals(rC2SecretKey) && this.value_.equals(rC2SecretKey.value_) && this.valueLen_.equals(rC2SecretKey.valueLen_);
        }
        return bl;
    }

    public static Object getInstance(Session session, long l) {
        return new RC2SecretKey(session, l);
    }

    public ByteArrayAttribute getValue() {
        return this.value_;
    }

    public LongAttribute getValueLen() {
        return this.valueLen_;
    }

    protected static void putAttributesInTable(RC2SecretKey rC2SecretKey) {
        if (rC2SecretKey == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        rC2SecretKey.attributeTable_.put(Attribute.VALUE, rC2SecretKey.value_);
        rC2SecretKey.attributeTable_.put(Attribute.VALUE_LEN, rC2SecretKey.valueLen_);
    }

    public void readAttributes(Session session) {
        super.readAttributes(session);
        Object.getAttributeValue(session, this.objectHandle_, this.value_);
        Object.getAttributeValue(session, this.objectHandle_, this.valueLen_);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(super.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Value (hex): ");
        stringBuffer.append(this.value_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Value Length (dec): ");
        stringBuffer.append(this.valueLen_.toString(10));
        return stringBuffer.toString();
    }
}

