/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.wrapper.Constants;
import java.util.Enumeration;

public class GenericTemplate
extends Object {
    public GenericTemplate() {
        this.attributeTable_.clear();
    }

    public void addAllAttributes(Object object) {
        if (object == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        Enumeration enumeration = object.attributeTable_.keys();
        while (enumeration.hasMoreElements()) {
            java.lang.Object k = enumeration.nextElement();
            this.attributeTable_.put(k, object.attributeTable_.get(k));
        }
    }

    public void addAllPresentAttributes(Object object) {
        if (object == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        Enumeration enumeration = object.attributeTable_.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            if (!attribute.isPresent()) continue;
            this.attributeTable_.put(attribute.getType(), attribute);
        }
    }

    public void addAttribute(Attribute attribute) {
        if (attribute == null) {
            throw new NullPointerException("Argument \"attribute\" must not be null.");
        }
        this.attributeTable_.put(attribute.getType(), attribute);
    }

    public java.lang.Object clone() {
        GenericTemplate genericTemplate = (GenericTemplate)super.clone();
        genericTemplate.attributeTable_.clear();
        Enumeration enumeration = this.attributeTable_.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            Attribute attribute2 = (Attribute)attribute.clone();
            genericTemplate.attributeTable_.put(attribute2.getType(), attribute2);
        }
        return genericTemplate;
    }

    public boolean containsAttribute(Attribute attribute) {
        if (attribute == null) {
            throw new NullPointerException("Argument \"attribute\" must not be null.");
        }
        return this.attributeTable_.containsKey(attribute.getType());
    }

    public boolean equals(java.lang.Object object) {
        boolean bl = false;
        if (object instanceof GenericTemplate) {
            GenericTemplate genericTemplate = (GenericTemplate)object;
            bl = this == genericTemplate || this.attributeTable_.equals(genericTemplate.attributeTable_);
        }
        return bl;
    }

    public int hashCode() {
        return this.attributeTable_.hashCode();
    }

    public void readAttributes(Session session) {
        if (this.objectHandle_ == -1L) {
            throw new TokenException("Object handle is not set to an valid value. Use setObjectHandle(long) to set.");
        }
        super.readAttributes(session);
        Enumeration enumeration = this.attributeTable_.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            Object.getAttributeValue(session, this.objectHandle_, attribute);
        }
    }

    public void removeAllAttributes(Object object) {
        if (object == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        Enumeration enumeration = object.attributeTable_.keys();
        while (enumeration.hasMoreElements()) {
            this.attributeTable_.remove(enumeration.nextElement());
        }
    }

    public void removeAllPresentAttributes(Object object) {
        if (object == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        Enumeration enumeration = object.attributeTable_.keys();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)object.attributeTable_.get(enumeration.nextElement());
            if (!attribute.isPresent()) continue;
            this.attributeTable_.remove(attribute);
        }
    }

    public Attribute removeAttribute(Attribute attribute) {
        if (attribute == null) {
            throw new NullPointerException("Argument \"attribute\" must not be null.");
        }
        return (Attribute)this.attributeTable_.remove(attribute.getType());
    }

    protected void setAllPresentFlags(boolean bl) {
        Enumeration enumeration = this.attributeTable_.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            attribute.setPresent(bl);
        }
    }

    public String toString() {
        return this.toString(false, true, "  ");
    }

    public String toString(boolean bl, boolean bl2, String string) {
        StringBuffer stringBuffer = new StringBuffer(1024);
        Enumeration enumeration = this.attributeTable_.elements();
        boolean bl3 = bl ^ true;
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            if (!attribute.isPresent()) continue;
            if (!bl3) {
                stringBuffer.append(Constants.NEWLINE);
            }
            stringBuffer.append(string);
            stringBuffer.append(attribute.toString(bl2));
            bl3 = false;
        }
        return stringBuffer.toString();
    }
}

