/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.objects.PrivateKey;
import iaik.pkcs.pkcs11.wrapper.Constants;

public class DSAPrivateKey
extends PrivateKey {
    protected ByteArrayAttribute prime_;
    protected ByteArrayAttribute subprime_;
    protected ByteArrayAttribute base_;
    protected ByteArrayAttribute value_;

    public DSAPrivateKey() {
        this.keyType_.setLongValue(Key.KeyType.DSA);
    }

    protected DSAPrivateKey(Session session, long l) {
        super(session, l);
        this.keyType_.setLongValue(Key.KeyType.DSA);
    }

    protected void allocateAttributes() {
        super.allocateAttributes();
        this.prime_ = new ByteArrayAttribute(Attribute.PRIME);
        this.subprime_ = new ByteArrayAttribute(Attribute.SUBPRIME);
        this.base_ = new ByteArrayAttribute(Attribute.BASE);
        this.value_ = new ByteArrayAttribute(Attribute.VALUE);
        DSAPrivateKey.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)super.clone();
        dSAPrivateKey.prime_ = (ByteArrayAttribute)this.prime_.clone();
        dSAPrivateKey.subprime_ = (ByteArrayAttribute)this.subprime_.clone();
        dSAPrivateKey.base_ = (ByteArrayAttribute)this.base_.clone();
        dSAPrivateKey.value_ = (ByteArrayAttribute)this.value_.clone();
        DSAPrivateKey.putAttributesInTable(dSAPrivateKey);
        return dSAPrivateKey;
    }

    public boolean equals(java.lang.Object object) {
        boolean bl = false;
        if (object instanceof DSAPrivateKey) {
            DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)object;
            bl = this == dSAPrivateKey || super.equals(dSAPrivateKey) && this.prime_.equals(dSAPrivateKey.prime_) && this.subprime_.equals(dSAPrivateKey.subprime_) && this.base_.equals(dSAPrivateKey.base_) && this.value_.equals(dSAPrivateKey.value_);
        }
        return bl;
    }

    public ByteArrayAttribute getBase() {
        return this.base_;
    }

    public static Object getInstance(Session session, long l) {
        return new DSAPrivateKey(session, l);
    }

    public ByteArrayAttribute getPrime() {
        return this.prime_;
    }

    public ByteArrayAttribute getSubprime() {
        return this.subprime_;
    }

    public ByteArrayAttribute getValue() {
        return this.value_;
    }

    protected static void putAttributesInTable(DSAPrivateKey dSAPrivateKey) {
        if (dSAPrivateKey == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        dSAPrivateKey.attributeTable_.put(Attribute.PRIME, dSAPrivateKey.prime_);
        dSAPrivateKey.attributeTable_.put(Attribute.SUBPRIME, dSAPrivateKey.subprime_);
        dSAPrivateKey.attributeTable_.put(Attribute.BASE, dSAPrivateKey.base_);
        dSAPrivateKey.attributeTable_.put(Attribute.VALUE, dSAPrivateKey.value_);
    }

    public void readAttributes(Session session) {
        super.readAttributes(session);
        Object.getAttributeValues(session, this.objectHandle_, new Attribute[]{this.prime_, this.subprime_, this.base_});
        Object.getAttributeValue(session, this.objectHandle_, this.value_);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(super.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Prime (hex): ");
        stringBuffer.append(this.prime_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Subprime (hex): ");
        stringBuffer.append(this.subprime_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Base (hex): ");
        stringBuffer.append(this.base_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Value (hex): ");
        stringBuffer.append(this.value_.toString());
        return stringBuffer.toString();
    }
}

